#!/usr/pkg/bin/ruby32
# $Id: importNOS.rb 7583 2022-01-01 19:41:03Z flaterco $
# Main program for importing NOS data.  Import is divided into 4 passes to
# allow necessary fix-ups and checkpointing in between.

def usage
  puts "Usage: importNOS.rb N"
  puts "N=1  tidal reference stations"
  puts "N=2  tidal subordinate stations"
  puts "N=3  current reference stations"
  puts "N=4  current subordinate stations"
  exit
end

usage() if ARGV.length != 1
pass = ARGV[0].to_i
usage() if pass.nil? or pass < 1 or pass > 4

# pg result has a #check method, but I find that the result is nil whenever
# something goes wrong, so what is the point of the check method?

# Standard/installed packages
require "set"
require "json"
require "pg"

# Breakouts from importNOS to create a thin veneer of cohesiveness.
require_relative "importNOS_Util"
require_relative "importNOS_JsonReaders"
require_relative "importNOS_Geogroups"
require_relative "importNOS_Queries"
require_relative "importNOS_DodgyCode"  # [TM]
require_relative "importNOS_TideRefs"
require_relative "importNOS_TideSubs"
require_relative "importNOS_CurRefs"
require_relative "importNOS_CurSubs"

# We have:
# tides.json, metadata on all tide stations
# currents.json, metadata on all current stations
# harcon.json, additional metadata on tide reference stations
# geogroups-tides.json, geogroups for tide stations
# geogroups/*/children.json, assigns tide stations to geogroups
# tiderefs/*/harcon.json, harmonic constants for tides
# tiderefs/*/datums.json, datums for tides
# currefs/*/harcon.json*, harmonic constants and datums for currents
# oldcurlists:  old current stations list
#
# The MDAPI query to produce stations-by-group-currents.json doesn't work, so
# geogroups for currents are still determined the old way, by scraping HTML
# headers out of oldcurlists.

db = PG::Connection.open(:dbname => "harmbase2")
case pass
when 1
  importTideRefs(db)
when 2
  importTideSubs(db)
when 3
  importCurRefs(db)
when 4
  importCurSubs(db)
else
  raise "Bogus pass number"
end
