/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuEmbeddedBrowser
extends ExtensionPopupMenu {
    private ExtensionHistory extension = null;
    private Component lastInvoker = null;

    public PopupMenuEmbeddedBrowser() {
        this.initialize();
    }

    public PopupMenuEmbeddedBrowser(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.setText("View in Browser");
        if (!ExtensionHistory.isEnableForNativePlatform()) {
            this.setEnabled(false);
        }
        this.setActionCommand("");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistoryReference historyReference = null;
                if (PopupMenuEmbeddedBrowser.this.lastInvoker == null) {
                    return;
                }
                if (PopupMenuEmbeddedBrowser.this.lastInvoker.getName().equalsIgnoreCase("ListLog")) {
                    JList jList = PopupMenuEmbeddedBrowser.this.extension.getLogPanel().getListLog();
                    if (jList.getSelectedValues().length != 1) {
                        PopupMenuEmbeddedBrowser.this.extension.getView().showWarningDialog("Please select a message in History panel first.");
                        return;
                    }
                    historyReference = (HistoryReference)jList.getSelectedValue();
                    PopupMenuEmbeddedBrowser.this.showBrowser(historyReference);
                } else if (PopupMenuEmbeddedBrowser.this.lastInvoker.getName().equals("treeSite")) {
                    JTree jTree = (JTree)PopupMenuEmbeddedBrowser.this.lastInvoker;
                    SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
                    historyReference = siteNode.getHistoryReference();
                    PopupMenuEmbeddedBrowser.this.showBrowser(historyReference);
                }
            }
        });
    }

    private void showBrowser(HistoryReference historyReference) {
        HttpMessage httpMessage = null;
        try {
            httpMessage = historyReference.getHttpMessage();
            if (!this.extension.browserDisplay(historyReference, httpMessage)) {
                this.extension.getView().showWarningDialog("Selecetd HTTP message type cannot be shown.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isEnableForComponent(Component component) {
        this.lastInvoker = null;
        if (!ExtensionHistory.isEnableForNativePlatform()) {
            return false;
        }
        if (component.getName() == null) {
            return false;
        }
        if (component.getName().equalsIgnoreCase("ListLog")) {
            try {
                JList jList = (JList)component;
                if (jList.getSelectedIndex() >= 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                this.lastInvoker = component;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (component.getName().equals("treeSite")) {
            JTree jTree = (JTree)component;
            this.lastInvoker = jTree;
            return true;
        }
        return false;
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }
}

