/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.bean;

import java.util.Objects;
import org.wiztools.commons.CollectionsUtil;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapArrayList;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ReqEntityPart;

public abstract class ReqEntityBasePart
implements ReqEntityPart {
    protected final String name;
    protected final ContentType contentType;
    protected final MultiValueMap<String, String> fields = new MultiValueMapArrayList<String, String>();

    public ReqEntityBasePart(String name, ContentType contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    public void addField(String key, String value) {
        this.fields.put(key, value);
    }

    @Override
    public MultiValueMap<String, String> getFields() {
        return CollectionsUtil.unmodifiableMultiValueMap(this.fields);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.name);
        hash = 79 * hash + Objects.hashCode(this.contentType);
        hash = 79 * hash + Objects.hashCode(this.fields);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReqEntityBasePart other = (ReqEntityBasePart)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.contentType, other.contentType)) {
            return false;
        }
        return Objects.equals(this.fields, other.fields);
    }
}

