/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.resource.swing;

import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.igoweb.resource.PkgRes;
import org.igoweb.resource.ResEntry;
import org.igoweb.resource.Resource;

public class ResEditor
extends JPanel {
    private ResEntry[] resContents;
    private final Locale[] validLocales;
    private final JComboBox<String> localeChooser;
    private final JTextArea englishOut = new JTextArea("", 3, 20);
    private final JTextArea notesOut = new JTextArea("", 3, 20);
    private final JTextArea enExampleOut = new JTextArea("", 3, 20);
    private final JTextArea translationIn = new JTextArea("", 3, 20);
    private JTextArea transExampleOut = new JTextArea("", 3, 20);
    private int currentLocaleIndex = 0;
    private Resource res = null;
    private PkgRes pkgRes = null;
    private String[] enExampleStrings = null;
    private boolean changed = false;
    private int currentResIndex = 0;
    private final JLabel progressLabel = new JLabel("", 4);
    private int numNonBlank;
    private static final char LRM_CHAR = '\u200e';
    private static final String LRM_EQUIV = "x->y";
    private static final char RLM_CHAR = '\u200f';
    private static final String RLM_EQUIV = "y<-x";
    private ArrayList<String> skipPackages;
    private Collection<ResEditor> peers;
    private boolean processingLocaleChange = false;

    public ResEditor(String name, Resource resource, String localeListString, Collection<String> skipPackages) {
        super(new BorderLayout());
        this.setName(name);
        Locale.setDefault(Locale.US);
        this.res = resource;
        this.validLocales = ResEditor.getValidLocales(localeListString);
        this.skipPackages = new ArrayList<String>(skipPackages);
        this.peers = Collections.singleton(this);
        JPanel mainPanel = new JPanel(new GridLayout(1, 2));
        this.add("North", mainPanel);
        JPanel subPanel = new JPanel(new BorderLayout());
        mainPanel.add(subPanel);
        subPanel.add("West", new JLabel("Locale:"));
        String[] localeNames = new String[this.validLocales.length];
        for (int i = 0; i < this.validLocales.length; ++i) {
            localeNames[i] = this.validLocales[i].toString() + ": " + this.validLocales[i].getDisplayName();
        }
        this.localeChooser = new JComboBox<String>(localeNames);
        subPanel.add(this.localeChooser);
        this.localeChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.newLocaleSelected(ResEditor.this.localeChooser.getSelectedIndex());
            }
        });
        subPanel.add("East", this.progressLabel);
        mainPanel = new JPanel(new GridLayout(3, 1));
        this.add("Center", mainPanel);
        subPanel = new JPanel(new BorderLayout());
        mainPanel.add(subPanel);
        subPanel.setBorder(BorderFactory.createTitledBorder("Original English Message"));
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2));
        subPanel.add("North", bottomPanel);
        bottomPanel.add(this.makeSearchWidget(true));
        bottomPanel.add(new JLabel("Examples:", 0));
        bottomPanel = new JPanel(new GridLayout(1, 2));
        subPanel.add(bottomPanel);
        ResEditor.addTextArea(bottomPanel, this.englishOut);
        ResEditor.addTextArea(bottomPanel, this.enExampleOut);
        this.englishOut.setEditable(false);
        this.enExampleOut.setEditable(false);
        subPanel = new JPanel(new BorderLayout());
        mainPanel.add(subPanel);
        subPanel.setBorder(BorderFactory.createTitledBorder("Translated Message"));
        bottomPanel = new JPanel(new GridLayout(1, 2));
        subPanel.add("North", bottomPanel);
        bottomPanel.add(this.makeSearchWidget(false));
        JButton button = new JButton("Examples (click to update):");
        bottomPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.sync();
                ResEditor.this.translateExamples();
            }
        });
        bottomPanel = new JPanel(new GridLayout(1, 2));
        subPanel.add(bottomPanel);
        ResEditor.addTextArea(bottomPanel, this.translationIn);
        ResEditor.addTextArea(bottomPanel, this.transExampleOut);
        this.transExampleOut.setEditable(false);
        JComponent notesPanel = ResEditor.addTextArea(mainPanel, this.notesOut);
        this.notesOut.setEditable(false);
        notesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Notes:"), notesPanel.getBorder()));
        mainPanel = new JPanel(new GridLayout(1, 5));
        this.add("South", mainPanel);
        button = new JButton("\u25c4");
        mainPanel.add(button);
        button.setToolTipText("<html><b>control</b>-click to skip to previous blank message</html>");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.skipPressed(-1, event.getModifiers());
            }
        });
        button = new JButton("Test");
        mainPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.test();
            }
        });
        button = new JButton("\u25ba");
        mainPanel.add(button);
        button.setToolTipText("<html><b>control</b>-click to skip to next blank message</html>");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.skipPressed(1, event.getModifiers());
            }
        });
        button = new JButton("Save");
        mainPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.savePressed();
            }
        });
        button = new JButton("Quit");
        mainPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.quitPressed();
            }
        });
        this.reloadResource();
    }

    public void setPeers(Collection<? extends ResEditor> peers) {
        if (!peers.contains(this)) {
            throw new IllegalArgumentException("peers must contain us");
        }
        this.peers = new ArrayList<ResEditor>(peers);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dims = super.getPreferredSize();
        Insets insets = this.getInsets();
        dims.width -= insets.left + insets.right;
        dims.height -= insets.top + insets.bottom;
        if (dims.width < dims.height * 2) {
            dims.width = dims.height * 2;
        } else {
            dims.height = dims.width / 2;
        }
        dims.width += insets.left + insets.right;
        dims.height += insets.top + insets.bottom;
        return dims;
    }

    public void quitPressed() {
        ChangeStatus status = null;
        for (ResEditor re : this.peers) {
            status = re.quitPressed(status);
        }
        if (status != ChangeStatus.CANCEL) {
            System.exit(0);
        }
    }

    private ChangeStatus quitPressed(ChangeStatus status) {
        if (status == null) {
            status = ChangeStatus.NO_CHANGES;
        }
        this.sync();
        if (this.changed) {
            switch (status) {
                case SAVE: {
                    this.savePressed();
                    break;
                }
                case NO_CHANGES: {
                    switch (JOptionPane.showConfirmDialog(this, "You have changed the translations\nsince you last saved. Do you want\nto save them before you quit?", "Save Changes?", 1)) {
                        case 0: {
                            this.savePressed();
                            return ChangeStatus.SAVE;
                        }
                        case 1: {
                            return ChangeStatus.DONT_SAVE;
                        }
                        case 2: {
                            return ChangeStatus.CANCEL;
                        }
                    }
                    throw new RuntimeException();
                }
                case DONT_SAVE: 
                case CANCEL: {
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return status;
    }

    private void savePressed() {
        this.sync();
        this.removeEmptyProperties();
        try {
            this.pkgRes.save(this.validLocales[this.currentLocaleIndex]);
        }
        catch (IOException excep) {
            throw new RuntimeException("Error: " + excep);
        }
        this.changed = false;
    }

    private void removeEmptyProperties() {
        boolean change;
        do {
            change = false;
            for (String key : this.pkgRes.getAllKeys()) {
                String value = this.pkgRes.get(key);
                if (value == null || value.length() != 0) continue;
                change = true;
                this.pkgRes.remove(key);
            }
        } while (change);
    }

    private void skipPressed(int direction, int modifiers) {
        int newResIndex = -1;
        if ((modifiers & 2) == 0) {
            newResIndex = (this.currentResIndex + this.resContents.length + direction) % this.resContents.length;
        } else {
            for (int offset = 1; newResIndex == -1 && offset <= this.resContents.length; ++offset) {
                int index = (this.currentResIndex + direction * offset + this.resContents.length) % this.resContents.length;
                if (this.pkgRes.get(this.resContents[index].key) != null) continue;
                newResIndex = index;
            }
            if (newResIndex == -1) {
                JOptionPane.showMessageDialog(this, "You have filled in all of the messages\nin this message group. Try the \"Test\"\nbutton, and if that finds no problems,\nthen you are done!", "All Messages Filled In", 1);
            } else if (newResIndex == this.currentResIndex) {
                JOptionPane.showMessageDialog(this, "This is the only blank message left.", "All Other Messages Filled In", 1);
            }
        }
        if (newResIndex != -1) {
            this.updateOutputs(newResIndex);
        }
    }

    private void sync() {
        String current = this.getTranslationInText();
        while (current.endsWith("\n")) {
            current = current.substring(0, current.length() - 1);
        }
        String key = this.resContents[this.currentResIndex].key;
        String old = this.pkgRes.get(key);
        boolean isNew = old == null && current.length() > 0 || old != null && !old.equals(current);
        this.changed |= isNew;
        if (isNew) {
            if (!this.pkgRes.put(key, current)) {
                System.err.println("Failed to set value of " + key);
            }
            this.updateProgress();
        }
    }

    private String getTranslationInText() {
        return this.translationIn.getText().replaceAll(LRM_EQUIV, "\u200e").replaceAll(RLM_EQUIV, "\u200f");
    }

    private void updateOutputs(int newResIndex) {
        this.sync();
        this.currentResIndex = newResIndex;
        this.updateOutputs();
    }

    private void updateOutputs() {
        ResEntry contents = this.resContents[this.currentResIndex];
        this.englishOut.setText(contents.original);
        this.notesOut.setText(contents.comment);
        this.enExampleOut.setText(this.enExampleStrings[this.currentResIndex]);
        String translation = this.pkgRes.get(contents.key);
        if (translation == null) {
            this.translationIn.setText("");
            this.transExampleOut.setText("");
        } else {
            this.translationIn.setText(translation.replaceAll("\u200e", LRM_EQUIV).replaceAll("\u200f", RLM_EQUIV));
            this.translateExamples();
        }
    }

    private void reloadResource() {
        this.changed = false;
        this.pkgRes = new PkgRes(this.res, this.skipPackages);
        try {
            int i;
            this.pkgRes.load(this.validLocales[this.currentLocaleIndex]);
            this.resContents = this.pkgRes.getResources();
            this.enExampleStrings = new String[this.resContents.length];
            Locale.setDefault(Locale.US);
            StringBuilder result = new StringBuilder();
            for (i = 0; i < this.resContents.length; ++i) {
                result.setLength(0);
                ResEntry entry = this.resContents[i];
                for (int j = 0; j < entry.getNumSamples(); ++j) {
                    try {
                        result.append(entry.getFormatted(j, Locale.US));
                    }
                    catch (Exception excep) {
                        System.err.println("Excep \"" + excep + "\" on string \"" + entry.original + "\"");
                        System.exit(1);
                    }
                    result.append("\n\n");
                }
                if (result.length() > 0) {
                    result.setLength(result.length() - 2);
                }
                this.enExampleStrings[i] = result.toString();
            }
            Locale.setDefault(this.validLocales[this.currentLocaleIndex]);
            this.updateOutputs();
            this.numNonBlank = 0;
            for (i = 0; i < this.resContents.length; ++i) {
                if (this.pkgRes.get(this.resContents[i].key) == null) continue;
                ++this.numNonBlank;
            }
            this.updateProgress();
        }
        catch (IOException excep) {
            throw new RuntimeException("Error: " + excep);
        }
    }

    private void translateExamples() {
        this.transExampleOut.setText("");
        ResEntry entry = this.resContents[this.currentResIndex];
        for (int i = 0; i < entry.getNumSamples(); ++i) {
            String newText;
            try {
                String xlat = this.pkgRes.get(entry.key);
                newText = xlat == null ? null : entry.getFormatted(xlat, i, this.validLocales[this.currentLocaleIndex]);
            }
            catch (Exception excep) {
                excep.printStackTrace();
                newText = "***ILLEGAL MESSAGE FORMAT: " + excep + "***";
            }
            if (i > 0) {
                this.transExampleOut.append("\n\n");
            }
            this.transExampleOut.append(newText);
        }
    }

    private void test() {
        this.sync();
        this.removeEmptyProperties();
        final JProgressBar progress = new JProgressBar(0, this.resContents.length);
        JPanel outPanel = new JPanel(new BorderLayout());
        outPanel.add("North", new JLabel("Testing"));
        outPanel.add(progress);
        JOptionPane opt = new JOptionPane(outPanel, 1, 2);
        opt.setOptions(new Object[]{"Cancel"});
        final JDialog dialog = opt.createDialog(this, "Testing");
        Thread worker = new Thread(new Runnable(){

            @Override
            public void run() {
                ResEditor.this.doTest(dialog, progress);
            }
        }, "Tester");
        worker.start();
        dialog.setVisible(true);
        worker.interrupt();
        try {
            worker.join();
        }
        catch (InterruptedException excep) {
            throw new RuntimeException(excep);
        }
    }

    private void doTest(final JDialog dialog, final JProgressBar progress) {
        try {
            int i;
            for (i = 0; i < this.resContents.length; ++i) {
                String err;
                final int finalI = i;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        progress.setValue(finalI);
                    }
                });
                String xlat = this.pkgRes.get(this.resContents[i].key);
                if (xlat == null || xlat.equals("") || (err = this.resContents[i].isValid(xlat, this.validLocales[this.currentLocaleIndex])) == null) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dialog.dispose();
                        ResEditor.this.updateOutputs(finalI);
                        JOptionPane.showMessageDialog(ResEditor.this, "There was an error when checking your\ntranslations:\n" + err, "Translation Error", 0);
                    }
                });
                return;
            }
            for (i = 0; i < this.resContents.length; ++i) {
                final int checkId = (i + this.currentResIndex) % this.resContents.length;
                if (this.pkgRes.get(this.resContents[checkId].key) != null) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dialog.dispose();
                        ResEditor.this.updateOutputs(checkId);
                        JOptionPane.showMessageDialog(ResEditor.this, "This translation hasn't been\ncompleted yet.", "Translation Warning", 2);
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    dialog.dispose();
                    JOptionPane.showMessageDialog(ResEditor.this, "No problems could be found in this\nresource file.", "Translation OK", 1);
                }
            });
        }
        catch (InterruptedException i) {
        }
        catch (InvocationTargetException excep) {
            throw new RuntimeException(excep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLocaleSelected(int newLocaleIndex) {
        if (this.processingLocaleChange) {
            return;
        }
        for (ResEditor re : this.peers) {
            re.processingLocaleChange = true;
        }
        try {
            int prevLocale = this.currentLocaleIndex;
            ChangeStatus status = null;
            for (ResEditor re : this.peers) {
                status = re.newLocaleSelected(newLocaleIndex, status);
            }
            if (status == ChangeStatus.CANCEL) {
                for (ResEditor re : this.peers) {
                    re.newLocaleSelected(prevLocale, ChangeStatus.NO_CHANGES);
                }
            }
        }
        catch (Throwable throwable) {
            for (ResEditor re : this.peers) {
                re.processingLocaleChange = false;
            }
            throw throwable;
        }
        for (ResEditor re : this.peers) {
            re.processingLocaleChange = false;
        }
    }

    private ChangeStatus newLocaleSelected(int newLocaleIndex, ChangeStatus status) {
        if (status == null) {
            status = ChangeStatus.NO_CHANGES;
        }
        if (status == ChangeStatus.CANCEL || newLocaleIndex == this.currentLocaleIndex) {
            return status;
        }
        this.sync();
        if (this.changed) {
            block0 : switch (status) {
                case SAVE: {
                    this.savePressed();
                    break;
                }
                case NO_CHANGES: {
                    switch (JOptionPane.showConfirmDialog(this, "You have changed the translations\nfor this locale. If you change\nlocales now you will lose these\nchanges. Do you want to save your\nchanges first?", "Save Changes?", 1)) {
                        case 0: {
                            this.localeChooser.setSelectedIndex(newLocaleIndex);
                            this.savePressed();
                            status = ChangeStatus.SAVE;
                            break block0;
                        }
                        case 1: {
                            this.localeChooser.setSelectedIndex(newLocaleIndex);
                            status = ChangeStatus.DONT_SAVE;
                            break block0;
                        }
                        case 2: {
                            this.localeChooser.setSelectedIndex(this.currentLocaleIndex);
                            return ChangeStatus.CANCEL;
                        }
                    }
                    throw new RuntimeException();
                }
                case DONT_SAVE: {
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.currentLocaleIndex = newLocaleIndex;
        Locale locale = this.validLocales[newLocaleIndex];
        this.translationIn.setLocale(locale);
        this.transExampleOut.setLocale(locale);
        ComponentOrientation orient = ComponentOrientation.getOrientation(locale);
        this.translationIn.applyComponentOrientation(orient);
        this.transExampleOut.applyComponentOrientation(orient);
        this.reloadResource();
        this.localeChooser.setSelectedIndex(this.currentLocaleIndex);
        return status;
    }

    private static Locale[] getValidLocales(String localeList) {
        String[] localeGroups = localeList.split(" ");
        Locale[] result = new Locale[localeGroups.length - 1];
        for (int i = 0; i < result.length; ++i) {
            String[] localeParts;
            if (localeGroups[i + 1].charAt(0) == '!') {
                localeGroups[i + 1] = localeGroups[i + 1].substring(1);
            }
            result[i] = (localeParts = localeGroups[i + 1].split("/")[0].split("_")).length == 2 ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeParts[0]);
        }
        return result;
    }

    private static JComponent addTextArea(Container cont, JTextArea textArea) {
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane result = new JScrollPane(textArea, 20, 31);
        cont.add(result);
        return result;
    }

    private void updateProgress() {
        this.progressLabel.setText(this.pkgRes.getSize() + "/" + this.resContents.length);
    }

    public Collection<String> getPackagesUsed() {
        return this.pkgRes.getPackagesUsed();
    }

    private JPanel makeSearchWidget(final boolean isEnglish) {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(new JLabel("Text:"));
        JPanel subPanel = new JPanel(new BorderLayout());
        panel.add(subPanel);
        final JTextField tf = new JTextField();
        subPanel.add(tf);
        JButton searchBut = new JButton("Search:");
        subPanel.add("West", searchBut);
        searchBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ResEditor.this.search(tf.getText(), isEnglish);
            }
        });
        return panel;
    }

    private void search(String message, boolean isEnglish) {
        Locale searchLocale = isEnglish ? Locale.US : this.validLocales[this.currentLocaleIndex];
        if ((message = message.toLowerCase(searchLocale)).length() == 0) {
            return;
        }
        int resNum = this.currentResIndex;
        int resCount = this.resContents.length;
        ++resNum;
        --resCount;
        while (--resCount >= 0) {
            int index;
            String baseString;
            if (resNum >= this.resContents.length) {
                resNum = 0;
            }
            if ((baseString = isEnglish ? this.resContents[resNum].original : this.pkgRes.get(this.resContents[resNum].key)) != null && (index = baseString.toLowerCase(searchLocale).indexOf(message)) >= 0) {
                this.updateOutputs(resNum);
                return;
            }
            ++resNum;
        }
        this.getToolkit().beep();
    }

    public static enum ChangeStatus {
        NO_CHANGES,
        DONT_SAVE,
        SAVE,
        CANCEL;

    }
}

