/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import javax.annotation.Nullable;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.execution.ResolveTaskMutationsBuildOperationType;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchies;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resources.ResourceLock;

public class ResolveMutationsNode
extends Node
implements SelfExecutingNode {
    private final LocalTaskNode node;
    private final NodeValidator nodeValidator;
    private final BuildOperationRunner buildOperationRunner;
    private final ExecutionNodeAccessHierarchies accessHierarchies;
    private Exception failure;
    private static final ResolveTaskMutationsBuildOperationType.Result RESOLVE_TASK_MUTATIONS_RESULT = new ResolveTaskMutationsBuildOperationType.Result(){};

    public ResolveMutationsNode(LocalTaskNode node, NodeValidator nodeValidator, BuildOperationRunner buildOperationRunner, ExecutionNodeAccessHierarchies accessHierarchies) {
        this.node = node;
        this.nodeValidator = nodeValidator;
        this.buildOperationRunner = buildOperationRunner;
        this.accessHierarchies = accessHierarchies;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "Resolve mutations for " + this.node;
    }

    @Override
    @Nullable
    public Throwable getNodeFailure() {
        return this.failure;
    }

    @Override
    public boolean isCanCancel() {
        return this.node.isCanCancel();
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        return this.node.getProjectToLock();
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return this.node.getOwningProject();
    }

    @Override
    public void execute(NodeExecutionContext context) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                try {
                    ResolveMutationsNode.this.doResolveMutations();
                    context.setResult((Object)RESOLVE_TASK_MUTATIONS_RESULT);
                }
                catch (Exception e) {
                    ResolveMutationsNode.this.failure = e;
                    context.failed((Throwable)ResolveMutationsNode.this.failure);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                TaskIdentity<?> taskIdentity = ResolveMutationsNode.this.node.getTask().getTaskIdentity();
                return BuildOperationDescriptor.displayName((String)("Resolve mutations for task " + taskIdentity.getIdentityPath())).details((Object)new ResolveTaskMutationsDetails(taskIdentity));
            }
        });
    }

    private void doResolveMutations() {
        MutationInfo mutations = this.node.getMutationInfo();
        this.node.resolveMutations();
        mutations.hasValidationProblem = this.nodeValidator.hasValidationProblems(this.node);
        this.accessHierarchies.getOutputHierarchy().recordNodeAccessingLocations(this.node, mutations.outputPaths);
        this.accessHierarchies.getDestroyableHierarchy().recordNodeAccessingLocations(this.node, mutations.destroyablePaths);
    }

    private static final class ResolveTaskMutationsDetails
    implements ResolveTaskMutationsBuildOperationType.Details {
        private final TaskIdentity<?> taskIdentity;

        public ResolveTaskMutationsDetails(TaskIdentity<?> taskIdentity) {
            this.taskIdentity = taskIdentity;
        }

        public String getBuildPath() {
            return this.taskIdentity.getBuildPath();
        }

        public String getTaskPath() {
            return this.taskIdentity.getTaskPath();
        }

        public long getTaskId() {
            return this.taskIdentity.getId();
        }
    }
}

