;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                         Copyright (c) 1998                            ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission is hereby granted, free of charge, to use and distribute  ;;
;;;  this software and its documentation without restriction, including   ;;
;;;  without limitation the rights to use, copy, modify, merge, publish,  ;;
;;;  distribute, sublicense, and/or sell copies of this work, and to      ;;
;;;  permit persons to whom this work is furnished to do so, subject to   ;;
;;;  the following conditions:                                            ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;   4. The authors' names are not used to endorse or promote products   ;;
;;;      derived from this software without specific prior written        ;;
;;;      permission.                                                      ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  
;;;  Extra items that have sufficient frequency and are pronounced
;;;  wrongly that are to be added to the compiled version of 
;;;  the OALD lexicon
;;;
;;;  This list we derived from various text databases and actually
;;;  listening 

( "Jones" n (jh ou1 n z) )
( "Merrill" n (m e1 r i l) )
( "Guber" n (g u1 b @@) )
( "Drexel" n (d r e1 k s @ l) )
( "de" in (d @) )
( "Noriega" n (n oo r i ei1 g @) )
( "Lehman" n (l ei1 m @ n) )
( "Salomon" n (s a1 l @ m @ n) )
( "pretax" n (p r ii1 t a1 k s) )
( "Reagan" n (r ei1 g @ n) )
( "Hugo" n (h y uu1 g o) )
( "Nasdaq" n (n a1 s d e k) )
( "Telerate" n (t e1 l i r ei t) )
( "PaineWebber" n (p ei1 n - w e1 b @@) )
( "totaled" n (t ou1 t @ l d) )
( "Qintex" n (k w i1 n t e k s) )
( "Conn" n (k o1 n) )
( "Asia" n (ei1 sh i@) )
( "Saatchi" n (s a1 t ch ii) )
( "Mitsubishi" n (m i1 t s uu b ii1 sh ii) )
( "Mae" n (m ei1) )
( "Paribas" n (p a1 r @ b a s) )
( "Intel" n (i1 n t e l) )
( "McCaw" n (m @ k oo1) )
( "Citicorp" n (s i1 t ii - k oo1 p) )
( "automotive" n (oo1 t ou m ou1 t i v) )
( "Compaq" n (k o1 m p a1 k) )
( "Beijing" n (b ei1 zh i1 ng) )
( "rumors" n (r uu1 m @@ z) )
( "Exxon" n (e1 k s o n) )
( "Phelan" n (f ii1 l a n) )
( "Chrysler" n (k r ai1 s l @@) )
( "Oakland" n (ou1 k l @ n d) )
( "insurers" n (i n sh u@1 r @@ z) )
( "Thomson" n (t o1 m s @ n) )
( "Stearns" n (s t @@1 r n z) )
( "Coors" n (k u@1 r z) )
( "USAir" n (y uu1 e1 s e@1 r) )
( "Rockefeller" n (r o1 k @ f e l @@) )
( "Ogilvy" n (ou1 g i l v ii) )
( "pre" n (p r ii1) )
( "Bache" n (b a1 k) )
( "Mitchell" n (m i1 t ch @ l) )
( "Davis" n (d ei1 v i s) )
( "Nekoosa" n (n e k uu1 s @) )
( "Nikkei" n (n ii1 k k ei1) )
( "McDonald" n (m @ k d o1 n @ l d) )
( "Marshall" n (m aa1 sh @ l) )
( "aide" n (ei1 d) )
( "CenTrust" n (s e1 n - t r uh s t) )
( "BellSouth" n (b e1 l s au1 th) )
( "Thompson" n (t o1 m s @ n) )
( "Donaldson" n (d o1 n @ l d s @ n) )
( "totaling" n (t ou1 t @ l i ng) )
( "insurer" n (i n sh u@1 r @@) )
( "Campbell" n (k a1 m b @ l) )
( "favorable" k (f ei1 v r @ b @ l) )
( "canceled" j (k a1 n s @ l d) )
( "Du" in (d uu) )
( "Fujitsu" n (f uu jh i1 t s uu) )
( "Yeargin" n (y e@1 g i n) )
( "Daiwa" n (d ai1 w a) )
( "Bancorp" n (b a1 n k oo p) )
( "Viacom" n (v ai1 @ k o m) )
( "Vegas" n (v ei1 g @ s) )
( "Steinhardt" n (s t ai1 n h aa1 t) )
( "Rica" n (r ii1 k @) )
( "Icahn" n (ii1 k a n) )
( "Ferranti" n (f @ r a1 n t ii) )
( "Ortega" n (oo r t ei1 g @) )
( "Merieux" n (m e1 r y uu) )
( "Spielvogel" n (s p ii1 l v ou1 k @ l) )
( "Gonzalez" n (g o n z a1 l @ s) )
( "Engelken" n (e1 ng g @ l k e n) )
( "Delmed" n (d e1 l m e1 d) )
( "Corry" n (k o1 r ii) )
( "longtime" n (l o1 ng t ai1 m) )
( "Saab" n (s a1 b) )
( "Rey" n (r ei1) )
( "Nabisco" n (n @ b i1 s k ou) )
( "Disney" n (d i1 z n ii) )
( "repurchase" n (r ii1 p @@1 ch i s) )
( "mainframes" n (m ei1 n f r ei1 m z) )
( "Reynolds" n (r e1 n @ l d z) )
( "Nomura" n (n ou m uu1 r @) )
( "Galileo" n (g a1 l @ l ei1 ou) )
( "Cohen" n (k ou1 e n) )
( "Allianz" n (@ l ai1 a n z) )
( "biotechnology" n (b ai1 ou t e1 k n o1 l @ jh ii) )
( "Jenrette" n (zh o1 n r e1 t) )
( "Bethlehem" n (b e1 th l i h e m) )
( "turnaround" n (t @@1 n @ r au1 n d) )
( "rumored" n (r uu1 m @@ d) )
( "cleanup" n (k l ii1 n uh1 p) )
( "Wedtech" n (w e1 d t e1 k) )
( "Texaco" n (t e1 k s @ k ou1) )
( "Sullivan" n (s uh1 l @ v @ n) )
( "Roberts" n (r o1 b @ t s) )
( "Merksamer" n (m @@1 k s @ m @@) )
( "Hahn" n (h a1 n) )
( "Giuliani" n (jh uu1 l ii a1 n ii) )
( "theater" n (th i@1 t @@) )
( "Unisys" n (y uu1 n i s i1 s) )
( "Monieson" n (m o1 n @ s @ n) )
( "Diego" n (d i ei1 g ou) )
( "Quotron" n (k w o1 t r o n) )
( "Maynard" n (m ei1 n aa d) )
( "Marcos" n (m aa1 k o s) )
( "Jose" n (h ou1 z ei) )
( "Boren" n (b oo1 r e n) )
( "signaled" n (s i1 g n @ l d) )
( "lackluster" n (l a1 k - l uh1 s t @@) )
( "Stein" n (s t ii1 n) )
( "Bartlett" n (b aa1 t l e t) )
( "Amex" n (a1 m e1 k s) )
( "aides" n (ei1 d z) )
( "Trelleborg" n (t r e1 l @ b @@ g) )
( "Saudi" n (s au1 d ii) )
( "Olivetti" n (o1 l i v e1 t ii) )
( "Microsoft" n (m ai1 k r ou s o1 f t) )
( "McGraw" n (m @ g r oo1) )
( "Deutsche" n (d oi1 t ch @) )
( "Courter" n (k oo1 t @@) )
( "Conner" n (k o1 n @@) )
( "Cathay" n (k a1 th ei1) )
( "polyethylene" n (p o1 l ii e1 th i l ii n) )
( "Quebecor" n (k w i1 b e k @@) )
( "Puerto" n (p w e@1 t ou) )
( "Mikhail" n (m ii1 k ai l) )
( "Colo" n (k o1 l ou) )
( "refinancing" n (r ii f ai1 n @ n s i ng) )
( "Societe" n (s @1 s ai1 @ t ei) )
( "Robertson" n (r o1 b @ t s s @ n) )
( "Pfeiffer" n (f ai1 f @@) )
( "Oppenheimer" n (o1 p @ n h ai m @@) )
( "Evans" n (e1 v @ n z) )
( "Dataproducts" n (d ei1 t @ - p r o1 d uh k t s) )
( "Bradstreet" n (b r a1 d - s t r ii1 t) )
( "Antonio" n (a n t ou1 n y ou) )
( "franchisees" n (f r a1 n ch ai z ii1 z) )
( "ex" n (e1 k s) )
( "arbitragers" n (aa1 b @ t r ei1 jh @@ z) )
( "Motorola" n (m ou t @ r ou1 l @) )
( "Macmillan" n (m @ k m i1 l @ n) )
( "Jacobson" n (jh ei1 k @ b s @ n) )
( "Indosuez" n (i1 n d ou s uu1 e z) )
( "Hughes" n (h y uu1 z) )
( "Florio" n (f l oo r i ou) )
( "Spiegel" n (s p ii1 g @ l) )
( "Rico" n (r ii1 k ou) )
( "Palo" n (p a1 l ou) )
( "Madison" n (m a1 d @ s @ n) )
( "HealthVest" n (h e1 l th - v e1 s t) )
( "Fuji" n (f uu1 jh ii) )
( "Deloitte" n (d e1 l oi t) )
( "Amoco" n (a1 m ou k ou) )
( "equaling" n (ii1 k w @ l i ng) )
( "Wallach" n (w oo1 l @ k) )
( "Upjohn" n (uh1 p jh o n) )
( "Tele" n (t e1 l ii) )
( "Rubicam" n (r uu1 b @ k a1 m) )
( "Pemex" n (p e1 m e1 k s) )
( "Meredith" n (m e1 r @ d @ th) )
( "Lorenzo" n (l oo r e1 n z ou) )
( "Levine" n (l @ v ai1 n) )
( "Ingersoll" n (i1 ng g @ s @ l) )
( "Eurocom" n (y uu1 r @ k o m) )
( "Chevrolet" n (sh e1 v r @ l ei) )
( "federally" n (f e1 d r @ l ii) )
( "anymore" n (e1 n ii m oo1 r) )
( "Toshiba" n (t ou sh ii1 b @) )
( "Suisse" n (s w ii1 s) )
( "Sansui" n (s a1 n s uu ii1) )
( "Panzhihua" n (p a1 n z ii1 w a1) )
( "Goldberg" n (g ou1 l d b @@ g) )
( "Garcia" n (g aa s ii1 @@) )
( "Eli" n (ii1 l ai) )
( "Della" n (d e1 l @) )
( "Buick" n (b y uu1 i k) )
( "debacle" n (d ei b uh1 k @ l) )
( "cholesterol" n (k o l e1 s t r @ l) )
( "Vitro" n (v ii1 t r ou) )
( "Revco" n (r e1 v k ou) )
( "Nashua" n (n a1 sh w @) )
( "Mitsui" n (m i t s uu1 ii) )
( "Lexus" n (l e1 k s @ s) )
( "Healthcare" n (h e1 l th - k e@ r) )
( "Ginnie" n (jh i1 n ii) )
( "Carlos" n (k aa1 l @ s) )
( "Benson" n (b e1 n s @ n) )
( "Avery" n (ei1 v r ii) )
( "Achenbaum" n (a1 k @ n b oo m) )
( "Nynex" n (n ai1 n e k s) )
( "Murray" n (m uh1 r ii) )
( "Morishita" n (m o1 r ii1 sh t @) )
( "Minpeco" n (m i1 n p e k ou) )
( "McDonough" n (m @ k d o1 n @@) )
( "Geigy" n (g ei1 jh ii) )
( "Drabinsky" n (d r a b i1 n s k ii) )
( "Dingell" n (d i1 ng @ l) )
( "petrochemical" n (p e1 t r @ k e1 m @ k @ l) )
( "nonetheless" n (n uh1 n dh @ l e1 s) )
( "catalog" n (k a1 t @ l o g) )
( "Yamaichi" n (y a1 m @ ii1 ch ii) )
( "Sugarman" n (sh uu1 g @ m @ n) )
( "Steinberg" n (s t ai1 n b @@ g) )
( "Shevardnadze" n (sh e1 v @ d n a1 d z ii) )
( "Russell" n (r uh1 s @ l) )
( "Roh" n (r ou1) )
( "McDonnell" n (m @ k d o1 n @ l) )
( "Lyonnais" n (l ei1 @ n ei z) )
( "Kravis" n (k r a1 v @ s) )
( "Gould" n (g uu1 l d) )
( "Edelman" n (ei1 d @ l m @ n) )
( "Dreyfus" n (d r ei1 f @ s) )
( "Coniston" n (k o1 n @ s t @ n) )
( "Cineplex" n (s i1 n @ p l e k s) )
( "Antar" n (a1 n t aa) )
( "Annualized" n (a1 n y uu l ai z d) )
( "salespeople" n (s ei1 l s p ii p @ l) )
( "pharmaceuticals" n (f aa1 m @ s y uu1 t @ k @ l z) )
( "layoffs" n (l ei1 o1 f s) )
( "issuance" n (i sh uu1 a n s) )
( "intraday" n (i1 n t r @ d ei1) )
( "exercisable" n (e1 k s @ r s ai1 z @ b @ l) )
( "Weisfield" n (w ii1 s f ii1 l d) )
( "Unocal" n (y uu1 n @ k a l) )
( "Straszheim" n (s t r a1 z h ai m) )
( "Microsystems" n (m ai1 k r ou s i1 s t @ m z) )
( "Hambrecht" n (h a1 m b r e k t) )
( "Generale" n (jh e n e r a1 l) )
( "Friedman" n (f r ii1 d m @ n) )
( "Fresenius" n (f r ii s e1 n i uh s) )
( "Contel" n (k o1 n t e l) )
( "Bennett" n (b e1 n i t) )
( "Azoff" n (a1 z o f) )
( "Arabia" n (@ r ei1 b i@) )
( "rubles" n (r uu1 b @ l z) )
( "routinely" n (r uu t ii1 n l ii) )
( "Unilever" n (y uu1 n @ l ii1 v @ r) )
( "Telesis" n (t e1 l ii s i s) )
( "Skase" n (s k a1 s ii) )
( "Manuel" n (m a1 n w e l) )
( "Mancuso" n (m a n k y uu1 s ou) )
( "Hearst" n (h @@1 s t) )
( "DeConcini" n (d @ k o n ch ii1 n ii) )
( "Chiron" n (ch ai1 r o n) )
( "Caribbean" n (k a1 r @ b ii1 @ n) )
( "Bogart" n (b ou1 g aa t) )
( "rumor" n (r uu1 m @ r) )
( "noncallable" n (n o1 n k oo1 l @ b @ l) )
( "industrywide" n (i1 n d uh s t r ii w ai1 d) )
( "Weiss" n (w ai1 s) )
( "Tucson" n (t uu1 s o n) )
( "Rosenthal" n (r ou1 s @ n t a l) )
( "Rogers" n (r o1 jh @@ z) )
( "Roderick" n (r o1 d @ r i k) )
( "Rican" n (r ii1 k a n) )
( "Prebon" n (p r ii1 b o n) )
( "Owen" n (ou1 e n) )
( "Mercedes" n (m @@ s ei1 d ii s) )
( "Intelogic" n (i1 n t e l l o1 jh i k) )
( "HomeFed" n (h ou1 m f e1 d) )
( "Fossett" n (f o1 s i t) )
( "Cocom" n (k ou1 k o1 m) )
( "Cheney" n (ch ei1 n ii) )
( "Capel" n (k a p e1 l) )
( "Cabrera" n (k @ b r e1 r @) )
( "Blumenfeld" n (b l uu1 m @ n f e l d) )
( "pressured" n (p r e1 sh @ r d) )
( "pachinko" n (p @ ch i1 ng k ou) )
( "conferees" n (k o1 n f @ r ii1 z) )
( "audio" n (oo1 d i ou) )
( "Weyerhaeuser" n (w ai1 r h au1 s @ r) )
( "Schwarz" n (sh w oo1 t z) )
( "Schering" n (sh e1 r i ng) )
( "Sandinista" n (s a1 n @ n ii1 s t @) )
( "Renault" n (r e1 n ou) )
( "Petrie" n (p ii1 t r ii) )
( "Mosbacher" n (m o1 s b a k @ r) )
( "Mario" n (m a1 r i ou) )
( "Kleinwort" n (k l ai1 n w oo t) )
( "Hyundai" n (h uu1 n d ai) )
( "Genentech" n (jh e1 n @ n t e1 k) )
( "Busch" n (b uu1 sh) )
( "Bofors" n (b ou1 f @ @ s) )
( "Barre" n (b aa1 r) )
( "ruble" n (r uu1 b @ l) )
( "nonprofit" n (n o1 n - p r o1 f i t) )
( "buildup" n (b i1 l d uh1 p) )
( "breakup" n (b r ei1 k uh1 p) )
( "ampersand" n (a1 m p @ s a n d) )
( "TransCanada" n (t r a1 n s - k a1 n @ d @1) )
( "Superfund" n (s uu1 p @ - f uh n d) )
( "Sandinistas" n (s a1 n @ n ii1 s t @ s) )
( "Posner" n (p o1 z n @ r) )
( "Papandreou" n (p a1 p @ n d r ii ou) )
( "Odeon" n (ou1 d i @ n) )
( "Nathan" n (n ei1 th @ n) )
( "McGovern" n (m @ g uh1 v @@ n) )
( "Matra" n (m a1 t r @) )
( "Lorin" n (l oo1 r @ n) )
( "Klein" n (k l ai1 n) )
( "Goodyear" n (g u1 d y e@1) )
( "Eaton" n (ii1 t @ n) )
( "Donoghue" n (d o1 n @ h y uu) )
( "DaPuzzo" n (d @ p uu1 z ou) )
( "Barclays" n (b aa1 k l i z) )
( "semiannual" n (s e1 m i - a1 n y u@ l) )
( "maneuver" n (m a n uu1 v @ r) )
( "gridlock" n (g r i1 d l o1 k) )
( "defenses" n (d @ f e1 n s @ s) )
( "anytime" n (e1 n ii t ai m) )
( "annualized" n (a1 n y u@ l ei z d) )
( "Trinova" n (t r i n ou1 v @) )
( "Suzuki" n (s u z uu1 k ii) )
( "Shapiro" n (sh @ p ii1 r ou) )
( "Schwartz" n (sh w oo1 t z) )
( "Savaiko" n (s a v ai1 k ou) )
( "Salinas" n (s a l ii1 n @ s) )
( "Rio" n (r ii1 ou) )
( "Refcorp" n (r e1 f k oo p) )
( "Mehta" n (m ei1 t @) )
( "McMoRan" n (m @ k m oo1 r @ n) )
( "Matsushita" n (m a t s uu1 sh t @) )
( "Luzon" n (l uu1 z o n) )
( "Lufthansa" n (l uu f t h a1 n s @) )
( "Interprovincial" n (i1 n t @@ - p r o v i1 n sh @ l) )
( "Hoechst" n (h ou1 sh t) )
( "Giovanni" n (jh i ou v a1 n ii) )
( "Erbamont" n (e1 r b @ m o n t) )
( "Emhart" n (e1 m h aa t) )
( "Daewoo" n (d ei1 w uu) )
( "Corr" n (k o1 r) )
( "Chivas" n (ch ii1 v @ s) )
( "Burger" n (b @@1 g @@) )
( "Broadway" n (b r oo1 d w ei) )
( "Alaskan" n (@ l a1 s k @ n) )
( "palladium" n (p @ l ei1 d i uh m) )
( "installment" n (i n s t oo1 l m @ n t) )
( "franchisee" n (f r a1 n ch ai z ii1) )
( "Wertheim" n (w e1 r th ai m) )
( "Uniroyal" n (y uu1 n i r oi1 @ l) )
( "Southam" n (s au1 th @ m) )
( "Sinyard" n (s i1 n y aa d) )
( "Quayle" n (k w ei1 l) )
( "Pontiac" n (p o1 n t i a k) )
( "Nuovo" n (n uu1 @ v ou) )
( "MedChem" n (m e1 d k e m) )
( "Mahfouz" n (m aa1 f uu z) )
( "Lomas" n (l ou1 m a s) )
( "Kangyo" n (k a1 ng g y ou) )
( "Iverson" n (ai1 v @@ s @ n) )
( "Graham" n (g r ei1 uh m) )
( "Giorgio" n (g ii1 oo r g ii1 ou) )
( "Gelbart" n (g e1 l b aa t) )
( "Gabelli" n (g a b e1 l ii) )
( "Ellis" n (e1 l i s) )
( "Donuts" n (d ou1 n uh t s) )
( "videocassette" n (v i1 d i ou - k a s e1 t) )
( "petrochemicals" n (p e1 t r @ k e1 m @ k @ l z) )
( "multinational" n (m uh1 l t i - n a1 sh @ n @ l) )
( "minivans" n (m i1 n i v a n z) )
( "gubernatorial" n (g uu1 b @@ n a t oo1 r i@ l) )
( "franchisers" n (f r a1 n ch ai z @@ z) )
( "advancers" n (@ d v a1 n s @@ s) )
( "Zoete" n (z ou1 e t) )
( "Weil" n (w ei1 l) )
( "Torrijos" n (t o r r ii1 y o s) )
( "Templeton" n (t e1 m p @ l t @ n) )
( "Suez" n (s uu1 e z) )
( "Sperry" n (s p e1 r ii) )
( "Seita" n (s ei1 t @) )
( "Scania" n (s k a1 n i @) )
( "Salinger" n (s a1 l i n g @ r) )
( "Rudolph" n (r uu1 d o l f) )
( "Rostenkowski" n (r o1 s t @ n k au1 s k ii) )
( "Pierre" n (p i1 e@) )
( "Peugeot" n (p y uu1 zh ou) )
( "Pearce" n (p i@1 s) )
( "Ortiz" n (o r t ii1 z) )
( "Ogden" n (o1 g d i n) )
( "OBrien" n (ou b r ai1 @ n) )
( "Neuberger" n (n y uu1 b @@ g @ r) )
( "Murata" n (m uu r a1 t @) )
( "McNamee" n (m a k n @ m ii1) )
( "McLennan" n (m @ k l e1 n @ n) )
( "Mayer" n (m ei1 @@) )
( "Mattel" n (m a t e1 l) )
( "Macintosh" n (m a1 k i n t o sh) )
( "MacDonald" n (m a k d o1 n @ l d) )
( "Lumpur" n (l uu1 m p @@) )
( "Kuala" n (k w a1 l @) )
( "Honolulu" n (h o1 n @ l uu1 l uu) )
( "Harrison" n (h a1 r i s @ n) )
( "Haas" n (h aa1 s) )
( "Francois" n (f r o1 n s w @@ z) )
( "Cupertino" n (k uu p @ t ii1 n ou) )
( "CityFed" n (s i1 t ii f e1 d) )
( "Capcom" n (k a1 p k o m) )
( "Cananea" n (k @ n a1 n i@) )
( "Caltrans" n (k a1 l t r a n s) )
( "Beebes" n (b ii1 b s) )
( "Bebear" n (b ii1 b e@ r) )
( "Avis" n (ei1 v i s) )
( "Aoun" n (a1 uu n) )
( "Adm" n (a1 d m i r @ l) )
( "Abramson" n (ei1 b r @ m s @ n) )
( "theaters" n (th i@1 t @@ z) )
( "resale" n (r ii s ei1 l) )
( "pretrial" n (p r ii1 t r ai1 @ l) )
( "midyear" n (m i1 d y @@ r) )
( "en" in (o ng) )
( "elite" n (i l ii1 t) )
( "divisive" n (d @ v ai1 z i v) )
( "bono" n (b ou1 n ou) )
( "archrival" n (aa1 ch r ai v @ l) )
( "acquirer" n (@ k w ai1 r @@) )
( "Vogelstein" n (v ou1 g @ l s t ii n) )
( "Utsumi" n (uu t s uu1 m ii) )
( "Touche" n (t uu sh ei1) )
( "Tenneco" n (t e1 n @ k ou) )
( "Sumitomo" n (s uu1 m ii t ou1 m ou) )
( "Sohmer" n (s ou1 m @ r) )
( "Shakespeare" n (sh ei1 k s p i@ r) )
( "Samsung" n (s a1 m s uh n g) )
( "Perlman" n (p @@1 l m @ n) )
( "Patel" n (p @ t e1 l) )
( "Oy" n (o1 i1) )
( "Omaha" n (ou1 m @ h @) )
( "ONeill" n (ou n ii1 l) )
( "Mueller" n (m uu1 l @ r) )
( "Mitterrand" n (m ii1 t @ r a n) )
( "Mideast" n (m i1 d ii s t) )
( "Michel" n (m ai1 k @ l) )
( "Mehl" n (m e1 l) )
( "Kume" n (k uu1 m e) )
( "Gutfreund" n (g u1 t f r e n d) )
( "Geographic" n (jh i1 ou g r a1 f i k) )
( "Fujis" n (f uu1 jh ii z) )
( "Freres" n (f r e1 r z) )
( "Fazio" n (f a1 t s i ou) )
( "Einhorn" n (ai1 n h oo n) )
( "Egon" n (ii1 g o n) )
( "Cruz" n (k r uu1 z) )
( "Comex" n (k o1 m e k s) )
( "Carnegie" n (k a r n ei1 g ii) )
( "Braniff" n (b r a1 n i f) )
( "Aquino" n (@ k ii1 n ou) )
( "Aichi" n (ai ii1 ch ii) )
( "Ahmanson" n (aa1 m @ n s @ n) )
( "statewide" n (s t ei1 t w ai d) )
( "sitcom" n (s i1 t k o m) )
( "refinance" n (r ii f ai1 n a n s) )
( "postwar" n (p ou s t w oo1 r) )
( "playoffs" n (p l ei o1 f s) )
( "outpaced" n (au t p ei1 s d) )
( "midtown" n (m i d t au1 n) )
( "maneuvering" n (m a n uu1 v @ r i ng) )
( "makeup" n (m ei1 k uh1 p) )
( "indexation" n (i1 n d e k s ei1 sh @ n) )
( "hemorrhaging" n (h e1 m @ r @ jh i ng) )
( "closings" n (k l ou1 s i ng z) )
( "Xtra" n (e1 k s t r @) )
( "Wachter" n (w o1 ch @ r) )
( "Trudeau" n (t r uu1 d ou) )
( "Tharp" n (th aa1 p) )
( "Stephens" n (s t ii1 f @ n z) )
( "Sino" n (s ai1 n ou) )
( "Seymour" n (s ii1 m o r) )
( "Reitman" n (r ai1 t m @ n) )
( "Ramirez" n (r @ m ii1 r e z) )
( "Petrolane" n (p e1 t r ou l ei n) )
( "Omni" n (o1 m n ii) )
( "Ohbayashi" n (ou1 b a y a1 sh ii) )
( "Oakes" n (ou1 k s) )
( "Nuys" n (n oi1 z) )
( "Nguyen" n (n uu1 y e n) )
( "Mateo" n (m @ t ei1 ou) )
( "Maclean" n (m @ k l ii n) )
( "Kia" n (k ii1 @) )
( "Kerr" n (k e r) )
( "Kawasaki" n (k a1 w @ s a1 k ii) )
( "Kao" n (k a1 ou) )
( "Kalikow" n (k a1 l @ k ou) )
( "Jacques" n (zh a1 k) )
( "Jacobs" n (jh ei1 k @ b s) )
( "Institut" n (i1 n s t i t uu t) )
( "Hawaiian" n (h @ w ai1 @ n) )
( "Garratt" n (g a1 r i t) )
( "Elliott" n (e1 l ii i t) )
( "Ehrlich" n (e1 r l i k) )
( "Eduard" n (e1 d w aa d) )
( "Dai" n (d ai1) )
( "Conant" n (k o1 n @ n t) )
( "Bruno" n (b r uu1 n ou) )
( "wildlife" n (w ai1 l d l ai f) )
( "wastewater" n (w ei1 s t w oo t @ r) )
( "unraveling" n (uh n r a1 v l i ng) )
( "tritium" n (t r i1 t i uh m) )
( "semiannually" n (s e1 m i a1 n y u@ l) )
( "salmonella" n (s a1 l m @ n e1 l @) )
( "reoffered" n (r ii1 o1 f @@ d) )
( "reinvest" n (r ii1 i n v e1 s t) )
( "merchandising" n (m @@1 ch @ n d ai1 z i ng) )
( "favorably" n (f ei1 v r @ b l ii) )
( "duo" n (d y uu1 ou) )
( "dialysis" n (d ai a1 l @ s i s) )
( "chlorofluorocarbons" n (k l o1 r @ f l o1 r @ k aa1 b @ n z) )
( "Yamatake" n (y a1 m @ t a1 k e) )
( "Wichita" n (w i1 ch @ t @) )
( "Valdez" n (v a1 l d e z) )
( "Unicorp" n (y uu1 n i k oo p) )
( "Trustcorp" n (t r uh1 s t k oo p) )
( "Toubro" n (t ou1 b r ou) )
( "Tiananmen" n (t i@1 n @ n m e1 n) )
( "Tesoro" n (t e s ou1 r ou) )
( "Tae" n (t ei1) )
( "Stalinist" n (s t a1 l @ n @ s t) )
( "SsangYong" n (s a1 ng y o1 ng) )
( "Shidler" n (sh ai1 d l @ r) )
( "Schuster" n (sh u1 s t @ r) )
( "Schlumberger" n (sh l uh1 m b @@ zh ei) )
( "Schaeffer" n (sh ei1 f @ r) )
( "Sagan" n (s ei1 g @ n) )
( "Roberti" n (r @ b @@1 t ii) )
( "Rahn" n (r aa1 n) )
( "Rafale" n (r @ f a1 l ii) )
( "Quina" n (k ii1 n @) )
( "Parenthood" n (p e@1 r @ n t h uu d) )
( "Novello" n (n o v e1 l ou) )
( "Morgenzon" n (m o1 r g @ n z @ n) )
( "Moines" n (m oi1 n) )
( "Michelin" n (m i1 sh @ l a n) )
( "Meyer" n (m ai1 @ r) )
( "McGee" n (m @ g ii1) )
( "Marous" n (m a1 r ou s) )
( "Managua" n (m @ n a1 g w @) )
( "Macrodantin" n (m a1 k r ou d a1 n t i n) )
( "Knopf" n (k n o1 p f) )
( "Jayark" n (jh ei1 y aa k) )
( "Izvestia" n (i s v e1 s t i @) )
( "Ichi" n (ii1 ch ii) )
( "Hyman" n (h ai1 m @ n) )
( "Hirsch" n (h @@1 sh) )
( "Himont" n (h ai1 m @ n t) )
( "Hercules" n (h @@1 k y uu l ii z) )
( "Heinemann" n (h ai1 n m @ n) )
( "Hathaway" n (h a1 th @ w ei) )
( "Guterman" n (g u1 t @@ m @ n) )
( "Gitano" n (g ii t a1 n ou) )
( "Gibson" n (g i1 b s @ n) )
( "Geduld" n (g e1 d uh l d) )
( "Gatward" n (g a1 t w aa d) )
( "Gartner" n (g aa1 t n @ r) )
( "Fujisawa" n (f uu1 jh ii s a1 w @) )
( "FirstSouth" n (f i1 r s t s au th) )
( "Finkelstein" n (f i1 n k @ l s t ii n) )
( "Fernandez" n (f @@ n a1 n d e z) )
( "Faberge" n (f a1 b e r jh ei) )
( "Detrex" n (d e1 t r e k s) )
( "Carolinas" n (k a1 r @ l ai1 n @ s) )
( "Candela" n (k @ n d e1 l @) )
( "Calloway" n (k a1 l @ w ei) )
( "Cablevision" n (k ei1 b @ v i1 zh @ n) )
( "Cabernet" n (k a1 b @ n ei) )
( "Byrd" n (b @@1 d) )
( "Bundesbank" n (b uu1 n d @ s b a1 n k) )
( "Bumiputra" n (b u1 m i p u1 t r @) )
( "Boyer" n (b oi1 @ r) )
( "Boise" n (b oi1 s ii) )
( "Albuquerque" n (a1 l b @ k @@1 k ii) )
( "Accor" n (@ k o1 r) )
( "Acadia" n (@ k ei1 d i @) )
( "unfocused" n (uh n f ou1 k @ s d) )
( "superpower" n (s uu1 p @ p au1 @ r) )
( "subcompact" n (s uh1 b k o1 m p a k t) )
( "spreadsheet" n (s p r e1 d sh ii t) )
( "signaling" n (s i1 g n @ l i ng) )
( "setup" n (s e t uh1 p) )
( "repurchased" n (r ii1 p @@1 ch i s d) )
( "refinanced" n (r ii f ai1 n a n s d) )
( "pressuring" n (p r e1 sh @ r i ng) )
( "paychecks" n (p ei1 ch e k s) )
( "math" n (m a1 th) )
( "favorites" n (f ei1 v r i t s) )
( "destabilizing" n (d ii s t ei1 b @ l ai1 z i ng) )
( "crocidolite" n (k r ou s i1 d @ l ai t) )
( "counterrevolutionary" n (k au1 n t @@ - r e1 v @ l uu1 sh @ n r ii) )
( "colorful" n (k uh1 l @ r f @ l) )
( "bureaus" n (b y uu1 r ou s) )
( "broadcasters" n (b r oo1 d k a s t @@ s) )
( "Yasuda" n (y a1 s u d @) )
( "Yamamoto" n (y a1 m a m ou1 t ou) )
( "Volkswagen" n (v o1 l k s w a g @ n) )
( "Veraldi" n (v e r a1 l d ii) )
( "Unice" n (y uu1 n i s) )
( "Tulsa" n (t uh1 l s @) )
( "Travis" n (t r a1 v @ s) )
( "Traviata" n (t r a v ii a1 t @) )
( "Threlkeld" n (th r e1 l k e l d) )
( "Stronach" n (s t r o1 n @ k) )
( "Stovall" n (s t o1 v a l) )
( "Staten" n (s t a1 t @ n) )
( "Soweto" n (s u w e1 t ou) )
( "Siegel" n (s ii1 g @ l) )
( "Shattuck" n (sh a1 t uh k) )
( "Segundo" n (s e g u1 n d ou) )
( "SciMed" n (s ai1 m e1 d) )
( "Schulof" n (sh u1 l o f) )
( "Schneider" n (sh n ai1 d @ r) )
( "Schaefer" n (sh ai1 f @ r) )
( "Salem" n (s ei1 l @ m) )
( "Safeco" n (s ei1 f k ou) )
( "Ruvolo" n (r uu1 v ou l ou) )
( "Rianta" n (r ii a1 n t @) )
( "Prix" n (p r ii1) )
( "Petipa" n (p e t ii1 p @) )
( "Paxus" n (p a1 k s @ s) )
( "Paulo" n (p au1 l ou) )
( "Parsow" n (p aa1 s ou) )
( "Ovcharenko" n (o1 v ch a r e1 n k ou) )
( "Orlando" n (o r l a1 n d d ou) )
( "Novell" n (n ou v e1 l) )
( "Nissho" n (n ii1 sh ou) )
( "Nikon" n (n ii1 k o n) )
( "Ngoc" n (n o1 k) )
( "Movieline" n (m uu1 v ii l ai n) )
( "Montagu" n (m o1 n t @ g y uu) )
( "Mitsukoshi" n (m i1 t s uu k ou1 sh ii) )
( "Milpitas" n (m i l p ii1 t @ s) )
( "McGill" n (m @ g i1 l) )
( "McDermott" n (m @ k d @@1 m i t) )
( "Maxtor" n (m a1 k s t o r) )
( "Marietta" n (m a1 r i e1 t @) )
( "Maier" n (m ai1 @ r) )
( "Maguire" n (m @ g w ai1 @ r) )
( "Machiguenga" n (m a1 ch i g w e1 n g @) )
( "Lowell" n (l au1 @ l) )
( "Lorillard" n (l o1 r @ l aa d) )
( "Lonrho" n (l oo1 n r ou) )
( "Lentjes" n (l e1 n t y i z) )
( "Kozinski" n (k o z i1 n s k ii) )
( "Kloves" n (k l ou1 v z) )
( "Jerusalem" n (jh e r uu1 s @ l e m) )
( "Iwai" n (ii w ai1) )
( "Immunex" n (i1 m y uu n e k s) )
( "Ikegai" n (ii1 k e g ai) )
( "Homestake" n (h ou1 m s t ei k) )
( "Heinz" n (h ai1 n z) )
( "Harlem" n (h aa1 l @ m) )
( "Hallwood" n (h oo1 l w u d) )
( "Haagen" n (h aa1 g @ n) )
( "Geva" n (jh e1 v @) )
( "Georgetown" n (jh oo1 jh t au n) )
( "GenCorp" n (jh e1 n k oo p) )
( "Garzarelli" n (g aa1 z @ r e1 l ii) )
( "Fremont" n (f r ii1 m o n t) )
( "Forster" n (f oo1 s t @ r) )
( "Fleischmann" n (f l e1 sh m @ n) )
( "Fischer" n (f i1 sh @ r) )
( "Fidel" n (f i d e1 l) )
( "Feshbach" n (f e1 sh b a k) )
( "Ferruzzi" n (f e r uu1 t s ii) )
( "Felipe" n (f e l ii1 p) )
( "Deseret" n (d e1 s e r i t) )
( "Davidson" n (d ei1 v i d s @ n) )
( "Cooperman" n (k uu1 p @@ m a n) )
( "Chez" n (sh e1 z) )
( "Canelo" n (k @ n e1 l ou) )
( "Canaan" n (k ei1 n @ n) )
( "Byrne" n (b @@ n) )
( "Brody" n (b r ou1 d ii) )
( "BroadBeach" n (b r oo1 d - b ii ch) )
( "BioSciences" n (b ai1 ou - s ai1 @ n s @ s) )
( "Barr" n (b aa1) )
( "BancOklahoma" n (b a n k - ou1 k l @ h ou1 m @) )
( "Asahi" n (a1 s a h ii) )
( "Armenian" n (aa1 m i n i@ n) )
( "Antarctica" n (@ n t aa1 k t i k @) )
( "Anacomp" n (a1 n @ k o m p) )
( "Ames" n (ei1 m z) )
( "Amdahl" n (a1 m d a l) )
( "Allday" n (oo1 l d ei1) )
( "Ailes" n (ai1 l z) )
( "whove" n (w ou v) )
( "thirtysomething" n (th @@1 t ii - s uh1 m th i ng) )
( "telemarketing" n (t e1 l ii - m aa1 k i t i ng) )
( "telemarketers" n (t e1 l ii - m aa1 k i t @ r z) )
( "sustainable" n (s @ s t ei1 n @ b @ l) )
( "spiraling" n (s p ai1 r @ l i ng) )
( "shoreline" n (sh oo1 r - l ai n) )
( "retirees" n (r i t ai1 r ii1 z) )
( "reseller" n (r ii1 s e l @ r) )
( "reignited" n (r ii i g n ai1 t @ d) )
( "refocusing" n (r ii f ou1 k @ s i ng) )
( "refocus" n (r ii f ou1 k @ s) )
( "pico" n (p ii1 k ou) )
( "overreacting" n (ou1 v @@ - r ii a1 k t i ng) )
( "onetime" n (w uh1 n - t ai1 m) )
( "muni" n (m y uu1 n ii) )
( "multinationals" n (m uh1 l t i - n a1 sh @ n @ l z) )
( "maneuvers" n (m a n uu1 v @ r z) )
( "haired" n (h e@1 r d) )
( "franchiser" n (f r a1 n ch ai z @ r) )
( "franchised" n (f r a1 n ch ai z d) )
( "feisty" n (f ai1 s t ii) )
( "equaled" n (ii1 k w @ l d) )
( "criminality" n (k r i1 m @ n a1 l i t ii) )
( "coupe" n (k uu1 p ei) )
( "confrontational" n (k o1 n f r @ n t ei1 sh @ n @ l) )
( "catheter" n (k a1 th @ t @ r) )
( "buyout" n (b ai1 au t) )
( "armored" n (aa1 m @ r d) )
( "aerobics" n (ei r ou1 b i k s) )
( "acquirers" n (@ k w ai1 r @ r z) )
( "academia" n (a1 k @ d ii1 m i @) )

;;; no prizes for guessing where this came from

( "Holmes" n (h ou1 m z) )
( "Lestrade" n (l @ s t r aa1 d) )
( "McGinty" n (m @ g i1 n t ii) )
( "Stapleton" n (s t ei1 p @ l t @ n) )
( "Baskerville" n (b a1 s k @ v i l) )
( "Drebber" n (d r e1 b @ r) )
( "Moriarty" n (m o1 r i aa1 t ii) )
( "Conan" n (k o1 n @ n) )
( "Tregennis" n (t r i g e1 n @ s) )
( "Rucastle" n (r uu1 k a s @ l) )
( "leading" n (l ii1 d i ng) )
( "Ettie" n ( e1 t ii ))
( "Carruthers" n ( k aa r uh1 th @@ z  ) )
( "McFarlane" n (m @ k f aa1 l i n) )
( "Oldacre" n (ou1 l d - ei k @ r) )
( "Alec" n (a1 l i k) )
( "Lucas" n (l uu1 k @ s) )
( "Cadogan" n (k @ d ou1 g @ n) )
( "Huxtable" n (h uh1 k s t @ b @ l) )
( "Athelney" n (a1 th @ l n ei) )
( "daresay" n (d e@1 s ei) )
( "Woolwich" n (w u1 l i ch) )
( "Devonshire" n (d e1 v @ n sh @ r) )
( "Trevelyan" n (t r @ v e1 l @ n) )
( "Oberstein" n (ou1 b @ s t ai n) )
( "Napoleon" n (n @ p ou1 l i @ n) )
( "Dartmoor" n (d aa1 t m u@ r) )
( "Sterndale" n (s t @@1 n d ei l) )
( "Forrester" n (f o1 r @ s t @ r) )
( "Woking" n (w ou1 k i ng) )
( "Stapletons" n (s t ei1 p @ l t @ n s) )
( "Mapleton" n (m ei1 p @ l t @ n) )
( "Merryweather" n (m e1 r i w e dh @ r) )
( "Gorgiano" n (jh oo jh i a1 n ou) )
( "Beddoes" n (b e1 d ou s) )
( "Prendergast" n (p r e1 n d @ g a s t) )
( "Paddington" n (p a1 d i ng t @ n) )
( "Thames" n (t e1 m z) )
( "Charpentier" n (sh a r p e1 n t i ei) )
( "halloa" n (h a l ou1 @) )
( "Eustace" n (y uu1 s t @ s) )
( "Baskervilles" n (b a1 s k @ v i l z) )
( "merest" n (m ii1 r @ s t) )
( "Mordecai" n (m oo1 d @ k ai) )
( "Coburg" n (k ou1 b @@ g) )
( "Swandam" n (s w o1 n d @ m) )
( "Saxe" n (s a k s) )
( "Grimesby" n (g r i1 m s b ii) )
( "Esher" n (e1 sh @ r) )
( "Eduardo" n (e d w aa1 d ou) )
( "wagonette" n (w a1 g @ n e1 t) )
( "Trelawney" n (t r @ l oo1 n ii) )
( "Sydenham" n (s i1 d @ n h @ m) )
( "Montpellier" n (m o m p e1 l i ei) )
( "Lysander" n (l ai s a1 n d @ r) )
( "Fairbairn" n (f e@1 r b e@ n) )
( "Altamont" n (a1 l t @ m o n t) )
( "wagons" n (w a g @ n z) )
( "outre" n (ou1 t r @) )
( "moustached" n (m @ s t a1 sh d) )
( "humouredly" n (h y uu1 m @ d l ii) )
( "Silas" n (s ai1 l @ s) )
( "Reuben" n (r uu1 b @ n) )
( "Reichenbach" n (r i1 k @ n b a k) )
( "Pietro" n (p ii e1 t r ou) )
( "Heidegger" n (h ai1 d i g @ r) )
( "Euston" n (y uu1 s t @ n) )
( "Diogenes" n (d ai oo1 jh @ n ii z) )
( "wagon" n (w a1 g @ n) )
( "reentered" n (r ii e1 n t @ d) )
( "alkaloid" n (a1 l k @ l oi d) )
( "Trichinopoly" n (t r ai1 k i n o1 p @ l ii) )
( "Streatham" n (s t r e1 t @ m) )
( "Sophy" n (s ou1 f ii) )
( "Meiringen" n (m e@1 r i ng @ n) )
( "Greuze" n (g r uu1 z) )
( "Cornelius" n (k o r n ii1 l i @ s) )
( "fiancee" n (f i o1 n s ii1) )
( "dyou" n (jh ou1) )
( "bladed" n (b l ei1 d @ d) )
( "aneurism" n (a1 n y uu r @ z m) )
( "Vibart" n (v ai1 b aa t) )

;;; Another set 

( "Mandela" n (m a n d e1 l @) )
( "Johnson" n (jh o n s @ n) )
( "Buchanan" n (b u k a1 n @ n) )
( "Ceausescu" n (ch au ch e1 s k uu) )
( "Schwarzkopf" n (sh w oo1 t s k o p f) )
( "Aziz" n (@ z ii1 z) )
( "Tyson" n (t ai1 s @ n) )
( "Stalin" n (s t a1 l i n) )
( "Cuomo" n (k uu1 m ou) )
( "Rumania" n (r uu m ei1 n i @) )
( "Powell" n (p au1 w @ l) )
( "Viet" n (v i e1 t) )
( "Kerrey" n (k e1 r ii) )
( "Sununu" n (s @ n uu1 n uu) )
( "Dukakis" n (d @ k a1 k @ s) )
( "Lenin" n (l e1 n i n) )
( "Chua" n (ch w a1) )
( "Azerbaijan" n (a1 z @ b @ jh a1 n) )
( "Riyadh" n (r ii1 a d) )
( "Jesse" n (jh e1 s ii) )
( "Hitler" n (h i1 t l @ r) )
( "Tehran" n (t ei r a1 n) )
( "Abu" n (a1 b uu) )
( "Urquhart" n (@@1 r k @@ t) )
( "Mozart" n (m ou t s aa t) )
( "Lieut" n (l e1 f t e1 n @ n t) )
( "Faludi" n (f a l uu1 d ii) )
( "Azerbaijanis" n (a1 z @@ b @ jh a1 n ii z) )
( "Mubarak" n (m uu1 b @ r a k) )
( "Le" dt (l @) )
( "Botha" n (b ou1 t @) )
( "Ukraine" n (y uu k r ei1 n) )
( "antiwar" n (a1 n t i w oo1 r) )
( "Likud" n (l i k uu1 d) )
( "Duarte" n (d u aa1 t @) )
( "Armenia" n (aa m ii1 n i @) )
( "semiautomatic" n (s e1 m i oo1 t @ m a t i k) )
( "Andrea" n (aa1 n d r i @) )
( "Roosevelt" n (r ou z @ v e l t) )
( "Luther" n (l u1 th @ r) )
( "Armenians" n (aa m ii1 n i @ n z) )
( "Bucharest" n (b u1 k @ r e s t) )
( "Hirohito" n (h i1 r ou h ii1 t ou) )
( "Modrow" n (m u1 d r ou) )
( "Ayatullah" n (ai1 @ t uh1 l @) )
( "Moynihan" n (m oi1 n @ h a n) )
( "Gingrich" n (g i1 n g r i ch) )
( "Securitate" n (s @ k y uu1 @ t ei t) )
( "Mao" n (m au1) )
( "Perez" n (p e1 r e z) )
( "Kissinger" n (k i s @ n jh @ r) )
( "Yankelovich" n (y a1 n k @ l o1 v i ch) )
( "Steinem" n (s t ei n @ m) )
( "Rashid" n (r a sh ii1 d) )
( "Eisenhower" n (ai1 s @ n h au @ r) )
( "Landsbergis" n (l a1 n d s b @@ g @ s) )
( "Khrushchev" n (k r uu1 sh ch @ v) )
( "Rodriguez" n (r o d r ii1 g e z) )
( "Croatia" n (k r ou ei1 sh i@) )
( "antiaircraft" n (a1 n t i e@1 r k r a f t) )
( "Rumanian" n (r uu m ei1 n i @ n) )
( "Azerbaijani" n (a1 z @@ b @ jh a1 n ii) )
( "Perot" n (p e r ou1) )
( "FDIC" n (e1 f d i k) )
( "Wagner" n (v aa1 g n @ r) )
( "Amman" n (@ m a1 n) )
( "mujahedin" n (m u jh a1 h @ d ii n) )
( "genome" n (jh ii1 n ou m) )
( "Nicolae" n (n i1 k ou l ai) )
( "Mohammed" n (m @ h a1 m e d) )
( "HIV" n (ei1 ch ai1 v ii1) )
( "Aviv" n (@ v ii1 v) )
( "quo" n (k w ou1) )
( "intifadeh" n (i1 n t @ f a1 d @) )
( "Monet" n (m o n ei1) )
( "Karabakh" n (k a1 r @ b a k) )
( "Hazelwood" n (h ei1 z @ l w u d) )
( "Barrett" n (b a1 r i t) )
( "furor" n ( f u r o1 r) )
( "Tariq" n (t a1 r ii k) )
( "Kazakhstan" n (k a1 z @ k s t a n) )
( "Goodgame" n (g u1 d g ei m) )
( "Pynchon" n (p i1 n ch @ n) )
( "Ashe" n (a1 sh) )
( "neo" n (n ii1 ou) )
( "Rabta" n (r a1 b t @) )
( "Pulitzer" n (p uu1 l i t z @ r) )
( "Brezhnev" n (b r e1 zh n @ v) )
( "Bhutto" n (b uu1 t ou) )
( "Sidey" n (s ai1 d ii) )
( "superpowers" n (s uu1 p @ p au @ r z) )
( "Vaclav" n (v a1 z l a v) )
( "Thom" n (t o1 m) )
( "NIH" n (e1 n ai1 ei1 ch) )
( "Isabelle" n (i1 s @ b e l) )
( "Hosni" n (h o1 s n ii) )
( "Slovenia" n (s l @ v ii1 n i @) )
( "Milosevic" n (m i l o1 s @ v i ch) )
( "MacLeod" n (m @ k l au1 d) )
( "Friedrich" n (f r ii1 d r i k) )
( "Timisoara" n (t ii1 m @ sh w a1 r @) )
( "Tadzhikistan" n (t a d z i1 k i s t a n) )
( "Salvadoran" n (s a1 l v @ d ou1 r @ n) )
( "Rumanians" n (r uu m ei1 n i @ n z) )
( "Perrier" n (p e1 r i ei) )
( "Lautrec" n (l ou t r e1 k) )
( "Kaifu" n (k ai1 f uu) )
( "Heidi" n (h ai1 d ii) )
( "Fahd" n (f aa d) )
( "Disneyland" n (d i1 z n ii l a n d) )
( "Courbet" n (k oo1 b ei) )
( "Beckett" n (b e1 k i t) )
( "Takeshita" n (t @ k e1 sh t @) )
( "Khafji" n (k a1 f jh ii) )
( "Daley" n (d ei1 l ii) )
( "Clarence" n (k l a1 r @ n s) )
( "firepower" n (f ai1 @ r p au1 @ r) )
( "antiapartheid" n (a1 n t i @ p aa1 t h ai t) )
( "Tobias" n (t ou b ai1 @ s) )
( "Rostropovich" n (r o1 s t r @ p ou1 v i ch) )
( "Roseanne" n (r ou z a1 n) )
( "Peres" n (p e r e1 z) )
( "Notre" n (n o1 t r @ ) )
( "Mantegna" n (m a n t e g n @) )
( "Ligachev" n (l i1 g @ ch @ v) )
( "Kurdistan" n (k @@1 d i s t a n) )
( "Hernandez" n (h @@ n a1 n d @ z) )
( "Genscher" n (g e1 n sh @ r) )
( "Diane" n (d ai a1 n) )
( "buyouts" n (b ai1 au t s) )
( "Yamaguchi" n (y a1 m @ g uu1 ch ii) )
( "Wilde" n (w ai1 l d) )
( "Stroessner" n (s t r o1 s n @ r) )
( "Sakharov" n (s a1 k @ r @ v) )
( "MacDougall" n (m @ k d uu1 g @ l) )
( "Akihito" n (a1 k ii h ii1 t ou) )
( "Yanayev" n (y a1 n @ y @ v) )
( "Violeta" n (v ai @ l e1 t @) )
( "McDowell" n (m @ k d au1 @ l) )
( "Ito" n (ii1 t ou) )
( "Dali" n (d a1 l ii) )
( "savor" n (s ei1 v @ r) )
( "ouster" n (au1 s t @ r) )
( "hometown" n (h ou1 m t au n) )
( "estrogen" n (e1 s t r @ jh @ n) )
( "debuting" n (d ei b y uu1 t i ng) )
( "au" n (ou1) )
( "Yuri" n (y uu1 r ii) )
( "Yakovlev" n (y a1 k @ v l e v) )
( "Venturi" n (v e n ch y uu1 r ii) )
( "Scorsese" n (s k o r s ei1 s ii) )
( "McWhirter" n (m @ k w @@1 t @ r) )
( "Kennebunkport" n (k e1 n i b uh1 n k p oo t) )
( "Hightower" n (h ai1 t au1 @ r) )
( "Cristiani" n (k r i s t ii a1 n ii) )
( "Crete" n (k r ii1 t) )
( "Ukrainian" n (y uu k r ei1 n i @ n) )
( "Trabi" n (t r a1 b ii) )
( "Schickel" n (sh i1 k @ l) )
( "Miyazawa" n (m i1 y @ z a1 w @) )
( "Gaudi" n (g au1 d ii) )
( "Bastille" n (b a s t ii1 l) )
( "somber" n (s o m b @ r) )
( "prewar" n (p r ii1 w oo1 r) )
( "moviegoers" n (m uu1 v i g ou @ r z) )
( "macho" n (m a1 ch ou) )
( "erstwhile" n (@@ s t w ai l) )
( "cliche" n (k l ii sh ei1) )
( "antiabortion" n (a1 n t i @ b oo1 sh @ n) )
( "Uzbekistan" n (uu z b e1 k i s t a n) )
( "Trabant" n (t r @ b a1 n t ) )
( "Sergei" n (s i1 r g ei) )
( "Montgomery" n (m o n t g o1 m @ r ii) )
( "Ku" n (k uu1) )
( "Heathrow" n (h ii1 th r ou) )
( "Guggenheim" n (g uu1 g @ n h ai m) )
( "Gnehm" n (n e1 m) )
( "Gesell" n (g e1 s @ l) )
( "Dylan" n (d i1 l @ n) )
( "Carolco" n (k a1 r @ l k ou) )
( "Buchwald" n (b u1 k v a l d) )
( "Belorussia" n (b e1 l @ r uh1 sh i @) )
( "kidnaped" n (k i1 d n a1 p t) )
( "Yosemite" n (y @ s e1 m i t ii ) )
( "Ukrainians" n (y uu k r ei1 n i @ n z) )
( "Sylvester" n (s i l v e1 s t @ r) )
( "Schultz" n (sh u1 l t s) )
( "Scharf" n (sh aa1 f) )
( "Reaganomics" n (r ei1 g @ n oo1 m i k s) )
( "Randall" n (r a1 n d @ l) )
( "Puryear" n (p uh1 t y @@ r) )
( "Nidal" n (n i d a1 l) )
( "Nair" n (n e@ r) )
( "Michelangelo" n (m ai1 k @ l a1 n jh @ l ou) )
( "Margot" n (m aa1 g ou) )
( "Leonid" n (l i1 e n @ d) )
( "Lehtinen" n (l ei t i1 n @ n) )
( "Hafez" n (h a1 f e z) )
( "Gomez" n (g ou1 m e z) )
( "Gisela" n (jh i s e1 l @) )
( "Elena" n (e l ei1 n @) )
( "Chi" n (k ai1) )
( "Ariz" n (a1 r i z) )
( "Andre" n (aa1 n d r ei) )
( "prizewinning" n (p r ai1 z w i n i ng) )
( "cliches" n (k l ii sh ei z) )
( "basics" n (b ei1 s i k s) )
( "Yellowstone" n (y e1 l ou s t ou n) )
( "Walesa" n (v a l e1 s @) )
( "Stefan" n (s t e1 f a n) )
( "Schwarzenegger" n (sh w oo1 t z e n ei g @ r) )
( "Sanchez" n (s a1 n ch e z) )
( "Nikita" n (n i k ii1 t @) )
( "Navajo" n (n a1 v @ h ou) )
( "Mitchelson" n (m i1 ch @ l s @ n ) )
( "Menem" n (m e n @ m) )
( "Laurent" n (l oo r o1 n) )
( "Lafester" n (l @ f e1 s t @ r) )
( "Janeiro" n (jh @ n e@1 r ou) )
( "Isaacson" n (ai1 s i k s @ n) )
( "Gromyko" n (g r ou m ii1 k ou) )
( "Fergie" n (f @@1 g ii) )
( "Eco" n (ii1 k ou) )
( "DeWitt" n (d @ w i1 t) )
( "Daryl" n (d a1 r @ l) )
( "policymaking" n (p o1 l i s i m ei k i ng) )
( "policymakers" n (p o1 l i s i m ei k @ r z) )
( "nunciature" n (n @ n s ii1 @ ch u@ r) )
( "noncommunist" n (n o n - k o1 m y uu n i s t) )
( "kidnaping" n (k i d n a1 p i i ng) )
( "facade" n (f @ s aa1 d) )
( "disadvantaged" n (d i s @ d v a1 n t ei jh d) )
( "antigovernment" n (a1 n t i g uh1 v @ n m @ n t) )
( "Yves" n (ii1 v z) )
( "Weisser" n (w ai1 z @ r) )
( "Vitali" n (v i t a1 l ii) )
( "Reiner" n (r ai1 n @ r) )
( "Raisa" n (r ai1 s @) )
( "ROTC" n (aa1 r ou1 t ii1 s ii1) )
( "Nicholson" n (n i1 k @ l s @ n) )
( "Mustafa" n (m uh1 s t a f @) )
( "Gras" n (g r aa1) )
( "Gershwin" n (g @@ sh w @ n) )
( "Gibbs" n (g i1 b z ) )
( "Freud" n (f r oi1 d) )
( "Doubleday" n (d uh1 b @ l d ei) )
( "Beyer" n (b ei1 @ r) )
( "Arrington" n (a1 r i ng t @ n) )
( "Anastasia" n (a1 n a s t ei1 s i @) )
( "Allison" n (a1 l i s o n) )
( "Ahmed" n (aa1 m e d) )
( "geopolitical" n (jh ii1 ou p @ l i1 t @ k @ l) )
( "bookstores" n (b u1 k s t oo1 z) )
( "Zhai" n (z ai1) )
( "Xiaoping" n (sh au1  p i ng) )
( "Xiao" n (sh au1) )
( "Winbush" n (w i1 n b uu sh) )
( "Whitaker" n (w i1 t @ k @ r) )
( "Vytautas" n (v ai t au1 t @ s) )
( "Swaggart" n (s w a1 g @ t) )
( "Reilly" n (r ai1 l ii) )
( "Reid" n (r ii1 d) )
( "Nikolai" n (n i1 k ou l ai) )
( "Motown" n (m ou1 t au n) )
( "Melamed" n (m e1 l @ m e d) )
( "Medved" n (m e1 d v e1 d) )
( "Mazowiecki" n (m @ z au1 s k ii) )
( "Mahon" n (m ei1 h @ n) )
( "Leninist" n (l e1 n @ n i s t) )
( "Jong" n (y o1 ng) )
( "Huston" n (h uu1 s t @ n) )
( "Gumbel" n (g uh1 m b @ l) )
( "Guillermo" n (g u w ii @@1 m ou) )
( "Fuchs" n (f uu1 k s) )
( "Flynn" n (f l i1 n) )
( "Dou" n (d ou1) )
( "Dahmer" n (d aa1 m @ r) )
( "Croatian" n (k r ou ei1 sh @ n) )
( "Capriati" n (k a p r i a1 t ii) )
( "Buthelezi" n (b u t @ l ei1 z ii) )
( "Bhopal" n (b ou p a1 l) )
( "Arcata" n ( aa k a1 t @) )
( "Abrams" n (ei1 b r @ m z) )
( "gutsy" n (g uh1 t s ii) )
( "debuted" n (d ei b y uu1 d) )
( "bipartisanship" n (b ai p aa1 t @ s @ n sh i p) )
( "Webb" n (w e1 b) )
( "Ulam" n (ou1 l @ m) )
( "Shultz" n (sh u1 l t z) )
( "Rosenberg" n (r ou1 s @ n b @@ g) )
( "Regan" n (r ii g @ n) )
( "Noboru" n (n ou b ou1 r uu) )
( "Moshe" n (m o1 sh ei) )
( "Martinez" n (m aa t @ n e1 z) )
( "Klaus" n (k l au1 s) )
( "Islamabad" n (i s l a1 m @ b a d) )
( "Heinrich" n (h ai1 n r i k) )
( "Greenpeace" n (g r ii1 n p ii s) )
( "Geraldo" n (jh e r a1 l d ou) )
( "Donahue" n (d o1 n @ h y uu) )
( "Dmitri" n (d @ m ii1 t r ii) )
( "Dietrich" n (d ii1 t r i k) )
( "Croats" n (k r o1 a t s) )
( "Cione" n (s i ou1 n ii) )
( "Cher" n (sh e1 r) )
( "Chavira" n (sh a v ii1 r @) )
( "Camelot" n (k a1 m @ l o t) )
( "Beethoven" n (b ei1 t h ou v @ n) )
( "Awadi" n (@ w a1 d ii) )
( "Avianca" n (a v i a1 n k @) )
( "Andean" n ( a1 n d i @ n) )
( "Alberto" n (a l b @@1 t ou) )
( "Aaron" n (ei1 r @ n) )
( "misdemeanor" n (m i s d @ m ii1 n @ r ) )
( "mammograms" n (m a1 m @ g r a m z) )
( "detente" n (d ei t o1 n t ) )
( "Vladivostok" n (v l a d @ v o1 s t o k) )
( "Turkmenistan" n (t @@ k m e1 n i s t a n) )
( "Stalinism" n (s t a1 l @ n @ z m) )
( "Seiji" n (s ei1 jh ii) )
( "Prager" n (p r a1 g @ r) )
( "Pinochet" n (p i1 n @ sh ei) )
( "Phnom" n (p @ n o1 m) )
( "Penh" n (p e1 n) )
( "Mengistu" n (m e n g ii1 s t uu) )
( "McManus" n (m @ k m a1 n @ s) )
( "Marsalis" n (m a r s a1 l @ s) )
( "Lou" n (l uu1) )
( "Huang" n (w a1 ng) )
( "Gwynne" n (g w i1 n) )
( "Giroux" n (jh ii r ou1) )
( "Feinstein" n (f ei1 n s t ai n) )
( "Farabundo" n (f a r @ b uh1 n d ou) )
( "Euphrates" n (y uu f r ei1 t ii z) )
( "Dushanbe" n (d @ sh a1 n b @) )
( "Dante" n (d aa1 n t ei) )
( "Chen" n (ch e1 n) )
( "Carr" n (k aa1) )
( "Cadillac" n (k a1 d @ l a k) )
( "Buenos" n (b w ei1 n @ s) )
( "Branagh" n (b r a1 n @) )
( "Bikkembergs" n (b i1 k @ m b @@ g s) )
( "Andreas" n (a n d r ei1 @ s) )
( "wacky" n (w a1 k ii) )
( "stockpiled" n (s t o1 k p ai l d) )
( "salsa" n (s a1 l t s a) )
( "protege" n (p r o1 t @ jh ei) )
( "newsmagazine" n (n y uu1 z m a1 g @ z ii n) )
( "labored" n (l ei1 b @@ d) )
( "deterrence" n (d @ t e@1 r @ n s) )
( "anticommunist" n (a1 n t i k o1 m y uu n @ s t) )
( "acknowledgment" n (@ k n o1 l i jh m @ n t) )
( "Valerie" n (v a1 l @ r ii) )
( "Sheppard" n (sh e1 p @ d) )
( "Ryzhkov" n (r ai1 zh k o f) )
( "Raphael" n (r a f ai1 l) )
( "Quebecois" n (k w i1 b e k w aa) )
( "Profumo" n (p r ou f y u1 m ou) )
( "Mondale" n (m o1 n d ei l) )
( "Minh" n (m i1 n) )
( "Menachem" n ( m e n a1 k @ m) )
( "Mecke" n (m e1 k) )
( "McClure" n (m @ k l u@1 r) )
( "Magubane" n (m a1 g u b a n ii) )
( "Kupreyev" n (k @ p r ei1 e v) )
( "Krikalev" n (k r i1 k @ l e v) )
( "Khamenei" n (k @ m ei1 n ii) )
( "Kgase" n (k @ g a1 s ii) )
( "Kennan" n (k ii1 n @ n) )
( "Juan" n (w aa1 n ) )
( "Helena" n (h e l e1 n @) )
( "Gomes" n (g ou1 m e z) )
( "Genome" n (jh ii1 n ou m) )
( "Foretich" n (f oo1 r t i k) )
( "Evan" n (e1 v @ n) )
( "Eagleburger" n (ii1 g @ l b @@ g @ r) )
( "Dhabi" n (d aa1 b ii) )
( "Darwin" n (d aa1 w i n) )
( "Camille" n (k a m ii1 l) )
( "Brzezinski" n (b r @ zh i1 n s k ii) )
( "Boyz" n (b oi1 z) )
( "Ayckbourn" n (ei1 k b oo n) )
( "Ariel" n (ei1 r i e l) )
( "Andres" n (a1 n d r e z) )
( "yds" n (y aa1 d z) )
( "sures" n (sh u@1 r z) )
( "subtext" n (s uh1 b t e k s t) )
( "siecle" n (s i e1 k @ l ) )
( "savoring" n (s ei1 v @ r i ng) )
( "savior" n (s ei1 v i@ r) )
( "resupply" n (r ii1 s @ p l ai) )
( "paycheck" n (p ei1 ch e k) )
( "ole" n (ou l ei1) )
( "micromastia" n (m ai1 k r o m a1 s t i @) )
( "farmland" n (f aa1 m l a n d) )
( "ethicists" n (e1 th @ s i s t s) )
( "brio" n (b r ii1 ou) )
( "Wynton" n (w i1 n t @ n) )
( "Woodrow" n (w u1 d r ou) )
( "Webber" n (w e1 b @ r) )
( "Uzbeks" n (u1 z b e k s) )
( "Stateside" n (s t ei1 t s ai d) )
( "Smiley" n (s m ai1 l ii) )
( "Schreiber" n (sh r ei1 b @ r) )
( "Ruhollah" n (r u h ou1 l @) )
( "Rivera" n (r i b e1 r @) )
( "Reingold" n (r ai1 n g ou l d) )
( "Purvis" n (p @@1 v i s) )
( "Prawer" n (p r oo1 @ r) )
( "Pamyat" n (p a1 m y a t) )
( "Orion" n (ou r ai1 @ n) )
( "Opel" n (ou1 p @ l) )
( "Oates" n (ou1 t s) )
( "Nina" n (n ii1 n @) )
( "Naisbitt" n (n ei1 z b i t) )
( "NEC" n (e1 n ii1 s ii1) )
( "McElroy" n (m a1 k @ l r oi) )
( "McCrae" n (m @ k r ei1) )
( "Maura" n (m au1 r @) )
( "Maida" n (m ai1 d @) )
( "Lopez" n (l ou1 p e z) )
( "Leonardo" n (l ii o n aa1 d ou) )
( "Kunst" n (k uu1 n s t) )
( "Kouchner" n (k au ch n @ r) )
( "Kiichi" n (k ii ii1 ch ii) )
( "Kagan" n (k ei1 g @ n) )
( "Joaquin" n (jh ou a1 k @ n ) )
( "Jaruzelski" n (y a r @ z e1 l s k ii) )
( "Imelda" n (i m e1 l d @) )
( "Howards" n (h au1 @ d z) )
( "Heisler" n (h ai1 s l @ r) )
( "Guth" n (g u1 th) )
( "Gearheart" n (g i@1 h aa t) )
( "Fukuyama" n (f uu1 k u y a1 m @) )
( "Foucault" n (f ou1 k @ l t) )
( "Farrar" n (f a1 r @ r) )
( "Exocet" n (e1 k s @ s e t) )
( "Etzioni" n (e t z i ou1 n ii) )
( "Entartete" n (e1 n t aa t e t) )
( "Connery" n (k o1 n @ r ii) )
( "Chavez" n (sh a1 v @ z) )
( "Callahan" n (k a1 l @ h a n) )
( "CPOP" n (s ii1 p o p) )
( "Bundestag" n (b u1 n d @ s t a g) )
( "Boyett" n (b oi e1 t) )
( "Bianco" n (b i a1 n k ou) )
( "Axel" n (a1 k s @ l) )
( "Amherst" n (a1 m h @@ s t) )
( "Alfonsin" n (a l f o1 n s @ n) )
( "unsavory" n (uh n s ei1 v r ii) )
( "surefire" n (sh u@1 r f ai @ r) )
( "polygraph" n (p o1 l i g r a f) )
( "nuanced" n (n y uu1 @ n s t) )
( "nisei" n (n ii1 s ei) )
( "mustache" n (m uh s t a1 sh ) )
( "laboring" n (l ei1 b @ r i ng) )
( "laborers" n (l ei1 b @ r @ r z) )
( "homegrown" n (h ou1 m g r ou n) )
( "farfetched" n (f aa1 f e ch d) )
( "diva" n (d ii1 v @) )
( "characterizations" n (k a r @ k t @ r ai z ei1 sh @ n) )
( "carcinogen" n (k aa1 s i jh @ n) )
( "behemoth" n (b @ h ii1 m o th) )
( "academe" n (a1 k @ d ii m) )

;; More apearing in multiple articles

( "Hussein" n (h @ s ei1 n) )
( "perestroika" n (p e r @ s t r oi1 k @) )
( "Tresniowski" n (t r e s n i au1 s k ii) )
( "Monroe" n (m o n r ou1) )
( "Khomeini" n (k o m ei1 n ii) )
( "Lech" n (l e1 k) )
( "Ryan" n (r ai1 @ n) )
( "Fernando" n (f @@ n a1 n d ou) )
( "Gaddafi" n (g @ d a1 f ii) )
( "Muammar" n (m u a1 m @ r) )
( "Melissa" n (m @ l i1 s @) )
( "Cornell" n (k oo n e1 l) )
( "Yevgeni" n (y e v g e1 n ii) )
( "backup" n (b a1 k uh p) )
( "Anatoli" n (a n @ t ou1 l ii) )
( "Tadeusz" n (t a1 d y uu z) )
( "Pablo" n (p a1 b l ou) )
( "Alzheimer" n (a1 l t z ai m @ r) )
( "Alzheimers" n (a1 l t z ai m @ r z) )
( "Calvin" n (k a1 l v @ n) )
( "Bernstein" n (b @@1 n s t ii n) )
( "Ricardo" n (r i k aa1 d ou) )
( "Rafsanjani" n (r a f s @ n jh aa1 n ii) )
( "fatally" n (f ei1 t @ l ii) )
( "cutoff" n (k uh1 t o v) )
( "Alfredo" n (a l f r ei1 d ou) )
( "Alain" n (a l a1 n) )
( "Einstein" n (ai1 n s t ai n) )
( "fi" n (f ii1) )
( "Raul" n (r @ uu1 l) )
( "Bethesda" n (b @ th e1 s d @) )
( "Ungeheuer" n (uh n g @ h oo r) )
( "Rudulph" n (r uu1 d @ l f) )
( "Molotov" n (m o1 l @ t o v) )
( "sci" n (s ai1) )
( "culturally" n (k uh1 l ch @ r @ l ii) )
( "Jaime" n (h ai1 m ii) )
( "Chevy" n (sh e1 v ii) )
( "Chamorro" n (ch @ m o1 r ou) )
( "Auschwitz" n (au1 sh v i t s) )
( "flavored" n (f l ei1 v @ d) )
( "decor" n (d ei k oo1 r) )
( "Olivier" n (@ l i1 v i ei1) )
( "Leona" n (l ii ou1 n @) )
( "spearheaded" n (s p i@1 h e d @ d ) )
( "adamantly" n (a1 d @ m @ n y l ii) )
( "Stallone" n (s t @ l ou1 n) )
( "Ludtke" n (l uh1 d k @) )
( "catalogs" n (k a1 t @ l o g z) )
( "Strauss" n (s t r au1 s) )
( "Schlesinger" n (sh l e1 s i ng @ r) )
( "Rutgers" n (r uh1 t g @ z ) )
( "Georgi" n (g i oo1 g ii) )
( "Faulkner" n (f oo1 l k n @ r) )
( "Bonfante" n (b o1 n f aa n t ii) )
( "plowed" n (p l au1 d) )
( "grownup" n (g r ou1 n uh p) )
( "Zulu" n (z uu1 l uu) )
( "Sri" n (sh r ii1) )
( "Richter" n (r i1 k t @ r) )
( "Oleg" n (ou1 l e g) )
( "Michele" n (m i sh e1 l) )
( "Marcel" n (m aa s e1 l) )
( "Mapplethorpe" n (m ei1 p @ l th oo p) )
( "Cafe" n (k a1 f ei1) )
( "vocals" n (v ou1 k @ l z) )
( "parenting" n (p ei1 r e n t i ng) )
( "emigres" n (e1 m @ g r ei z) )
( "communique" n (k o m y uu1 n i k ei1) )
( "Sunni" n (s uh1 n ii) )
( "Reno" n (r ii1 n ou) )
( "Rajiv" n (r @ jh ii1 v) )
( "Miguel" n (m i g w e1 l) )
( "Malibu" n (m a1 l i b uu) )
( "Inkatha" n (i n k aa1 t @) )
( "HarperCollins" n (h aa1 p @ k oo1 l @ n z) )
( "Ajemian" n (@ jh i1 m i @ n) )
( "superstars" n (s uu1 p @ s t aa z) )
( "rancor" n (r a1 n k oo r) )
( "expansionism" n (e g s p a1 n sh @ n @ z m) )
( "bookstore" n (b u1 k s t oo r) )
( "anemic" n (@ n ii1 m i k) )
( "Rehnquist" n (r e1 n k w i s t) )
( "Rafael" n (r a f ai1 l) )
( "Michaels" n ( m ai1 k @ l z) )
( "Koppel" n (k o1 p @ l) )
( "Crowe" n (k r ou1) )
( "Cesar" n (s ii1 s @ r) )
( "moviemakers" n (m uu1 v i m ei1 k @ r z) )
( "moviegoer" n (m uu1 v i g ou @ r))
( "emigre" n (e1 m i g r ei) )
( "cafes" n (k a f ei1 z) )
( "authored" n (oo1 th @@ d) )
( "Potomac" n (p ou1 t @ m a k) )
( "Javier" n (y ei1 v i ei1) )
( "Eliot" n (e1 l i o t ) )
( "Arsenio" n (aa s ii1 n i ou) )
( "skewed" n (s k y uu1 d) )
( "reinvent" n (r ii1 i n v e1 n t) )
( "naivete" n (n ai ii1 v i t ii) )
( "musings" n (m y uu1 z i ng z) )
( "couture" n (k @ t y u@1 r) )
( "adrenaline" n (@ d r e1 n @ l i n) )
( "acerbic" n (@ s @@1 b i k) )
( "Mahal" n (m @ h a1 l) )
( "Lauren" n (l o1 r @ n) )
( "Ehrenreich" n (e1 r @ n r i k) )
( "Antonin" n (a1 n t @ n i n) )
( "Anton" n (a1 n t o n) )
( "splashy" n (s p l a1 sh ii) )
( "preschool" n (p r ii1 s k u l) )
( "forebears" n (f oo1 r b e@ z) )
( "Rene" n (r e n ei1) )
( "Katharine" n (k a1 th r i n) )
( "Herzegovina" n (h @@ t s @ g @ v ii1 n @) )
( "Gerhard" n (g e@1 h aa d) )
( "Gerasimov" n (g @ r a1 s @ m o v) )
( "existential" n (e g s i s t e1 n sh @ l) )
( "befuddled" n (b @ f uh1 d @ l d) )
( "Philippe" n (f ii l ii1 p) )
( "PAC" n (p ii1 ei1 s ii1) )
( "Marquez" n (m aa k e1 z) )
( "Kennedys" n (k e1 n @ d @ z) )
( "Jorge" n (y oo jh) )
( "Gallagher" n (g a1 l @ h @ r) )
( "FlorCruz" n (f l oo1 r - k r uu z) )
( "Costello" n (k o s t e1 l ou1) )
( "tenured" n (t e1 n y u@ d) )
( "entrepreneurship" n (o1 n t r @ p r @ n y u@1 sh i p) )
( "elites" n (i l ii1 t s) )
( "Ziyang" n (z ii1 y a ng) )
( "Zhao" n (zh au1) )
( "Leninism" n (l e1 n @ n @ z m) )
( "Lakers" n (l ei1 k @ z) )
( "Kryuchkov" n (k r ai1 ch k o v) )
( "Josef" n (y ou1 s i f) )
( "Gulag" n (g uu1 l a g) )
( "Crimea" n (k r ai m ii1 @) )
( "Caltech" n (k a1 l t e k) )
( "bombings" n (b o1 m i ng z) )
( "Aires" n (ei1 r ii z) )
( "vu" n (v uu1) )
( "viral" n (v ai1 r @ l) )
( "stressful" n (s t r e1 s f @ l) )
( "reprise" n (r i p r ai1 z) )
( "replicate" n (r e1 p l i k ei t) )
( "omnipresent" n (o1 m n i p r e1 s @ n t) )
( "nouveau" n (m uu v ou1 ) )
( "moviemaking" n (m uu1 v i m ei1 k i ng) )
( "hallway" n (h oo1 l w ei1) )
( "fiance" n (f i o1 n s i1) )
( "demographics" n (d e1 m @ g r a1 f i k z) )
( "attache" n (@ t a sh ei1) )
( "Toni" n (t ou1 n ii) )
( "Shimon" n (sh i m o1 n) )
( "Schmidt" n (sh m i1 t) )
( "Revlon" n (r e1 v l o n) )
( "Pont" n (p o1 n t) )
( "Ozal" n (o z a1 l) )
( "Hubble" n (h uh1 b @ l) )
( "Hasan" n (h @ s a1 n) )
( "Fuhrer" n (f y uu1 r @ r) )
( "Aleksandr" n (a l e k z a1 n d @ r) )
( "stanch" n (s t oo1 n ch) )
( "premieres" n (p r e m i @@1 z) )
( "plow" n (p l au1) )
( "passe" n (p a s ei1) )
( "northward" n (n oo1 th w @@ d) )
( "favoritism" n (f ei1 v r @ t @ z m) )
( "deja" n (d ei1 zh @) )
( "caliber" n (k a1 l @ b @ r) )
( "ballyhooed" n (b a l i h uu1 d) )
( "anemia" n (@ n ii1 m i @) )
( "Weimar" n (w ei1 m @ r) )
( "Streisand" n (s t r ai1 s @ n d) )
( "Shakespearean" n (sh ei1 k s p i@ r i @ n) )
( "Seiichi" n (s ei1 ii ch ii) )
( "Sarandon" n (s @ r a1 n d @ n) )
( "Rahman" n (r aa1 m a n) )
( "Manet" n (m a n ei1) )
( "Lamar" n (l @ m aa) )
( "Gup" n (g uh1 p) )
( "Gazeta" n (g @ z e1 t @) )
( "videocassettes" n (v i1 d i ou - k a s e1 t s) )
( "prizewinner" n (p r ai1 z w i n @ r) )
( "nationhood" n (n ei1 sh @ n h uu d) )
( "labors" n (l ei1 b @ z) )
( "hallways" n (h oo1 l w ei z) )
( "genocidal" n (jh e1 n @ s ai1 d @ l) )
( "fide" n (f ai1 d ii) )
( "eponymous" n (e p o1 n @ m @ s) )
( "Zbigniew" n (z @ b i1 g n i e v) )
( "Tito" n (t ii1 t ou) )
( "Schroeder" n (sh r ou1 d @ r) )
( "Romeo" n (r ou1 m i ou) )
( "Roemer" n (r ou1 m @ r) )
( "Mussolini" n (m u1 s i l ii1 n ii) )
( "Lai" n (l ai1) )
( "Karim" n (k a r ii1 m) )
( "Indochina" n (i1 n d @ ch ai1 n @) )
( "Francesco" n (f r a n ch e1 s k ou) )
( "Emilio" n (e m ii1 l i ou) )
( "Ellington" n (e1 l i ng t @ n) )
( "Eisner" n (ai1 s n @ r) )
( "Chopin" n (sh ou1 p a n) )
( "Bowie" n (b au1 ii) )
( "yd" n (y aa1 d) )
( "suburbanites" n (s @ b @@1 b @ n ai1 t z ) )
( "rehab" n (r ii1 h a b) )
( "passersby" n (p a1 s @ s b ai) )
( "officeholders" n (o1 f i s h ou l d @ z) )
( "nomenklatura" n (n o m e1 n k l @ t y uu1 r @) )
( "noir" n (n w aa1 r) )
( "mater" n (m ei1 t @ r) )
( "expansionist" n (i g s p a1 n sh @ n @ s t) )
( "epochal" n (e p o1 k @ l) )
( "entree" n (o1 n t r ei) )
( "denouement" n (d @ n oi1 m e n t) )
( "cutthroat" n (k uh1 t th r ou t) )
( "Versailles" n (v @@ s ai1) )
( "Valeri" n (v a1 l @ r ii) )
( "Su" n (s uu1) )
( "Sharif" n (sh @ r ii1 f) )
( "Saavedra" n (s aa1 v e d r @) )
( "Raleigh" n (r a1 l ei) )
( "Ochoa" n (o ch o1 @) )
( "Marianne" n (m a r i a1 n) )
( "Lucille" n (l uu s ii1 l) )
( "Lindbergh" n (l i1 n d b @@ g) )
( "Hermes" n (h @@1 m ii z) )
( "Goethe" n (g ou1 th @) )
( "Danielle" n (d a n i e1 l) )
( "Constantine" n (k o1 n s t @ n t ii n) )
( "Capone" n (k @ p ou1 n) )
( "Buffett" n (b uu f ei1) )
( "Brigham" n (b r i1 g @ m) )
( "Archie" n (aa1 ch ii) )
( "Amos" n (ei1 m @ s) )
( "Afro" n (a1 f r ou) )
( "unrivaled" n (uh n r ai1 v @ l d) )
( "triage" n (t r ii a1 zh) )
( "theatergoers" n (th i@1 t @ g ou @ r z) )
( "submachine" n (s uh1 b m @ sh ii1 n) )
( "stereotypical" n (s t e1 r i@ t i1 p @ k @ l) )
( "skeletal" n (s k e1 l @ t @ l) )
( "sidekick" n (s ai1 d k i k) )
( "savored" n (s ei1 v @ d) )
( "sadomasochistic" n (s ei1 d ou m a1 s @ k i1 s t i k) )
( "ress" n (r e1 s) )
( "predawn" n (p r ii1 d oo n) )
( "postmodern" n (p ou1 s t m o d @ n) )
( "postcommunist" n (p ou1 s t k o1 m uu n @ s t) )
( "outmaneuvered" n (au1 t m a n uu1 v @@ d) )
( "multicolored" n (m uh1 l t i k uh l @ d) )
( "maneuvered" n (m a n uu1 v @@ d) )
( "liter" n (l ii1 t @ r) )
( "laborer" n (l ei1 b @ r @ r) )
( "falloff" n (f oo1 l o v) )
( "facades" n (f @ s a1 d z) )
( "destabilize" n (d ii s t ei1 b @ l ai z) )
( "coincidentally" n (k ou1 i n s @ d e1 n t @ l ii) )
( "carcinogens" n (k aa1 s i jh @ n z) )
( "antinuclear" n (a1 n t i n y uu1 k l i@ r) )
( "aerobic" n (ei r ou1 b i k ) )
( "Yusuf" n (y uu1 s @ f) )
( "Willem" n (w i1 l e m) )
( "Ventura" n (v e n ch y uu1 r @) )
( "Saharan" n (s @ h a1 r @ n) )
( "Rutherford" n (r uh1 th @ f oo d) )
( "Psycho" n (s ai1 k ou) )
( "Miserables" n (m ii z @ r aa1 b l @) )
( "Mimi" n (m ii1 m ii) )
( "Milos" n (m ai1 l ou s) )
( "Magellan" n (m a g e1 l @ n) )
( "Kosovo" n (k @ s ou1 v ou) )
( "Komsomolskaya" n (k o1 m s @ m o1 l s k ai @) )
( "Julio" n (jh uu1 l i ou) )
( "Jozef" n (y ou1 z e f) )
( "Gucci" n (g uu1 ch ii) )
( "Gonzalo" n (g o n z a1 l ou) )
( "Gillespie" n (g i l e1 s p ii) )
( "Ghaith" n (g ei1 th) )
( "Gacha" n (g a1 ch @) )
( "Fairbanks" n (f e@1 t b a n k s) )
( "Duvalier" n (d u v a1 l i ei) )
( "Dont" n (d ou1 n t) )
( "Danube" n (d a1 n y uu b) )
( "Cong" n (k o1 ng) )
( "Cajun" n (k ei1 jh @ n) )
( "Angelenos" n (a1 n jh i l ii1 n ou s) )
( "Abel" n (ei1 b @ l) )
( "Allis" n (a1 l @ s) )
( "zeitgeist" n (z ai1 t g ai s t) )
( "superhero" n (s uu1 p @ h ii1 r ou) )
( "racetrack" n (r ei1 s - t r a k) )
( "materiel" n (m a t ii1 r i e l) )
( "jazzman" n (jh a1 z m a n) )
( "greats" n (g r ei1 t s) )
( "faux" n (f ou1) )
( "emphysema" n (e1 m f @ s ii1 m @) )
( "divisiveness" n (d @ v ai1 s i f n @ s) )
( "bicoastal" n (b ai1 k ou1 s t @ l) )
( "apolitical" n (ei1 p @ l i1 t @ k @ l) )
( "Shepard" n (sh e1 p @ d) )
( "Romero" n (r ou m e1 r ou) )
( "Pacino" n (p @ ch ii1 n ou) )
( "Montenegro" n (m o n t @ n ii1 g r ou) )
( "Lourdes" n (l uu1 r @ d z) )
( "Kai" n (k ai1) )
( "Jamil" n (jh a m ii1 l ) )
( "Horatio" n (h @ r ei1 sh i ou) )
( "Elias" n (e1 l i @ s) )
( "Dumas" n (d uu1 m a s) )
( "Delors" n (d @ l oo1 r z) )
( "Chang" n (ch a1 ng) )
( "Andropov" n (a n d r o1 p o v ) )
( "Alvarez" n (a l v a1 r e z) )
( "whammy" n (w a1 m ii) )
( "wannabes" n (w o1 n @ b ii z) )
( "underage" n (uh1 n d @ r ei1 jh) )
( "uncaring" n (uh n k ei1 r i ng) )
( "sidelined" n (s ai1 d l ai n d) )
( "saber" n (s ei1 b @ r) )
( "redraw" n (r ii1 d r oo) )
( "recyclable" n (r ii s ai1 k l @ b @ l) )
( "phenom" n (f ii1 n ou m) )
( "paternalistic" n (p a t @@1 n @ l i s t i k) )
( "overleveraged" n (ou1 v @ l e1 v @ r ei jh d) )
( "nouvelle" n (n uu v e1 l) )
( "microchip" n (m ai1 k r ou ch i p) )
( "lifesaving" n (l ai1 f s ei1 v i ng) )
( "hormonal" n (h oo r m ou1 n @ l) )
( "homophobic" n (h ou1 m @ f ou1 b i k) )
( "gravitational" n (g r a v @ t ei1 sh @ n @ l) )
( "faxes" n (f a1 k s @ s) )
( "energize" n (e1 n @ jh ai z) )
( "counterrevolution" n (k au1 n t @ r e1 v @ l uu1 sh @ n) )
( "burgers" n (b @@1 g @ z) )
( "bimonthly" n (b ai1 m uh1 n th l ii) )
( "Zulus" n (z uu1 l uu z) )
( "Zimmerman" n (z i1 m @ m @ n) )
( "Zia" n (z ii1 @) )
( "Vincennes" n (v a1 n s e n) )
( "Tri" n (t r ai1) )
( "Tigris" n (t ai1 g r i s) )
( "Schumer" n (sh u1 m @ r) )
( "Prokofiev" n (p r ou k o1 f i e v) )
( "Minnelli" n (m i n e1 l ii) )
( "McMurtry" n (m @ k m @@1 t ii) )
( "Macbeth" n (m a k b e1 th) )
( "Loren" n (l oo1 r @ n) )
( "Levi" n (l ii1 v ai) )
( "Kumiko" n (k uu1 m i k ou) )
( "Jovanovich" n (jh ou v a1 n @ v i ch) )
( "Jamieson" n (jh ei1 m @ s @ n) )
( "Guthrie" n (g uh1 th r ii) )
( "Frankenstein" n (f r a1 n k @ n s t ai n) )
( "Farrakhan" n (f a1 r @ k aa n) )
( "Dubai" n (d uu b ai1) )
( "Dreyfuss" n (d r ei1 f @ s) )
( "Croatians" n (k r ou ei1 sh @ n z) )
( "Cezanne" n (s e z a1 n) )
( "Basinger" n (b a1 s i n jh @ r) )
( "Bankshares" n (b a1 n k sh e@ z) )
( "Antoine" n (a1 n t w o n) )
( "Achille" n (a k i1 l ii) )
( "trucking" n (t r uh1 k i ng) )
( "storefronts" n (s t oo1 r f r uh n t s) )
( "socioeconomic" n (s ou1 sh i o e1 k @ n o1 m i k) )
( "rivaled" n (r ai1 v @ l d) )
( "reusable" n (r ii y uu1 z @ b @ l) )
( "pizazz" n (p i z a1 z) )
( "overreaction" n (ou1 v @ r ii a1 k sh @ n) )
( "osteoporosis" n (o1 s t i o p o r ou1 s @ s) )
( "limo" n (l i1 m ou) )
( "interagency" n (i1 n t @ ei1 jh e n s ii) )
( "imperatives" n (i m p e1 r @ t i v z) )
( "humorless" n (h y uu1 m @ l @ s) )
( "flatbed" n (f l a1 t b e d) )
( "extraterrestrial" n (e1 k s t r @ t @ r e1 s t r i @ l) )
( "colorless" n (k uh1 l @ r l @ s) )
( "coed" n (k ou e1 d) )
( "chauffeured" n (sh ou f @@1 r d) )
( "bluesy" n (b l uu1 z ii) )
( "biomedical" n (b ai1 ou m e1 d i k @ l) )
( "biochemist" n (b ai1 ou k e1 m @ s t ) )
( "bebop" n (b ii1 b o p) )
( "barroom" n (b aa1 r uu m) )
( "accompli" n (@ k o1 m p l ei) )
( "Vaughan" n (v oo1 n) )
( "Ty" n (t ai1) )
( "Szczesny" n (zh @ zh e1 s n ii) )
