/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Uint32Array;

public class Uint32ArrayImpl
extends ArrayBufferViewImpl
implements Uint32Array {
    public Uint32ArrayImpl(ArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length * 4);
    }

    @Override
    public long get(int index) {
        long val = this.arrayBuf.getInt32(this.checkRange(index, 4), true);
        if (val < 0L) {
            val += 0x100000000L;
        }
        return val;
    }

    @Override
    public double getAsDouble(int index) {
        return this.get(index);
    }

    @Override
    public int length() {
        return this.byteLength() / 4;
    }

    @Override
    public void set(double[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(double[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(int index, double value) {
        this.set(index, (long)value);
    }

    @Override
    public void set(int index, long value) {
        this.arrayBuf.setInt32(this.checkRange(index, 4), (int)(value & 0xFFFFFFFFFFFFFFFFL), true);
    }

    @Override
    public void set(long[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(long[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(Uint32Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Uint32Array array, int offset) {
        int len = array.length();
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array.get(i));
        }
    }

    @Override
    public Uint32Array subarray(int begin) {
        int count = (this.byteLength() - this.byteOffset()) / 4;
        return this.subarray(begin, count);
    }

    @Override
    public Uint32Array subarray(int begin, int end) {
        int count = (this.byteLength() - this.byteOffset()) / 4;
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Uint32ArrayImpl(this.arrayBuf, begin * 4, end * 4);
    }
}

