/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    private static final long serialVersionUID = -7183698231559129828L;
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('B');
    public static final int SIZE = 8;
    private static Byte[] byteCache = new Byte[256];
    private final byte value;

    public static final String toString(byte by) {
        return String.valueOf(by);
    }

    public static final byte parseByte(String string) {
        return Byte.parseByte(string, 10);
    }

    public static final byte parseByte(String string, int n) {
        int n2 = Integer.parseInt(string, n, false);
        if ((byte)n2 != n2) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    public static final Byte valueOf(String string, int n) {
        return new Byte(Byte.parseByte(string, n));
    }

    public static final Byte valueOf(String string) {
        return new Byte(Byte.parseByte(string, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Byte valueOf(byte by) {
        Byte[] byteArray = byteCache;
        synchronized (byteCache) {
            if (byteCache[by - -128] == null) {
                Byte.byteCache[by - -128] = new Byte(by);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byteCache[by - -128];
        }
    }

    public static final Byte decode(String string) {
        int n = Integer.parseInt(string, 10, true);
        if ((byte)n != n) {
            throw new NumberFormatException();
        }
        return new Byte((byte)n);
    }

    public final byte byteValue() {
        return this.value;
    }

    public final short shortValue() {
        return this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Byte && this.value == ((Byte)object).value) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(Byte by) {
        return this.value - by.value;
    }

    public final int compareTo(Object object) {
        return this.compareTo((Byte)object);
    }

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) {
        this.value = Byte.parseByte(string, 10);
    }
}

