/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2008 David Zeuthen <davidz@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined (_DEVKIT_GOBJECT_COMPILATION) && !defined(_DEVKIT_GOBJECT_INSIDE_DEVKIT_GOBJECT_H)
#error "Only <devkit-gobject.h> can be included directly, this file may disappear or change contents."
#endif

#ifndef __DEVKIT_DEVICE_H__
#define __DEVKIT_DEVICE_H__

#include <devkit-gobject/devkit-types.h>

G_BEGIN_DECLS

#define DEVKIT_TYPE_DEVICE         (devkit_device_get_type ())
#define DEVKIT_DEVICE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), DEVKIT_TYPE_DEVICE, DevkitDevice))
#define DEVKIT_DEVICE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), DEVKIT_TYPE_DEVICE, DevkitDeviceClass))
#define DEVKIT_IS_DEVICE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), DEVKIT_TYPE_DEVICE))
#define DEVKIT_IS_DEVICE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), DEVKIT_TYPE_DEVICE))
#define DEVKIT_DEVICE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), DEVKIT_TYPE_DEVICE, DevkitDeviceClass))

typedef struct _DevkitDeviceClass   DevkitDeviceClass;
typedef struct _DevkitDevicePrivate DevkitDevicePrivate;

/**
 * DevkitDevice:
 * @parent: Parent instance.
 *
 * The #DevkitDevice struct is opaque and should not be accessed directly.
 */
struct _DevkitDevice
{
        GObject              parent;

        /*< private >*/
        DevkitDevicePrivate *priv;
};

/**
 * DevkitDeviceClass:
 * @parent_class: Parent class.
 *
 * Class structure for #DevkitDevice.
 */
struct _DevkitDeviceClass
{
        GObjectClass   parent_class;

        /*< private >*/
        /* Padding for future expansion */
        void (*_devkit_reserved1) (void);
        void (*_devkit_reserved2) (void);
        void (*_devkit_reserved3) (void);
        void (*_devkit_reserved4) (void);
        void (*_devkit_reserved5) (void);
        void (*_devkit_reserved6) (void);
        void (*_devkit_reserved7) (void);
        void (*_devkit_reserved8) (void);

};

/**
 * DevkitDeviceForeachFunc:
 * @device: the #DevkitDevice for we are iterating over.
 * @key: property key.
 * @value: property value.
 * @user_data: user data.
 *
 * Callback function used in devkit_device_properties_foreach().
 *
 * Returns: return %TRUE to top the iteration.
 */
typedef gboolean (*DevkitDeviceForeachFunc) (DevkitDevice *device,
                                             const gchar  *key,
                                             const gchar  *value,
                                             gpointer      user_data);

GType           devkit_device_get_type                  (void) G_GNUC_CONST;
const gchar    *devkit_device_get_subsystem             (DevkitDevice             *device);
const gchar    *devkit_device_get_native_path           (DevkitDevice             *device);
const gchar    *devkit_device_get_device_file           (DevkitDevice             *device);
const gchar   **devkit_device_get_device_file_symlinks  (DevkitDevice             *device);
gboolean        devkit_device_properties_foreach        (DevkitDevice             *device,
                                                         DevkitDeviceForeachFunc   func,
                                                         gpointer                  user_data);
gboolean        devkit_device_has_property              (DevkitDevice             *device,
                                                         const gchar              *key);
const gchar    *devkit_device_get_property              (DevkitDevice             *device,
                                                         const gchar              *key);
gint            devkit_device_get_property_as_int       (DevkitDevice             *device,
                                                         const gchar              *key);
guint64         devkit_device_get_property_as_uint64    (DevkitDevice             *device,
                                                         const gchar              *key);
gboolean        devkit_device_get_property_as_boolean   (DevkitDevice             *device,
                                                         const gchar              *key);
gchar          *devkit_device_dup_property_as_str       (DevkitDevice             *device,
                                                         const gchar              *key);
gchar         **devkit_device_dup_property_as_strv      (DevkitDevice             *device,
                                                         const gchar              *key);

G_END_DECLS

#endif /* __DEVKIT_DEVICE_H__ */
