/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.component;

import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.persistence.XMLException;
import org.wiztools.restclient.ui.ScriptEditor;
import org.wiztools.restclient.ui.TextEditorSyntax;
import org.wiztools.restclient.ui.component.BackgroundFormatterJob;
import org.wiztools.restclient.ui.component.BodyPopupMenuListener;
import org.wiztools.restclient.util.HTMLIndentUtil;
import org.wiztools.restclient.util.JSONUtil;
import org.wiztools.restclient.util.XMLIndentUtil;

public class BodyPopupMenu
extends JPopupMenu {
    private BackgroundFormatterJob job = new BackgroundFormatterJob();

    public BodyPopupMenu(ScriptEditor se, BodyPopupMenuListener listener, boolean isSeparateThread) {
        JMenu jm_format = new JMenu("Format");
        JMenuItem jmi_fmt_xml = new JMenuItem("XML");
        jmi_fmt_xml.addActionListener(e -> {
            String unformatted = se.getText();
            if (StringUtil.isEmpty(unformatted)) {
                listener.onFailure("Body is empty.");
                return;
            }
            Runnable r = () -> {
                try {
                    String out = XMLIndentUtil.getIndented(unformatted);
                    se.setText(out);
                    listener.onSuccess("Formatted successfully.");
                }
                catch (IOException | XMLException ex) {
                    listener.onFailure("Formatting error: " + ex.getMessage());
                }
            };
            this.job.run(r, listener, isSeparateThread);
        });
        jm_format.add(jmi_fmt_xml);
        JMenuItem jmi_fmt_json = new JMenuItem("JSON");
        jmi_fmt_json.addActionListener(e -> {
            String unformatted = se.getText();
            if (StringUtil.isEmpty(unformatted)) {
                listener.onFailure("Body is empty.");
                return;
            }
            Runnable r = () -> {
                try {
                    String out = JSONUtil.indentJSON(unformatted);
                    se.setText(out);
                    listener.onSuccess("Formatted successfully.");
                }
                catch (JSONUtil.JSONParseException ex) {
                    listener.onFailure("Formatting error: " + ex.getMessage());
                }
            };
            this.job.run(r, listener, isSeparateThread);
        });
        jm_format.add(jmi_fmt_json);
        JMenuItem jmi_fmt_html = new JMenuItem("HTML");
        jmi_fmt_html.addActionListener(e -> {
            String unformatted = se.getText();
            if (StringUtil.isEmpty(unformatted)) {
                listener.onFailure("Body is empty.");
                return;
            }
            Runnable r = () -> {
                try {
                    String out = HTMLIndentUtil.getIndented(unformatted);
                    se.setText(out);
                    listener.onSuccess("Formatted successfully.");
                }
                catch (Exception ex) {
                    listener.onFailure("Formatting error: " + ex.getMessage());
                }
            };
            this.job.run(r, listener, isSeparateThread);
        });
        jm_format.add(jmi_fmt_html);
        this.add(jm_format);
        JMenu jm_syntax = new JMenu("Syntax Color");
        JMenuItem jmi_syntax_none = new JMenuItem("None");
        jmi_syntax_none.addActionListener(evt -> se.setSyntax(TextEditorSyntax.NONE));
        jm_syntax.add(jmi_syntax_none);
        JMenuItem jmi_syntax_xml = new JMenuItem("XML");
        jmi_syntax_xml.addActionListener(evt -> se.setSyntax(TextEditorSyntax.XML));
        jm_syntax.add(jmi_syntax_xml);
        JMenuItem jmi_syntax_json = new JMenuItem("JSON");
        jmi_syntax_json.addActionListener(evt -> se.setSyntax(TextEditorSyntax.JSON));
        jm_syntax.add(jmi_syntax_json);
        JMenuItem jmi_syntax_html = new JMenuItem("HTML");
        jmi_syntax_html.addActionListener(evt -> se.setSyntax(TextEditorSyntax.HTML));
        jm_syntax.add(jmi_syntax_html);
        this.add(jm_syntax);
    }

    public void cancelRunningJob() {
        this.job.cancelRunningJob();
    }
}

