# gdchart examples
#
# - All chart styles except PIE can accept multiple data sets (but see next
#   note)
#
# - Missing data values:
#   - For pie charts, missing data values can be indicated by passing a second
#     data set; 0 or None in the second data set indicates that the
#     corresponding value in the first data set should be considered missing
#     (i.e., it won't be drawn on the chart).
#   - For other charts, None in a data set indicates a missing value.

import gdchart
import cStringIO  # optional
from chart import Chart

# TestChart: a simple class for testing gdchart functionality.  For your own
# work, you will probably want a more specialized class, e.g., to maintain
# more of its own state and reduce the number of parameters to draw().
class TestChart(Chart):
    def __init__(self):
	Chart.__init__(self)

    def draw(self, style, size, file, labels, *data):
	Chart.draw(self)
	args = (style, size, file, labels) + data
	apply(gdchart.chart, args)

size = (250, 250)
data1 = (0.5, 0.09, 0.3, 0.75, 0.0, 0.90)
data2 = (1.9, 1.3, 1.2, 0.75, 0.1, 2.0)
data3 = (62, 71, 71, 52, 55, 48)
data4 = (42, 62, 52, 37, 52, 50)
cities = ('Chicago', 'New York', 'L.A.', 'Atlanta', 'Paris, MD\n(USA)', 'London')
days = ('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday')

c = TestChart()

# Simple chart.
# Other styles: GDC_AREA, GDC_BAR, GDC_LINE, GDC_3DAREA, GDC_3DLINE.
c.option(set_color=(0xff8080, 0x8080ff))
c.option(bg_color=0xffffff, plot_color=0x0000cd, line_color=0x000000)
c.option(title='Simple Chart', xtitle='X Axis', ytitle='Y Axis')
c.draw(gdchart.GDC_3DBAR, size, 'test1.png', cities, data1, data2)

# Floating bar chart.
# Other style: GDC_FLOATINGBAR.
al=(24, 24, 22, 21, 18, 16)
ah=(49, 47, 45, 44, 43, 44)
bl=(10, 12, 15, 16, 18, 18)
bh=(48, 47, 48, 49, 51, 53)
c.option(set_color=(0x0040a0, 0x00a040))
c.option(title='Floating Bar Chart', xtitle='', ytitle='')
c.draw(gdchart.GDC_3DFLOATINGBAR, size, 'test2.png', days, (al, ah), (bl, bh))

# Pie chart
# Other style: GDC_2DPIE.
c.option(bg_color=0x335599, bg_transparent=1)
c.option(pie_color=(0xff8080, 0x80ff80, 0x8080ff, 0xffff80, 0xff80ff, 0x80ffff))
c.option(edge_color=0x0, line_color=0xffffff)
c.option(label_line=1)
c.option(explode=(0,0,0,0,0,15))
c.option(title='Pie Test')
c.draw(gdchart.GDC_3DPIE, size, 'test3.png', cities, data2)

# Combo chart
# Other styles: GDC_COMBO_LINE_AREA, GDC_COMBO_LINE_BAR, GDC_COMBO_LINE_LINE,
#   GDC_3DCOMBO_LINE_AREA, GDC_3DCOMBO_LINE_LINE.
c.option(title='Combo Chart')
c.option(yaxis=0, yaxis2=0)
c.option(bg_color=0x0, bg_transparent=0)
c.option(set_color=(0xffffff,), vol_color=0x408080)
c.draw(gdchart.GDC_3DCOMBO_LINE_BAR, size, 'test4.png', days, data3, data4)

# Hi-lo-close chart
# Other style: GDC_HILOCLOSE.
dates = ('Jan 1', 'Jan 8', 'Jan 15', 'Jan 22', 'Jan 29', 'Feb 5')
h1=(28,30,32,33,36,35)
l1=(24,27,28,30,31,31)
c1=(27,29,30,31,33,32)

h2=map(lambda x:0.7*x - 2, h1); h2.reverse()
l2=map(lambda x:0.5*x - 2, l1); l2.reverse()
c2=map(lambda x:0.6*x - 2, c1); c2.reverse()

c.option(title='Hi-Lo-Close Chart')
c.option(yaxis=1, ylabel_fmt='$%.0f ')
c.option(set_color=(0x80ff80, 0xff8080, 0x8080ff, 0x808080, 0x606060, 0xa0a0a0))
c.option(hlc_style=gdchart.GDC_HLC_I_CAP + gdchart.GDC_HLC_CONNECTING)

c.option(format=gdchart.GDC_GIF)

# cStringIO example
out = cStringIO.StringIO()
c.draw(gdchart.GDC_3DHILOCLOSE, size, out, dates, (h1,l1,c1), (h2, l2, c2))
f = open('test5.gif', 'wb')
f.write(out.getvalue())
f.close()

# Combo hi-lo-close chart
# Other styles: GDC_COMBO_HLC_AREA, GDC_COMBO_HLC_BAR, GDC_3DCOMBO_HLC_BAR.
c.option(title='Combo Hi-Lo-Close Chart')
c.option(yaxis2=1)
c.option(set_color=(0xa0ffa0, 0xa0ffa0, 0xffffff), vol_color=0xa0a0a0)
c.option(ytitle='Price', ytitle_color=0xc0c0c0)
c.option(ytitle2='Volume (K)', ytitle2_color=0xc0c0c0)
c.option(format=gdchart.GDC_JPEG)
f = open('test6.jpg', 'wb')
c.draw(gdchart.GDC_3DCOMBO_HLC_AREA, size, f, dates, (h1,l1,c1), data3)
f.close()

# Examples of other options
h3 = (17.8, 17.1, 17.3, None, 17.2, 17.1,
      17.3, 17.3, 17.3, 17.1, 17.5, 17.4)

c3 = (17.0, 16.8, 16.9, None, 16.9, 16.8,
      17.2, 16.8, 17.0, 16.9, 16.4, 16.1)

l3 = (16.8, 16.8, 16.7, None, 16.5, 16.0,
      16.1, 16.8, 16.5, 16.9, 16.2, 16.0)

v3 = (150.0, 100.0, 340.0, None, 999.0, 390.0,
      420.0, 150.0, 100.0, 340.0, 1590.0, 700.0)

t3 = ('May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec', 'Jan',
      'Feb', 'Mar', 'Apr')

c.option(hlc_style = gdchart.GDC_HLC_I_CAP | gdchart.GDC_HLC_CLOSE_CONNECTED)
c.option(hlc_cap_width=45)
c.option(bar_width=75)
c.option(title='Widget Corp.', ytitle='Price ($)', ytitle2='Volume (K)')
c.option(vol_color=0x4040ff)
c.option(plot_color=0xffffff)
c.option(grid=0)
c.option(ylabel_density=50, ylabel_fmt='')
c.option(annotation=(3, 0x00ff00, 'Did Not\nTrade'))
c.option(scatter=(
	(3.0, 16.80, 60, 0xff0000, gdchart.GDC_SCATTER_TRIANGLE_DOWN),
	(3.0, 16.25, 60, 0xff0000, gdchart.GDC_SCATTER_TRIANGLE_UP)))
c.option(bg_image='w.gif')
c.option(format=gdchart.GDC_PNG)
c.draw(gdchart.GDC_COMBO_HLC_BAR, size, 'test7.png', t3, (h3,l3,c3), v3)

