"""Generated message classes for recommender version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'recommender'


class GoogleCloudRecommenderV1alpha1Condition(_messages.Message):
  r"""Condition of the rule. Condition will match all fields specified within
  the Condition.

  Messages:
    FieldsValue: Fields and value of recommendation to match, this will be
      part of the recommendation.

  Fields:
    fields: Fields and value of recommendation to match, this will be part of
      the recommendation.
    recommenderId: Id of the Recommender to match. Eg,
      com.google.iam.RoleRecommender.
    resources: Resource names to match.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Fields and value of recommendation to match, this will be part of the
    recommendation.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  fields = _messages.MessageField('FieldsValue', 1)
  recommenderId = _messages.StringField(2)
  resources = _messages.StringField(3, repeated=True)


class GoogleCloudRecommenderV1alpha1CostProjection(_messages.Message):
  r"""Contains metadata about how much money a recommendation can save or
  incur.

  Fields:
    cost: An approximate projection on amount saved or amount incurred.
      Negative cost units indicate cost savings and positive cost units
      indicate increase. See google.type.Money documentation for
      positive/negative units.
    duration: Duration for which this cost applies.
  """

  cost = _messages.MessageField('GoogleTypeMoney', 1)
  duration = _messages.StringField(2)


class GoogleCloudRecommenderV1alpha1CreateRecommendationRuleRequest(_messages.Message):
  r"""Request for the 'CreateRecommendationRule' method.

  Enums:
    TargetStateValueValuesEnum: State to set for the recommendation. Only
      DISMISSED state is allowed.

  Fields:
    targetState: State to set for the recommendation. Only DISMISSED state is
      allowed.
  """

  class TargetStateValueValuesEnum(_messages.Enum):
    r"""State to set for the recommendation. Only DISMISSED state is allowed.

    Values:
      STATE_UNSPECIFIED: Default state. Don't use directly.
      ACTIVE: Recommendation is active and can be applied. Recommendations
        content can be updated by Google. ACTIVE recommendations can be marked
        as CLAIMED, SUCCEEDED, or FAILED.
      CLAIMED: Recommendation is in claimed state. Recommendations content is
        immutable and cannot be updated by Google. CLAIMED recommendations can
        be marked as CLAIMED, SUCCEEDED, or FAILED.
      SUCCEEDED: Recommendation is in succeeded state. Recommendations content
        is immutable and cannot be updated by Google. SUCCEEDED
        recommendations can be marked as SUCCEEDED, or FAILED.
      FAILED: Recommendation is in failed state. Recommendations content is
        immutable and cannot be updated by Google. FAILED recommendations can
        be marked as SUCCEEDED, or FAILED.
      DISMISSED: Recommendation is in dismissed state. DISMISSED
        recommendations can be marked as ACTIVE.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CLAIMED = 2
    SUCCEEDED = 3
    FAILED = 4
    DISMISSED = 5

  targetState = _messages.EnumField('TargetStateValueValuesEnum', 1)


class GoogleCloudRecommenderV1alpha1Impact(_messages.Message):
  r"""Contains the impact a recommendation can have for a given category.

  Enums:
    CategoryValueValuesEnum: Category that is being targeted.

  Fields:
    category: Category that is being targeted.
    costProjection: Optional. Use with CategoryType.COST
  """

  class CategoryValueValuesEnum(_messages.Enum):
    r"""Category that is being targeted.

    Values:
      CATEGORY_UNSPECIFIED: Default unspecified category. Don't use directly.
      COST: Indicates a potential increase or decrease in cost.
      SECURITY: Indicates a potential increase or decrease in security.
      PERFORMANCE: Indicates a potential increase or decrease in performance.
    """
    CATEGORY_UNSPECIFIED = 0
    COST = 1
    SECURITY = 2
    PERFORMANCE = 3

  category = _messages.EnumField('CategoryValueValuesEnum', 1)
  costProjection = _messages.MessageField('GoogleCloudRecommenderV1alpha1CostProjection', 2)


class GoogleCloudRecommenderV1alpha1ListRecommendationsResponse(_messages.Message):
  r"""Response to the `ListRecommendations` method.

  Fields:
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
    recommendations: The set of recommendations for the `parent` resource.
  """

  nextPageToken = _messages.StringField(1)
  recommendations = _messages.MessageField('GoogleCloudRecommenderV1alpha1Recommendation', 2, repeated=True)


class GoogleCloudRecommenderV1alpha1ListRulesResponse(_messages.Message):
  r"""Response for the 'ListRules' method.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    rules: Rules listed. Ordered by id by default.
  """

  nextPageToken = _messages.StringField(1)
  rules = _messages.MessageField('GoogleCloudRecommenderV1alpha1Rule', 2, repeated=True)


class GoogleCloudRecommenderV1alpha1MarkActiveRequest(_messages.Message):
  r"""Request for the `MarkActive` Method.

  Fields:
    etag: Fingerprint of the Recommendation. Provides optimistic locking.
  """

  etag = _messages.StringField(1)


class GoogleCloudRecommenderV1alpha1MarkClaimedRequest(_messages.Message):
  r"""Request for the `MarkClaimed` Method.

  Messages:
    StateMetadataValue: State properties user wish to include with this state.
      Full replace of the current state_metadata.

  Fields:
    etag: Fingerprint of the Recommendation. Provides optimistic locking.
    stateMetadata: State properties user wish to include with this state. Full
      replace of the current state_metadata.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StateMetadataValue(_messages.Message):
    r"""State properties user wish to include with this state. Full replace of
    the current state_metadata.

    Messages:
      AdditionalProperty: An additional property for a StateMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type StateMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StateMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  etag = _messages.StringField(1)
  stateMetadata = _messages.MessageField('StateMetadataValue', 2)


class GoogleCloudRecommenderV1alpha1MarkFailedRequest(_messages.Message):
  r"""Request for the `MarkFailed` Method.

  Messages:
    StateMetadataValue: State properties user wish to include with this state.
      Full replace of the current state_metadata.

  Fields:
    etag: Fingerprint of the Recommendation. Provides optimistics locking.
    stateMetadata: State properties user wish to include with this state. Full
      replace of the current state_metadata.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StateMetadataValue(_messages.Message):
    r"""State properties user wish to include with this state. Full replace of
    the current state_metadata.

    Messages:
      AdditionalProperty: An additional property for a StateMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type StateMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StateMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  etag = _messages.StringField(1)
  stateMetadata = _messages.MessageField('StateMetadataValue', 2)


class GoogleCloudRecommenderV1alpha1MarkSucceededRequest(_messages.Message):
  r"""Request for the `MarkSucceeded` Method.

  Messages:
    StateMetadataValue: State properties user wish to include with this state.
      Full replace of the current state_metadata.

  Fields:
    etag: Fingerprint of the Recommendation. Provides optimistic locking.
    stateMetadata: State properties user wish to include with this state. Full
      replace of the current state_metadata.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StateMetadataValue(_messages.Message):
    r"""State properties user wish to include with this state. Full replace of
    the current state_metadata.

    Messages:
      AdditionalProperty: An additional property for a StateMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type StateMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StateMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  etag = _messages.StringField(1)
  stateMetadata = _messages.MessageField('StateMetadataValue', 2)


class GoogleCloudRecommenderV1alpha1Operation(_messages.Message):
  r"""Contains an operation for a resource inspired by the JSON-PATCH format
  with support for: * Custom filters for describing partial array patch. *
  Extended path values for describing nested arrays. * Custom fields for
  describing the resource for which the operation is being described. * Allows
  extension to custom operations not natively supported by RFC6902. See
  https://tools.ietf.org/html/rfc6902 for details on the original RFC.

  Messages:
    PathFilterValue: Set of filters to apply if `path` refers to array
      elements or nested array elements in order to narrow down to a single
      unique element that is being tested/modified. Example: {
      "/versions/*/name" : "it-123" "/versions/*/targetSize/percent": "20" }

  Fields:
    action: Required. Type of this operation. Supports 'add', 'remove',
      'replace', 'move', 'copy', 'test' and custom operations. This field is
      also case-insensitive.
    path: Required. Path to the target field being operated on. If the
      operation is at the resource level, then path should be "/".
    pathFilter: Set of filters to apply if `path` refers to array elements or
      nested array elements in order to narrow down to a single unique element
      that is being tested/modified. Example: { "/versions/*/name" : "it-123"
      "/versions/*/targetSize/percent": "20" }
    resource: Required. Contains the fully qualified resource name. ex:
      //cloudresourcemanager.googleapis.com/projects/foo.
    resourceType: Required. Type of GCP resource being modified/tested.
      Example: cloudresourcemanager.googleapis.com/Project,
      compute.googleapis.com/Instance
    sourcePath: Required if action is 'copy' or 'move' to indicate the source
      field or resource, ignored if provided for other operation types.
    sourceResource: Use for COPY operation across different resources (of the
      same type). Example: A resource clone can be done via action = 'copy',
      path = "/", from = "/", source_resource = and resource_name = .
    value: Value for the `path` field. Required if action is
      'add'/'replace'/'test'.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PathFilterValue(_messages.Message):
    r"""Set of filters to apply if `path` refers to array elements or nested
    array elements in order to narrow down to a single unique element that is
    being tested/modified. Example: { "/versions/*/name" : "it-123"
    "/versions/*/targetSize/percent": "20" }

    Messages:
      AdditionalProperty: An additional property for a PathFilterValue object.

    Fields:
      additionalProperties: Additional properties of type PathFilterValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PathFilterValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  action = _messages.StringField(1)
  path = _messages.StringField(2)
  pathFilter = _messages.MessageField('PathFilterValue', 3)
  resource = _messages.StringField(4)
  resourceType = _messages.StringField(5)
  sourcePath = _messages.StringField(6)
  sourceResource = _messages.StringField(7)
  value = _messages.MessageField('extra_types.JsonValue', 8)


class GoogleCloudRecommenderV1alpha1OperationGroup(_messages.Message):
  r"""Group of operations that need to be performed atomically.

  Fields:
    operations: List of operations across one or more resources that belong to
      this group. Loosely based on RFC6902 and should be performed in the
      order they appear.
  """

  operations = _messages.MessageField('GoogleCloudRecommenderV1alpha1Operation', 1, repeated=True)


class GoogleCloudRecommenderV1alpha1Recommendation(_messages.Message):
  r"""A recommendation along with a suggested action. E.g., a rightsizing
  recommendation for an underutilized VM, next product suggestion for billing
  account.

  Fields:
    additionalImpact: Optional set of additional impact that this
      recommendation may have when trying to optimize for the primary
      category. These may be positive or negative.
    content: Output only. Content of the recommendation describing why a
      recommendation was generated and what the changes are.
    description: Required. Free-form human readable summary in English. The
      maximum length is 500 characters.
    etag: Output only. Fingerprint of the Recommendation. Provides optimistics
      locking when updating states.
    lastRefreshTime: Output only. Last time this recommendation was refreshed
      by the system that created it in the first place.
    name: Name of recommendation. * A project recommendation is represented as
      projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER
      _ID]/recommendations/[RECOMMENDATION_ID] Example: A recommendation for a
      GCP resource such as compute instance, storage bucket is represented as
      a project recommendation. projects/[PROJECT_NUMBER]/locations/[LOCATION]
      /recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
    primaryImpact: Required. The primary impact that this recommendation can
      have while trying to optimize for one category.
    stateInfo: Information for state. Contains state and metadata.
  """

  additionalImpact = _messages.MessageField('GoogleCloudRecommenderV1alpha1Impact', 1, repeated=True)
  content = _messages.MessageField('GoogleCloudRecommenderV1alpha1RecommendationContent', 2)
  description = _messages.StringField(3)
  etag = _messages.StringField(4)
  lastRefreshTime = _messages.StringField(5)
  name = _messages.StringField(6)
  primaryImpact = _messages.MessageField('GoogleCloudRecommenderV1alpha1Impact', 7)
  stateInfo = _messages.MessageField('GoogleCloudRecommenderV1alpha1RecommendationStateInfo', 8)


class GoogleCloudRecommenderV1alpha1RecommendationContent(_messages.Message):
  r"""Contains reasoning around why a recommendation is generated, what
  resources are changing and how they are changing.

  Messages:
    JustificationValue: Required. A struct of custom fields per recommender to
      explain the rationale behind generating this recommendation. Example:
      "numGrantedPermissions": "1000"

  Fields:
    justification: Required. A struct of custom fields per recommender to
      explain the rationale behind generating this recommendation. Example:
      "numGrantedPermissions": "1000"
    operationGroups: Operations to one or more Google Cloud resources grouped
      in such a way that, all operations within one group are expected to be
      performed atomically and in an order.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class JustificationValue(_messages.Message):
    r"""Required. A struct of custom fields per recommender to explain the
    rationale behind generating this recommendation. Example:
    "numGrantedPermissions": "1000"

    Messages:
      AdditionalProperty: An additional property for a JustificationValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a JustificationValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  justification = _messages.MessageField('JustificationValue', 1)
  operationGroups = _messages.MessageField('GoogleCloudRecommenderV1alpha1OperationGroup', 2, repeated=True)


class GoogleCloudRecommenderV1alpha1RecommendationStateInfo(_messages.Message):
  r"""Information for state. Contains state and metadata.

  Enums:
    StateValueValuesEnum: Output only. The state of the recommendation, Eg
      ACTIVE, SUCCEEDED, FAILED.

  Messages:
    StateMetadataValue: A map of metadata for the state, provided by user or
      automations systems.

  Fields:
    state: Output only. The state of the recommendation, Eg ACTIVE, SUCCEEDED,
      FAILED.
    stateMetadata: A map of metadata for the state, provided by user or
      automations systems.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the recommendation, Eg ACTIVE, SUCCEEDED,
    FAILED.

    Values:
      STATE_UNSPECIFIED: Default state. Don't use directly.
      ACTIVE: Recommendation is active and can be applied. Recommendations
        content can be updated by Google. ACTIVE recommendations can be marked
        as CLAIMED, SUCCEEDED, or FAILED.
      CLAIMED: Recommendation is in claimed state. Recommendations content is
        immutable and cannot be updated by Google. CLAIMED recommendations can
        be marked as CLAIMED, SUCCEEDED, or FAILED.
      SUCCEEDED: Recommendation is in succeeded state. Recommendations content
        is immutable and cannot be updated by Google. SUCCEEDED
        recommendations can be marked as SUCCEEDED, or FAILED.
      FAILED: Recommendation is in failed state. Recommendations content is
        immutable and cannot be updated by Google. FAILED recommendations can
        be marked as SUCCEEDED, or FAILED.
      DISMISSED: Recommendation is in dismissed state. DISMISSED
        recommendations can be marked as ACTIVE.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CLAIMED = 2
    SUCCEEDED = 3
    FAILED = 4
    DISMISSED = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StateMetadataValue(_messages.Message):
    r"""A map of metadata for the state, provided by user or automations
    systems.

    Messages:
      AdditionalProperty: An additional property for a StateMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type StateMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StateMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  state = _messages.EnumField('StateValueValuesEnum', 1)
  stateMetadata = _messages.MessageField('StateMetadataValue', 2)


class GoogleCloudRecommenderV1alpha1Rule(_messages.Message):
  r"""Rule is used to set states for Recommendations matching the conditions.
  Rule can be applied to current and future recommendations.

  Enums:
    TargetStateValueValuesEnum: State to set for recommendations matching the
      conditions.

  Fields:
    condition: Condition of the rule, conditions matches all fields specified
      in the conditions.
    name: Output only. Unique name of the rule, generated by the server. Eg,
      projects/*/rules/*
    targetState: State to set for recommendations matching the conditions.
    updateTime: Output only. Last update time for the rule.
  """

  class TargetStateValueValuesEnum(_messages.Enum):
    r"""State to set for recommendations matching the conditions.

    Values:
      STATE_UNSPECIFIED: Default state. Don't use directly.
      ACTIVE: Recommendation is active and can be applied. Recommendations
        content can be updated by Google. ACTIVE recommendations can be marked
        as CLAIMED, SUCCEEDED, or FAILED.
      CLAIMED: Recommendation is in claimed state. Recommendations content is
        immutable and cannot be updated by Google. CLAIMED recommendations can
        be marked as CLAIMED, SUCCEEDED, or FAILED.
      SUCCEEDED: Recommendation is in succeeded state. Recommendations content
        is immutable and cannot be updated by Google. SUCCEEDED
        recommendations can be marked as SUCCEEDED, or FAILED.
      FAILED: Recommendation is in failed state. Recommendations content is
        immutable and cannot be updated by Google. FAILED recommendations can
        be marked as SUCCEEDED, or FAILED.
      DISMISSED: Recommendation is in dismissed state. DISMISSED
        recommendations can be marked as ACTIVE.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CLAIMED = 2
    SUCCEEDED = 3
    FAILED = 4
    DISMISSED = 5

  condition = _messages.MessageField('GoogleCloudRecommenderV1alpha1Condition', 1)
  name = _messages.StringField(2)
  targetState = _messages.EnumField('TargetStateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeMoney(_messages.Message):
  r"""Represents an amount of money with its currency type.

  Fields:
    currencyCode: The three-letter currency code defined in ISO 4217.
    nanos: Number of nano (10^-9) units of the amount. The value must be
      between -999,999,999 and +999,999,999 inclusive. If `units` is positive,
      `nanos` must be positive or zero. If `units` is zero, `nanos` can be
      positive, zero, or negative. If `units` is negative, `nanos` must be
      negative or zero. For example $-1.75 is represented as `units`=-1 and
      `nanos`=-750,000,000.
    units: The whole units of the amount. For example if `currencyCode` is
      `"USD"`, then 1 unit is one US dollar.
  """

  currencyCode = _messages.StringField(1)
  nanos = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  units = _messages.IntegerField(3)


class RecommenderProjectsLocationsRecommendersRecommendationsCreateRuleRequest(_messages.Message):
  r"""A
  RecommenderProjectsLocationsRecommendersRecommendationsCreateRuleRequest
  object.

  Fields:
    googleCloudRecommenderV1alpha1CreateRecommendationRuleRequest: A
      GoogleCloudRecommenderV1alpha1CreateRecommendationRuleRequest resource
      to be passed as the request body.
    name: Name of Recommendation to create from, the recommendation will be
      used as the template for creating a Rule. The API will use predefined
      methods to generate Rules "similar" to the given Recommendation.
  """

  googleCloudRecommenderV1alpha1CreateRecommendationRuleRequest = _messages.MessageField('GoogleCloudRecommenderV1alpha1CreateRecommendationRuleRequest', 1)
  name = _messages.StringField(2, required=True)


class RecommenderProjectsLocationsRecommendersRecommendationsGetRequest(_messages.Message):
  r"""A RecommenderProjectsLocationsRecommendersRecommendationsGetRequest
  object.

  Fields:
    name: Name of the recommendation.
  """

  name = _messages.StringField(1, required=True)


class RecommenderProjectsLocationsRecommendersRecommendationsListRequest(_messages.Message):
  r"""A RecommenderProjectsLocationsRecommendersRecommendationsListRequest
  object.

  Fields:
    filter: Filter expression to restrict the recommendations returned.
      Supported filter fields: state_info.state Eg:
      `stateInfo.state:"DISMISSED" or stateInfo.state:"FAILED"
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of
      `next_page_token` in the response indicates that more results might be
      available. If not specified, the default page_size is 50.
    pageToken: Optional. If present, retrieves the next batch of results from
      the preceding call to this method. `page_token` must be the value of
      `next_page_token` from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The container resource on which to execute the request.
      Acceptable formats: 1. "projects/[PROJECT_NUMBER]/locations/[LOCATION]/r
      ecommenders/[RECOMMENDER_ID]", LOCATION here refers to GCP Locations:
      https://cloud.google.com/about/locations/
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class RecommenderProjectsLocationsRecommendersRecommendationsMarkActiveRequest(_messages.Message):
  r"""A
  RecommenderProjectsLocationsRecommendersRecommendationsMarkActiveRequest
  object.

  Fields:
    googleCloudRecommenderV1alpha1MarkActiveRequest: A
      GoogleCloudRecommenderV1alpha1MarkActiveRequest resource to be passed as
      the request body.
    name: Name of the recommendation.
  """

  googleCloudRecommenderV1alpha1MarkActiveRequest = _messages.MessageField('GoogleCloudRecommenderV1alpha1MarkActiveRequest', 1)
  name = _messages.StringField(2, required=True)


class RecommenderProjectsLocationsRecommendersRecommendationsMarkClaimedRequest(_messages.Message):
  r"""A
  RecommenderProjectsLocationsRecommendersRecommendationsMarkClaimedRequest
  object.

  Fields:
    googleCloudRecommenderV1alpha1MarkClaimedRequest: A
      GoogleCloudRecommenderV1alpha1MarkClaimedRequest resource to be passed
      as the request body.
    name: Name of the recommendation.
  """

  googleCloudRecommenderV1alpha1MarkClaimedRequest = _messages.MessageField('GoogleCloudRecommenderV1alpha1MarkClaimedRequest', 1)
  name = _messages.StringField(2, required=True)


class RecommenderProjectsLocationsRecommendersRecommendationsMarkFailedRequest(_messages.Message):
  r"""A
  RecommenderProjectsLocationsRecommendersRecommendationsMarkFailedRequest
  object.

  Fields:
    googleCloudRecommenderV1alpha1MarkFailedRequest: A
      GoogleCloudRecommenderV1alpha1MarkFailedRequest resource to be passed as
      the request body.
    name: Name of the recommendation.
  """

  googleCloudRecommenderV1alpha1MarkFailedRequest = _messages.MessageField('GoogleCloudRecommenderV1alpha1MarkFailedRequest', 1)
  name = _messages.StringField(2, required=True)


class RecommenderProjectsLocationsRecommendersRecommendationsMarkSucceededRequest(_messages.Message):
  r"""A
  RecommenderProjectsLocationsRecommendersRecommendationsMarkSucceededRequest
  object.

  Fields:
    googleCloudRecommenderV1alpha1MarkSucceededRequest: A
      GoogleCloudRecommenderV1alpha1MarkSucceededRequest resource to be passed
      as the request body.
    name: Name of the recommendation.
  """

  googleCloudRecommenderV1alpha1MarkSucceededRequest = _messages.MessageField('GoogleCloudRecommenderV1alpha1MarkSucceededRequest', 1)
  name = _messages.StringField(2, required=True)


class RecommenderProjectsRulesApplyRequest(_messages.Message):
  r"""A RecommenderProjectsRulesApplyRequest object.

  Fields:
    name: Name of rule to apply.
  """

  name = _messages.StringField(1, required=True)


class RecommenderProjectsRulesDeleteRequest(_messages.Message):
  r"""A RecommenderProjectsRulesDeleteRequest object.

  Fields:
    name: Name of rule to delete.
  """

  name = _messages.StringField(1, required=True)


class RecommenderProjectsRulesGetRequest(_messages.Message):
  r"""A RecommenderProjectsRulesGetRequest object.

  Fields:
    name: Name of rule to get.
  """

  name = _messages.StringField(1, required=True)


class RecommenderProjectsRulesListRequest(_messages.Message):
  r"""A RecommenderProjectsRulesListRequest object.

  Fields:
    pageSize: The maximum number of rules to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Parent name of the rules to list.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
