/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class AbstractTransistorSymbol
extends AbstractComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size PIN_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Color COLOR = Color.black;
    protected String value = "";
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected Color color = COLOR;
    protected Display display = Display.NAME;
    protected transient Shape[] body;

    public AbstractTransistorSymbol() {
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        if (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING) {
            finalColor = SELECTION_COLOR;
        } else if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalColor = theme.getOutlineColor();
        } else {
            finalColor = this.color;
        }
        g2d.setColor(finalColor);
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2));
        g2d.draw(body[0]);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.draw(body[1]);
        g2d.fill(body[2]);
        g2d.setFont(LABEL_FONT);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR;
        }
        g2d.setColor(finalLabelColor);
        this.drawCenteredText(g2d, this.display == Display.VALUE ? this.getValue() : this.getName(), x + pinSpacing * 2, y, HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    private void updateControlPoints() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        this.controlPoints[1].x = x + pinSpacing * 2;
        this.controlPoints[1].y = y - pinSpacing * 2;
        this.controlPoints[2].x = x + pinSpacing * 2;
        this.controlPoints[2].y = y + pinSpacing * 2;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    protected abstract Shape[] getBody();
}

