/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.BinaryCigarCodec;
import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.SortingCollection;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class BAMRecordCodec
implements SortingCollection.Codec<SAMRecord> {
    private static final Log LOG = Log.getInstance(BAMRecordCodec.class);
    private final SAMFileHeader header;
    private final BinaryCodec binaryCodec = new BinaryCodec();
    private final BinaryTagCodec binaryTagCodec = new BinaryTagCodec(this.binaryCodec);
    private final SAMRecordFactory samRecordFactory;
    private boolean isReferenceSizeWarningShowed = false;

    public BAMRecordCodec(SAMFileHeader header) {
        this(header, new DefaultSAMRecordFactory());
    }

    public BAMRecordCodec(SAMFileHeader header, SAMRecordFactory factory) {
        this.header = header;
        this.samRecordFactory = factory;
    }

    public BAMRecordCodec clone() {
        return new BAMRecordCodec(this.header, this.samRecordFactory);
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.binaryCodec.setOutputStream(os);
    }

    public void setOutputStream(OutputStream os, String filename) {
        this.binaryCodec.setOutputStream(os);
        this.binaryCodec.setOutputFileName(filename);
    }

    @Override
    public void setInputStream(InputStream is) {
        this.binaryCodec.setInputStream(is);
    }

    public void setInputStream(InputStream is, String filename) {
        this.binaryCodec.setInputStream(is);
        this.binaryCodec.setInputFileName(filename);
    }

    @Override
    public void encode(SAMRecord alignment) {
        Cigar cigarToWrite;
        boolean cigarSwitcharoo;
        int readLength = alignment.getReadLength();
        boolean bl = cigarSwitcharoo = alignment.getCigar().numCigarElements() > 65535;
        if (cigarSwitcharoo) {
            int[] cigarEncoding = BinaryCigarCodec.encode(alignment.getCigar());
            alignment.setAttribute(SAMTag.CG.name(), (Object)cigarEncoding);
            cigarToWrite = BAMRecordCodec.makeSentinelCigar(alignment.getCigar());
        } else {
            cigarToWrite = alignment.getCigar();
        }
        int blockSize = 32 + alignment.getReadNameLength() + 1 + cigarToWrite.numCigarElements() * 4 + (readLength + 1) / 2 + readLength;
        int attributesSize = alignment.getAttributesBinarySize();
        if (attributesSize != -1) {
            blockSize += attributesSize;
        } else {
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                blockSize += BinaryTagCodec.getTagSize(attribute.value);
            }
        }
        int indexBin = 0;
        if (alignment.getAlignmentStart() != 0 && !this.warnIfReferenceIsTooLargeForBinField(alignment)) {
            indexBin = alignment.computeIndexingBin();
        }
        this.binaryCodec.writeInt(blockSize);
        this.binaryCodec.writeInt(alignment.getReferenceIndex());
        this.binaryCodec.writeInt(alignment.getAlignmentStart() - 1);
        this.binaryCodec.writeUByte((short)(alignment.getReadNameLength() + 1));
        this.binaryCodec.writeUByte((short)alignment.getMappingQuality());
        this.binaryCodec.writeUShort(indexBin);
        this.binaryCodec.writeUShort(cigarToWrite.numCigarElements());
        this.binaryCodec.writeUShort(alignment.getFlags());
        this.binaryCodec.writeInt(alignment.getReadLength());
        this.binaryCodec.writeInt(alignment.getMateReferenceIndex());
        this.binaryCodec.writeInt(alignment.getMateAlignmentStart() - 1);
        this.binaryCodec.writeInt(alignment.getInferredInsertSize());
        byte[] variableLengthBinaryBlock = alignment.getVariableBinaryRepresentation();
        if (variableLengthBinaryBlock != null) {
            this.binaryCodec.writeBytes(variableLengthBinaryBlock);
        } else {
            int[] binaryCigar;
            if (alignment.getReadLength() != alignment.getBaseQualities().length && alignment.getBaseQualities().length != 0) {
                throw new RuntimeException("Mismatch between read length and quals length writing read " + alignment.getReadName() + "; read length: " + alignment.getReadLength() + "; quals length: " + alignment.getBaseQualities().length);
            }
            this.binaryCodec.writeString(alignment.getReadName(), false, true);
            for (int cigarElement : binaryCigar = BinaryCigarCodec.encode(cigarToWrite)) {
                this.binaryCodec.writeInt(cigarElement);
            }
            try {
                this.binaryCodec.writeBytes(SAMUtils.bytesToCompressedBases(alignment.getReadBases()));
            }
            catch (IllegalArgumentException ex) {
                String msg = ex.getMessage() + " in read: " + alignment.getReadName();
                throw new IllegalStateException(msg, ex);
            }
            byte[] qualities = alignment.getBaseQualities();
            if (qualities.length == 0) {
                qualities = new byte[alignment.getReadLength()];
                Arrays.fill(qualities, (byte)-1);
            }
            this.binaryCodec.writeBytes(qualities);
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                this.binaryTagCodec.writeTag(attribute.tag, attribute.value, attribute.isUnsignedArray());
            }
        }
        if (cigarSwitcharoo) {
            alignment.setAttribute(SAMTag.CG.name(), null);
        }
    }

    public static Cigar makeSentinelCigar(Cigar cigar) {
        if (cigar.getReadLength() > 0xFFFFFFF) {
            throw new IllegalArgumentException(String.format("Cannot encode (to BAM) a record with more than %d cigar operations and a read-length greater than %d.", 65535, 0xFFFFFFF));
        }
        if (cigar.getReferenceLength() > 0xFFFFFFF) {
            throw new IllegalArgumentException(String.format("Cannot encode (to BAM) a record that has than %d cigar operations and spans more than %d bases on the reference.", 65535, 0xFFFFFFF));
        }
        return new Cigar(Arrays.asList(new CigarElement(cigar.getReadLength(), CigarOperator.S), new CigarElement(cigar.getReferenceLength(), CigarOperator.N)));
    }

    private boolean warnIfReferenceIsTooLargeForBinField(SAMRecord rec) {
        boolean tooLarge;
        SAMSequenceRecord sequence = rec.getHeader() != null ? rec.getHeader().getSequence(rec.getReferenceName()) : null;
        boolean bl = tooLarge = sequence != null && SAMUtils.isReferenceSequenceIncompatibleWithBAI(sequence);
        if (!this.isReferenceSizeWarningShowed && tooLarge && rec.getValidationStringency() != ValidationStringency.SILENT) {
            LOG.warn("Reference length is too large for BAM bin field.");
            LOG.warn("Reads on references longer than 536870912bp will have bin set to 0.");
            this.isReferenceSizeWarningShowed = true;
        }
        return tooLarge;
    }

    @Override
    public SAMRecord decode() {
        int recordLength;
        try {
            recordLength = this.binaryCodec.readInt();
        }
        catch (RuntimeEOFException e) {
            return null;
        }
        if (recordLength < 32) {
            throw new SAMFormatException("Invalid record length: " + recordLength);
        }
        int referenceID = this.binaryCodec.readInt();
        int coordinate = this.binaryCodec.readInt() + 1;
        short readNameLength = this.binaryCodec.readUByte();
        short mappingQuality = this.binaryCodec.readUByte();
        int bin = this.binaryCodec.readUShort();
        int cigarLen = this.binaryCodec.readUShort();
        int flags = this.binaryCodec.readUShort();
        int readLen = this.binaryCodec.readInt();
        int mateReferenceID = this.binaryCodec.readInt();
        int mateCoordinate = this.binaryCodec.readInt() + 1;
        int insertSize = this.binaryCodec.readInt();
        byte[] restOfRecord = new byte[recordLength - 32];
        this.binaryCodec.readBytes(restOfRecord);
        BAMRecord ret = this.samRecordFactory.createBAMRecord(this.header, referenceID, coordinate, readNameLength, mappingQuality, bin, cigarLen, flags, readLen, mateReferenceID, mateCoordinate, insertSize, restOfRecord);
        if (null != this.header) {
            ret.setHeader(this.header);
        }
        return ret;
    }
}

