/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.util.Arrays;
import vcf.DuplicatesGTRec;
import vcf.Samples;

public interface GTRec
extends DuplicatesGTRec {
    public Samples samples();

    public static double[] alleleFreq(GTRec gTRec) {
        int[] nArray = GTRec.alleleCounts(gTRec);
        int n = Arrays.stream(nArray).sum();
        double[] dArray = new double[nArray.length];
        if (n > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = (double)nArray[i] / (double)n;
            }
        }
        return dArray;
    }

    public static int[] alleleCounts(GTRec gTRec) {
        int n = gTRec.marker().nAlleles();
        int[] nArray = new int[n];
        int n2 = gTRec.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = gTRec.get(i);
            if (n3 < 0) continue;
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
        }
        return nArray;
    }

    public static String toVcfRec(GTRec gTRec) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(gTRec.marker());
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("GT");
        int n = gTRec.samples().size();
        for (int i = 0; i < n; ++i) {
            int n2 = gTRec.allele1(i);
            int n3 = gTRec.allele2(i);
            stringBuilder.append('\t');
            if (n2 == -1) {
                stringBuilder.append('.');
            } else {
                stringBuilder.append(n2);
            }
            stringBuilder.append(gTRec.isPhased(i) ? (char)'|' : '/');
            if (n3 == -1) {
                stringBuilder.append('.');
                continue;
            }
            stringBuilder.append(n3);
        }
        return stringBuilder.toString();
    }
}

