/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.XmlDocument;

public class XmlWriteContext {
    private Writer writer;
    private int indentLevel;
    private boolean prettyOutput;

    public XmlWriteContext(Writer out) {
        this.writer = out;
    }

    public XmlWriteContext(Writer out, int level) {
        this.writer = out;
        this.prettyOutput = true;
        this.indentLevel = level;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isEntityDeclared(String name) {
        return "amp".equals(name) || "lt".equals(name) || "gt".equals(name) || "quot".equals(name) || "apos".equals(name);
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int level) {
        this.indentLevel = level;
    }

    public void printIndent() throws IOException {
        int temp = this.indentLevel;
        if (!this.prettyOutput) {
            return;
        }
        this.writer.write(XmlDocument.eol);
        while (temp-- > 0) {
            this.writer.write(32);
        }
    }

    public boolean isPrettyOutput() {
        return this.prettyOutput;
    }
}

