/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.util.Map;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class MetadataResource
implements Resource {
    private final Map<String, GroundedValue> properties;
    private final String resourceURI;
    private final Resource content;
    private final XPathContext context;

    public MetadataResource(String resourceURI, Resource content, Map<String, GroundedValue> properties, XPathContext context) {
        this.resourceURI = resourceURI;
        this.content = content;
        this.properties = properties;
        this.context = context;
    }

    @Override
    public String getContentType() {
        return this.content.getContentType();
    }

    @Override
    public String getResourceURI() {
        return this.resourceURI;
    }

    @Override
    public Item getItem() {
        DictionaryMap map = new DictionaryMap();
        for (Map.Entry<String, GroundedValue> entry : this.properties.entrySet()) {
            map.initialPut(entry.getKey(), entry.getValue());
        }
        map.initialPut("name", StringValue.makeStringValue(this.resourceURI));
        CallableDelegate fetcher = new CallableDelegate((context1, arguments) -> this.content.getItem());
        SpecificFunctionType fetcherType = new SpecificFunctionType(new SequenceType[0], SequenceType.SINGLE_ITEM);
        CallableFunction fetcherFunction = new CallableFunction(0, (Callable)fetcher, (FunctionItemType)fetcherType);
        map.initialPut("fetch", fetcherFunction);
        return map;
    }
}

