/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepak;

import com.sun.media.codec.video.cinepak.CPChunk;
import com.sun.media.codec.video.cinepak.CodeEntry;
import com.sun.media.codec.video.cinepak.CpStrip;
import javax.media.Buffer;

public class CineStore {
    public static final int MAXSTRIPS = 5;
    public static final int[] BOUNDING24 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    public CpStrip[] StripVec = new CpStrip[5];
    public int NumStrips = 0;
    public int ImageSizeX = 0;
    public int ImageSizeY = 0;
    public int ImagePosX = 0;
    public int ImagePosY = 0;
    public int StripPosX = 0;
    public int StripPosY = 0;
    public int StripPosX1 = 0;
    public int StripPosY1 = 0;
    private boolean finitialCpFlags;
    private int fTopSize;
    private int fXsize;
    private int fYsize;
    private int fNoOfStrips;
    private CineStore fCPStore;
    private byte[] fInData;
    private int fInBufLen;
    private CPChunk fOurChunk = new CPChunk();

    public void addStrip() {
        if (this.NumStrips < 5) {
            CpStrip tempStrip;
            this.StripVec[this.NumStrips] = tempStrip = new CpStrip();
            ++this.NumStrips;
        }
    }

    public int getNumStrips() {
        return this.NumStrips;
    }

    public void DoFrame(Buffer inBuffer, Buffer outBuffer, CineStore myStor) {
        this.fCPStore = myStor;
        this.fInBufLen = inBuffer.getLength();
        int dataLength = ((byte[])inBuffer.getData()).length;
        int dataLengthO = ((int[])outBuffer.getData()).length;
        this.fInData = (byte[])inBuffer.getData();
        this.finitialCpFlags = (this.fInData[0] & 1) != 1;
        this.fTopSize = (this.fInData[1] & 0xFF) * 256 + (this.fInData[2] & 0xFF) * 256 + (this.fInData[3] & 0xFF);
        this.fXsize = (this.fInData[4] & 0xFF) * 256 + (this.fInData[5] & 0xFF);
        this.fYsize = (this.fInData[6] & 0xFF) * 256 + (this.fInData[7] & 0xFF);
        outBuffer.setLength(this.fXsize * this.fYsize);
        myStor.ImageSizeX = this.fXsize;
        myStor.ImageSizeY = this.fYsize;
        this.fNoOfStrips = (this.fInData[8] & 0xFF) * 256 + (this.fInData[9] & 0xFF);
        if (this.fNoOfStrips > 5) {
            System.err.println("Cinepak data corrupted. Too many strips.");
        }
        while (this.fCPStore.getNumStrips() < this.fNoOfStrips) {
            this.fCPStore.addStrip();
        }
        int StripStartInBuffer = 10;
        int StripEndInBuffer = 10;
        int stripCount = 0;
        while (stripCount < this.fNoOfStrips) {
            int x1;
            int cid = (this.fInData[StripStartInBuffer] & 0xFF) * 256 + (this.fInData[StripStartInBuffer + 1] & 0xFF);
            int sizeOfStrip = (this.fInData[StripStartInBuffer + 2] & 0xFF) * 256 + (this.fInData[StripStartInBuffer + 3] & 0xFF);
            StripEndInBuffer = StripStartInBuffer + sizeOfStrip;
            int y0 = (this.fInData[StripStartInBuffer + 4] & 0xFF) * 256 + (this.fInData[StripStartInBuffer + 5] & 0xFF);
            int x0 = (this.fInData[StripStartInBuffer + 6] & 0xFF) * 256 + (this.fInData[StripStartInBuffer + 7] & 0xFF);
            if (stripCount == 0) {
                myStor.StripPosX = x0;
                myStor.StripPosY = y0;
            } else {
                myStor.StripPosX = x0;
                myStor.StripPosY = myStor.StripPosY + myStor.StripPosY1 + y0;
            }
            int y1 = (this.fInData[StripStartInBuffer + 8] & 0xFF) * 256 + (this.fInData[StripStartInBuffer + 9] & 0xFF);
            myStor.StripPosX1 = x1 = (this.fInData[StripStartInBuffer + 10] & 0xFF) * 256 + (this.fInData[StripStartInBuffer + 11] & 0xFF);
            myStor.StripPosY1 = y1;
            if (this.finitialCpFlags && cid > 0 && stripCount > 0) {
                int i2 = 0;
                while (i2 < 256) {
                    myStor.StripVec[stripCount].Smooth[i2] = new CodeEntry(myStor.StripVec[stripCount - 1].Smooth[i2]);
                    myStor.StripVec[stripCount].Detail[i2] = new CodeEntry(myStor.StripVec[stripCount - 1].Detail[i2]);
                    ++i2;
                }
            }
            int ChunkStartInBuffer = StripStartInBuffer + 12;
            while (ChunkStartInBuffer < StripEndInBuffer) {
                this.fOurChunk.processChunk(this.fInData, this.fCPStore, stripCount, ChunkStartInBuffer, outBuffer);
                ChunkStartInBuffer = ChunkStartInBuffer + (this.fInData[ChunkStartInBuffer + 2] & 0xFF) * 256 + (this.fInData[ChunkStartInBuffer + 3] & 0xFF);
            }
            StripStartInBuffer = StripEndInBuffer;
            ++stripCount;
        }
    }
}

