# Copyright (C) 2002-2003 Hewlett Packard
# Copyright (C) 2005 Jay Beale
# Copyright (C) 2005 Charlie Long, Delphi Research
# Licensed under the GNU General Public License


require Bastille::API;
import Bastille::API;


$GLOBAL_TEST{'SecureInetd'}{'deactivate_telnet'} = 
  sub { &B_is_service_off('telnet'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_ftp'} = 
  sub { 
  if (&GetDistro =~ /^HP/) {
	return &B_is_service_off('ftp'); 
  }
  else {
	my $rtn1 = &B_is_service_off('ftp');
	my $rtn2 = &B_is_service_off('vsftpd');
	if ( ($rtn1 == $SKIPQ) and ($rtn2 == $SKIPQ) ) {
		return $SKIPQ;
	}
	else {
		return $ASKQ;
	}
  }
};

$GLOBAL_TEST{'SecureInetd'}{'deactivate_rtools'} = 
  sub { &B_is_service_off('rtools'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_tftp'} = 
  sub { &B_is_service_off('tftp'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_bootp'} = 
  sub { &B_is_service_off('bootps'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_finger'} = 
  sub { &B_is_service_off('finger'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_uucp'} = 
  sub { &B_is_service_off('uucp'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_ntalk'} = 
  sub { &B_is_service_off('ntalk'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_ident'} = 
  sub { &B_is_service_off('ident'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_time'} = 
  sub { &B_is_service_off('time'); };

# if all of the built in services (daytime, echo, discard, and chargen) are disabled then
# don't ask the question
$GLOBAL_TEST{'SecureInetd'}{'deactivate_builtin'} = 
    sub { &B_is_service_off('builtin'); };

# if both kshell and klogin are already disabled then don't ask the question
$GLOBAL_TEST{'SecureInetd'}{'deactivate_ktools'} = 
    sub { &B_is_service_off('ktools'); };

# if the CDE related services are disabled then don't ask the question
$GLOBAL_TEST{'SecureInetd'}{'deactivate_dttools'} = 
    sub { &B_is_service_off('dttools'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_recserv'} = 
    sub { &B_is_service_off('recserv'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_swat'} = 
    sub { &B_is_service_off('swat'); };

$GLOBAL_TEST{'SecureInetd'}{'deactivate_printer'} = 
    sub { &B_is_service_off('printer'); };

$GLOBAL_TEST{'SecureInetd'}{'log_inetd'} =
sub {
	# getting the list of current inetd arguments 
	my $current_args = &B_get_rc("INETD_ARGS");
	# if the current arguments of inetd include a '-l' for logging then
	if($current_args =~ /\-l/) {
	    # don't ask the question
	    return $SKIPQ;
	}
	else {
	    # Otherwise, logging is not on, ask the question
	    return $ASKQ;
	}
    };

$GLOBAL_TEST{'SecureInetd'}{'inetd_general'} =
    sub {

	if(&B_match_line(&getGlobal('BFILE',"TODO"),'Inetd Audit:')) {
	    # if the other security tools information is already in the TODO list then
	    # don't ask the question.
	    return $SKIPQ;
	}
	else {
	    # otherwise ask the question.
	    return $ASKQ;
	}
	    

    };

$GLOBAL_TEST{'SecureInetd'}{'tcpd_default_deny'} = 
   sub {
	my $hostsallow = &getGlobal('file','hosts.allow');
        my $hostsdeny = &getGlobal('file','hosts.deny');

	#
	# Check for the original hosts.deny method of setting up
	# default deny first.
	#
	if(-e $hostsdeny) {

	    #read file in backwards
	    
	    open FILE, "<$hostsdeny";
	    my @lines = <FILE>;
	    close FILE;

	    my @rev = reverse @lines;

	    # Look through lines in reverse order. seeking a ALL:ALL
	    foreach $line (@rev) {
		if ($line =~ /^\s*ALL\s*:\s*ALL\s*$/) {
		    return $SKIPQ;
		}		
	    }
	}
	#
	# Check for the newer hosts.allow method of setting up
	# default deny now, where hosts.allow is the only file
	# that contains both ALLOW and DENY lines.
	#
	
	if(-e $hostsallow) {

	    #read file in forwards
	    
	    open FILE, "<$hostsallow";
	    my @lines = <FILE>;
	    close FILE;

	    # Look through lines in forward order. seeking an ALL:ALL:DENY, while
	    # allowing for an ALL: ALL :  <some options> : DENY.
	    # 
	    # If we find an ALL : ALL : ALLOW before that, its an immediate
	    # ASKQ, since the default-deny is superceded by this line.

	    foreach $line (@lines) {
		if ($line =~/^\s*ALL\s*:\s*ALL\s*:([^:]*:|)\s*DENY\s*$/ ) {
		    return $SKIPQ;
		}
		if ($line =~/^\s*ALL\s*:\s*ALL\s*:([^:]*:|)\s*ALLOW\s*$/ ) {
		    return $ASKQ;
		}
	    }
	}
	
	return $ASKQ;
    };


$GLOBAL_TEST{'SecureInetd'}{'banners'} =
    sub {
        $retval = $ASKQ;
	
        if( -e &getGlobal('FILE','issue') ) {
	    if(&B_match_line(&getGlobal('FILE',"issue"),'authorized|AUTHORIZED')) {
                $retval = $SKIPQ;
	    }
        }
	return $retval;
    };

1;
