/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.internal.AbstractDispatchObject;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.NioAttachment;
import org.fusesource.hawtdispatch.internal.WorkerThread;

public final class NioDispatchSource
extends AbstractDispatchObject
implements DispatchSource {
    public static final boolean DEBUG = false;
    final SelectableChannel channel;
    volatile DispatchQueue selectorQueue;
    final AtomicBoolean canceled = new AtomicBoolean();
    final int interestOps;
    Task cancelHandler;
    Task eventHandler;
    final ThreadLocal<KeyState> keyState = new ThreadLocal();
    private Task updateInterestTask = new Task(){

        public void run() {
            if (!NioDispatchSource.this.isSuspended() && !NioDispatchSource.this.isCanceled()) {
                KeyState state = NioDispatchSource.this.keyState.get();
                if (state == null) {
                    return;
                }
                if (state.key.isValid()) {
                    state.key.interestOps(state.key.interestOps() | NioDispatchSource.this.interestOps);
                }
            }
        }
    };

    private static String opsToString(int ops) {
        ArrayList<String> sb = new ArrayList<String>();
        if ((ops & 0x10) != 0) {
            sb.add("ACCEPT");
        }
        if ((ops & 8) != 0) {
            sb.add("CONNECT");
        }
        if ((ops & 1) != 0) {
            sb.add("READ");
        }
        if ((ops & 4) != 0) {
            sb.add("WRITE");
        }
        return sb.toString();
    }

    public NioDispatchSource(HawtDispatcher dispatcher, SelectableChannel channel, int interestOps, DispatchQueue targetQueue) {
        if (interestOps == 0) {
            throw new IllegalArgumentException("invalid interest ops");
        }
        this.channel = channel;
        this.selectorQueue = NioDispatchSource.pickThreadQueue(dispatcher, targetQueue);
        this.interestOps = interestOps;
        this.suspended.incrementAndGet();
        this.setTargetQueue(targetQueue);
    }

    private static DispatchQueue pickThreadQueue(HawtDispatcher dispatcher, DispatchQueue targetQueue) {
        DispatchQueue selectorQueue = targetQueue;
        while (selectorQueue.getQueueType() != DispatchQueue.QueueType.THREAD_QUEUE && selectorQueue.getTargetQueue() != null) {
            selectorQueue = selectorQueue.getTargetQueue();
        }
        if (selectorQueue.getQueueType() != DispatchQueue.QueueType.THREAD_QUEUE) {
            WorkerThread[] threads = dispatcher.DEFAULT_QUEUE.workers.getThreads();
            WorkerThread min = threads[0];
            int minSize = min.getNioManager().getSelector().keys().size();
            for (int i = 1; i < threads.length; ++i) {
                int s = threads[i].getNioManager().getSelector().keys().size();
                if (s >= minSize) continue;
                minSize = s;
                min = threads[i];
            }
            selectorQueue = min.getDispatchQueue();
        }
        return selectorQueue;
    }

    protected void onStartup() {
        if (this.eventHandler == null) {
            throw new IllegalArgumentException("eventHandler must be set");
        }
        this.register_on(this.selectorQueue);
    }

    public void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.selectorQueue.execute(new Task(){

                public void run() {
                    NioDispatchSource.this.internal_cancel();
                }
            });
        }
    }

    void internal_cancel() {
        this.key_cancel();
        if (this.cancelHandler != null) {
            this.targetQueue.execute(this.cancelHandler);
        }
    }

    private void key_cancel() {
        KeyState state = this.keyState.get();
        if (state == null) {
            return;
        }
        this.debug("canceling source", new Object[0]);
        state.attachment.sources.remove(this);
        if (state.attachment.sources.isEmpty()) {
            this.debug("canceling key.", new Object[0]);
            state.key.cancel();
            Selector selector = WorkerThread.currentWorkerThread().getNioManager().getSelector();
            try {
                selector.selectNow();
            }
            catch (CancelledKeyException ignore) {
            }
            catch (IOException e) {
                this.debug(e, "Error canceling", new Object[0]);
            }
        }
        this.debug("Canceled selector on " + WorkerThread.currentWorkerThread().getDispatchQueue().getLabel(), new Object[0]);
        this.keyState.remove();
    }

    private void register_on(DispatchQueue queue) {
        queue.execute(new Task(){

            public void run() {
                assert (NioDispatchSource.this.keyState.get() == null);
                Selector selector = WorkerThread.currentWorkerThread().getNioManager().getSelector();
                try {
                    KeyState state = new KeyState();
                    state.key = NioDispatchSource.this.channel.keyFor(selector);
                    if (state.key == null) {
                        state.key = NioDispatchSource.this.channel.register(selector, NioDispatchSource.this.interestOps);
                        state.attachment = new NioAttachment();
                        state.key.attach(state.attachment);
                    } else {
                        state.attachment = (NioAttachment)state.key.attachment();
                    }
                    state.attachment.sources.add(NioDispatchSource.this);
                    NioDispatchSource.this.keyState.set(state);
                    try {
                        state.key.interestOps(state.key.interestOps() | NioDispatchSource.this.interestOps);
                    }
                    catch (CancelledKeyException e) {
                        state.attachment.cancel(state.key);
                    }
                }
                catch (ClosedChannelException e) {
                    NioDispatchSource.this.debug(e, "could not register with selector", new Object[0]);
                }
                NioDispatchSource.this.debug("Registered", new Object[0]);
            }
        });
    }

    public void fire(final int readyOps) {
        KeyState state = this.keyState.get();
        if (state == null) {
            return;
        }
        state.readyOps |= readyOps;
        if (state.readyOps != 0 && !this.isSuspended() && !this.isCanceled()) {
            state.readyOps = 0;
            this.targetQueue.execute(new Task(){

                public void run() {
                    if (!NioDispatchSource.this.isSuspended() && !NioDispatchSource.this.isCanceled()) {
                        try {
                            NioDispatchSource.this.eventHandler.run();
                        }
                        catch (Throwable e) {
                            Thread thread = Thread.currentThread();
                            thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                        }
                        NioDispatchSource.this.updateInterest();
                    }
                }
            });
        }
    }

    private void updateInterest() {
        if (this.isCurrent(this.selectorQueue)) {
            this.updateInterestTask.run();
        } else {
            this.selectorQueue.execute(this.updateInterestTask);
        }
    }

    private boolean isCurrent(DispatchQueue q) {
        WorkerThread thread = WorkerThread.currentWorkerThread();
        if (thread == null) {
            return false;
        }
        return thread.getDispatchQueue() == q;
    }

    protected void onSuspend() {
        this.debug("onSuspend", new Object[0]);
        super.onSuspend();
    }

    protected void onResume() {
        this.debug("onResume", new Object[0]);
        if (this.isCurrent(this.selectorQueue)) {
            KeyState state = this.keyState.get();
            if (state == null || state.readyOps == 0) {
                this.updateInterest();
            } else {
                this.fire(state.readyOps);
            }
        } else {
            this.selectorQueue.execute(new Task(){

                public void run() {
                    KeyState state = NioDispatchSource.this.keyState.get();
                    if (state == null || state.readyOps == 0) {
                        NioDispatchSource.this.updateInterest();
                    } else {
                        NioDispatchSource.this.fire(NioDispatchSource.this.interestOps);
                    }
                }
            });
        }
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    @Deprecated
    public void setCancelHandler(Runnable handler) {
        this.setCancelHandler(new TaskWrapper(handler));
    }

    @Deprecated
    public void setEventHandler(Runnable handler) {
        this.setEventHandler(new TaskWrapper(handler));
    }

    public void setCancelHandler(Task cancelHandler) {
        this.cancelHandler = cancelHandler;
    }

    public void setEventHandler(Task eventHandler) {
        this.eventHandler = eventHandler;
    }

    public Void getData() {
        return null;
    }

    public void setTargetQueue(DispatchQueue next) {
        super.setTargetQueue(next);
        DispatchQueue queue = next;
        while (queue.getQueueType() != DispatchQueue.QueueType.THREAD_QUEUE && queue.getTargetQueue() != null) {
            queue = queue.getTargetQueue();
        }
        if (queue.getQueueType() == DispatchQueue.QueueType.THREAD_QUEUE && queue != this.selectorQueue) {
            DispatchQueue previous = this.selectorQueue;
            this.debug("Switching to " + queue.getLabel(), new Object[0]);
            this.register_on(queue);
            this.selectorQueue = queue;
            if (previous != null) {
                previous.execute(new Task(){

                    public void run() {
                        NioDispatchSource.this.key_cancel();
                    }
                });
            }
        }
    }

    protected void debug(String str, Object ... args) {
    }

    protected void debug(Throwable thrown, String str, Object ... args) {
    }

    public static class KeyState {
        int readyOps;
        SelectionKey key;
        NioAttachment attachment;

        public String toString() {
            return "{ready: " + NioDispatchSource.opsToString(this.readyOps) + " }";
        }
    }
}

