/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fusesource.scalate.util.FileResource;
import org.fusesource.scalate.util.Log;
import org.fusesource.scalate.util.Log$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil$
implements ScalaObject {
    public static final IOUtil$ MODULE$;
    private final Log log;

    static {
        new IOUtil$();
    }

    public Log log() {
        return this.log;
    }

    public FileResource toResource(File file) {
        return new FileResource(file, file.getPath());
    }

    public File toFile(FileResource resource2) {
        return resource2.asFile();
    }

    public void makeParentDirs(String fileName) {
        this.makeParentDirs(new File(fileName));
    }

    public void makeParentDirs(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public boolean recursiveDelete(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            Predef$.MODULE$.refArrayOps((Object[])children).foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File child) {
                    return IOUtil$.MODULE$.recursiveDelete(child);
                }
            });
        }
        return file.delete();
    }

    public String loadText(InputStream in, String encoding) {
        return new String(this.loadBytes(in), encoding);
    }

    public String loadText$default$2() {
        return "UTF-8";
    }

    public String loadTextFile(File path, String encoding) {
        return new String(this.loadBinaryFile(path), encoding);
    }

    public String loadTextFile$default$2() {
        return "UTF-8";
    }

    public byte[] loadBinaryFile(File path) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(path);
        try {
            this.copy((InputStream)in, (OutputStream)baos);
            return baos.toByteArray();
        }
        finally {
            in.close();
        }
    }

    public byte[] loadBytes(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.copy(in, (OutputStream)baos);
            return baos.toByteArray();
        }
        finally {
            in.close();
        }
    }

    public void writeText(String path, String text2) {
        this.writeText(new File(path), text2);
    }

    public void writeText(File path, String text2) {
        this.writeText(new FileWriter(path), text2);
    }

    public void writeText(OutputStream stream, String text2) {
        this.writeText(new OutputStreamWriter(stream), text2);
    }

    public void writeText(Writer out, String text2) {
        try {
            out.write(text2);
            return;
        }
        finally {
            out.close();
        }
    }

    public void writeBinaryFile(String path, byte[] contents) {
        this.writeBinaryFile(new File(path), contents);
    }

    public void writeBinaryFile(File path, byte[] contents) {
        FileOutputStream out = new FileOutputStream(path);
        try {
            out.write(contents);
            return;
        }
        finally {
            out.close();
        }
    }

    public long copy(File in, File out) {
        out.getParentFile().mkdirs();
        return this.copy((InputStream)new FileInputStream(in), (OutputStream)new FileOutputStream(out));
    }

    public long copy(File file, OutputStream out) {
        return this.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), out);
    }

    public long copy(InputStream in, File file) {
        FileOutputStream out = new FileOutputStream(file);
        try {
            long exceptionResult3 = this.copy(in, (OutputStream)out);
            return exceptionResult3;
        }
        finally {
            out.close();
        }
    }

    public long copy(URL url, File file) {
        InputStream in = url.openStream();
        try {
            long exceptionResult4 = this.copy(in, file);
            return exceptionResult4;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <R, C extends Closeable> R using(C c, Function1<C, R> func) {
        void var3_3;
        try {
            Object exceptionResult5 = func.apply(c);
        }
        catch (Throwable throwable) {
            try {
                c.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {}
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public long copy(InputStream in, OutputStream out) {
        void var3_3;
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public long copy(Reader in, Writer out) {
        void var3_3;
        long charsCopied = 0L;
        char[] buffer = new char[8192];
        int chars = in.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * Loose catch block
     */
    public void unjar(File outputDir, InputStream input, Function1<ZipEntry, Object> filter) {
        ZipInputStream zip = new ZipInputStream(input);
        try {
            FileOutputStream bos;
            byte[] buffer = new byte[65536];
            boolean ok = true;
            while (ok) {
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) {
                    ok = false;
                    continue;
                }
                String name = entry.getName();
                if (!entry.isDirectory() && BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)entry))) {
                    this.log().debug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "processing resource: %s";
                        }
                    }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                    File file = new File(new StringBuilder().append((Object)outputDir.getCanonicalPath()).append((Object)"/").append((Object)name).toString());
                    file.getParentFile().mkdirs();
                    bos = new FileOutputStream(file);
                    int bytes = 1;
                    while (bytes > 0) {
                        bytes = zip.read(buffer);
                        if (bytes <= 0) continue;
                        bos.write(buffer, 0, bytes);
                    }
                    bos.close();
                }
                zip.closeEntry();
            }
            return;
            catch (Throwable throwable) {
                bos.close();
                throw throwable;
            }
        }
        finally {
            zip.close();
        }
    }

    public Function1 unjar$default$3() {
        return new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(ZipEntry zipEntry) {
                return IOUtil$.MODULE$.allZipEntries(zipEntry);
            }
        };
    }

    public void recursiveDelete(File file, Function1<File, Object> filter) {
        if (file.exists()) {
            if (file.isDirectory()) {
                Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(File c) {
                        return IOUtil$.MODULE$.recursiveDelete(c);
                    }
                });
            }
            if (BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)file))) {
                file.delete();
            }
        }
    }

    public Function1 recursiveDelete$default$2() {
        return new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return IOUtil$.MODULE$.allFiles(file);
            }
        };
    }

    public boolean allZipEntries(ZipEntry entry) {
        return true;
    }

    public boolean allFiles(File file) {
        return true;
    }

    private IOUtil$() {
        MODULE$ = this;
        this.log = Log$.MODULE$.apply(this.getClass());
    }
}

