# See if we can get a crash dump using "reboot -d"

# known issue: sparc savecore prints nothing

import os
import anita
from bracket import *

name = 'reboot_d'

def test_func(ts):
    dist = anita.distribution(anita_dist_url(ts))
    # vmm_args = ['--no-kvm']
    a = anita.Anita(dist, vmm_args = [], workdir = anita_workdir(ts), memory_size = '128M')
    child = a.boot()
    a.login()
    child.send('reboot -d\r')
    child.expect(r'savecore: (.*)\r', timeout = 600)
    savecore_message = child.match.group(1)
    print("savecore message: <%s>" % savecore_message)
    if savecore_message == "no core dump":
        return False
    return True

def op():
    return TestOp(test_func, [install_op], name = name)
