/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.UIManager;

public class IgowebIcon
implements Icon {
    private final int iconId;
    public static final int CLOSE = 0;
    public static final int POP = 1;

    public IgowebIcon(int iconId) {
        this.iconId = iconId;
    }

    @Override
    public int getIconHeight() {
        return UIManager.getInt("org.igoweb.fontH");
    }

    @Override
    public int getIconWidth() {
        return UIManager.getInt("org.igoweb.fontH");
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(c.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("org.igoweb.stdBg").darker());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float size = (float)UIManager.getInt("org.igoweb.fontH") * 0.8f;
        float baseX = (float)x + size * 0.125f;
        float baseY = (float)y + size * 0.125f;
        GeneralPath path = new GeneralPath(1, 8);
        if (this.iconId == 0) {
            float lineW = size * 0.2f;
            g2d.setStroke(new BasicStroke(lineW));
            path.moveTo(baseX + (lineW *= (float)Math.sqrt(2.0) * 0.5f), baseY + lineW);
            path.lineTo(baseX + size - lineW, baseY + size - lineW);
            path.moveTo(baseX + lineW, baseY + size - lineW);
            path.lineTo(baseX + size - lineW, baseY + lineW);
        } else if (this.iconId == 1) {
            float lineW = size * 0.05f;
            g2d.setStroke(new BasicStroke(lineW * 2.0f));
            path.moveTo(baseX + lineW, baseY + lineW);
            path.lineTo(baseX + size * 0.75f, baseY + lineW);
            path.lineTo(baseX + size * 0.75f, baseY + size * 0.75f);
            path.lineTo(baseX + lineW, baseY + size * 0.75f);
            path.lineTo(baseX + lineW, baseY + lineW);
            path.moveTo(baseX + size * 0.25f, baseY + size * 0.75f);
            path.lineTo(baseX + size * 0.25f, baseY + size - lineW);
            path.lineTo(baseX + size - lineW, baseY + size - lineW);
            path.lineTo(baseX + size - lineW, baseY + size * 0.25f);
            path.lineTo(baseX + size * 0.75f, baseY + size * 0.25f);
        }
        g2d.draw(path);
        g2d.dispose();
    }
}

