/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public final class PreGameController
extends Controller {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());

    public PreGameController(FreeColServer freeColServer) {
        super(freeColServer);
    }

    public void startGame() throws FreeColException {
        FreeColServer freeColServer = this.getFreeColServer();
        Game game = freeColServer.buildGame();
        for (Player player : game.getLivePlayers(null)) {
            if (player.isAI()) continue;
            player.invalidateCanSeeTiles();
            Connection conn = ((ServerPlayer)player).getConnection();
            Element update = DOMMessage.createMessage("updateGame", new String[0]);
            update.appendChild(game.toXMLElement(update.getOwnerDocument(), player));
            try {
                conn.ask(update);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to updateGame", e);
            }
        }
        freeColServer.setGameState(FreeColServer.GameState.IN_GAME);
        freeColServer.updateMetaServer();
        freeColServer.getServer().sendToAll(DOMMessage.createMessage("startGame", new String[0]));
        freeColServer.getServer().setMessageHandlerToAllConnections(freeColServer.getInGameInputHandler());
    }
}

