/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteScreenSaver;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.HTMLEscaper;
import com.gallery.GalleryRemote.util.ImageLoaderUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import org.jdesktop.jdic.screensaver.SimpleScreensaver;

public class GRScreenSaver
extends SimpleScreensaver
implements PreferenceNames {
    public static final String MODULE = "ScreenSaver";
    String coreClass = "com.gallery.GalleryRemote.GalleryRemoteScreenSaver";
    boolean hasStarted = false;
    GalleryRemoteScreenSaver grss;
    int paintPass = 0;
    int thickness = 1;

    public void init() {
        if (!this.hasStarted) {
            GalleryRemote.createInstance(this.coreClass, null);
            this.hasStarted = true;
            this.grss = (GalleryRemoteScreenSaver)GalleryRemote._().getCore();
            this.grss.setContext(this.getContext());
            GalleryRemote._().initializeGR();
            this.thickness = GalleryRemote._().properties.getIntProperty("slideshowFontThickness", 1);
        }
    }

    public void paint(Graphics g) {
        if (this.paintPass < 10) {
            ++this.paintPass;
            Component c = this.getContext().getComponent();
            ImageLoaderUtil.setSlideshowFont(c);
            g.setFont(c.getFont());
            String message = this.grss.hasSettings ? "Preparing slideshow..." : "Please pick the Settings for your Gallery";
            int width = (int)c.getBounds().getWidth();
            int height = (int)c.getBounds().getHeight();
            ImageLoaderUtil.paintAlignedOutline(g, message, width / 2, height / 2, this.thickness, 20, width);
            return;
        }
        if (this.grss.newImage) {
            this.grss.newImage = false;
            Log.log(3, MODULE, "Really Paint!");
            Component c = this.getContext().getComponent();
            Image img = this.grss.loader.imageShowNow;
            int width = (int)c.getBounds().getWidth();
            int height = (int)c.getBounds().getHeight();
            int dx = (width - img.getWidth(c)) / 2;
            int dy = (height - img.getHeight(c)) / 2;
            g.drawImage(img, dx, dy, c);
            g.setColor(GalleryRemote._().properties.getColorProperty("slideshowColor"));
            g.fillRect(0, 0, dx, height);
            g.fillRect(width - dx, 0, width, height);
            g.fillRect(dx, 0, width - dx, dy);
            g.fillRect(dx, height - dy, width - dx, height);
            String caption = ImageLoaderUtil.stripTags(HTMLEscaper.unescape(this.grss.loader.pictureShowNow.getCaption()));
            if (caption != null && caption.length() != 0) {
                ImageLoaderUtil.paintAlignedOutline(g, caption, width / 2, height - 10, this.thickness, 30, width);
            }
        }
    }

    public void destroy() {
        GalleryRemote._().getCore().shutdown();
        Log.log(2, MODULE, "Shutting down log");
        Log.shutdown();
        super.destroy();
    }
}

