/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.prefs.GalleryEditorDialog;
import com.gallery.GalleryRemote.prefs.PreferencePanel;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelListener;

public class URLPanel
extends PreferencePanel
implements ListSelectionListener,
ActionListener {
    public static final String MODULE = "URLPa";
    JLabel icon = new JLabel(GRI18n.getString("URLPa", "icon"));
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jGalleries = new JList();
    JButton jModify = new JButton();
    JButton jNew = new JButton();
    JButton jDelete = new JButton();
    JPanel jPanel1 = new JPanel();
    JLabel jDetails = new JLabel();
    GridLayout gridLayout1 = new GridLayout();

    public JLabel getIcon() {
        return this.icon;
    }

    public boolean isReversible() {
        return false;
    }

    public void readProperties(PropertiesFile props) {
    }

    public void writeProperties(PropertiesFile props) {
    }

    public void buildUI() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.jModify.setActionCommand("Modify");
        this.jModify.setText(GRI18n.getString(MODULE, "modify"));
        this.jNew.setActionCommand("New");
        this.jNew.setText(GRI18n.getString(MODULE, "new"));
        this.jDelete.setActionCommand("Delete");
        this.jDelete.setText(GRI18n.getString(MODULE, "delete"));
        this.jPanel1.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "details")));
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.jDetails.setMinimumSize(new Dimension(0, 50));
        this.jDetails.setPreferredSize(new Dimension(0, 50));
        this.jDetails.setHorizontalAlignment(2);
        this.jDetails.setVerticalAlignment(1);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jModify, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jNew, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jDelete, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jDetails, null);
        this.jScrollPane1.getViewport().add((Component)this.jGalleries, null);
        this.jGalleries.setModel(GalleryRemote._().getCore().getGalleries());
        this.jGalleries.setCellRenderer(new GalleryCellRenderer());
        this.jGalleries.addListSelectionListener(this);
        this.jGalleries.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = URLPanel.this.jGalleries.locationToIndex(e.getPoint());
                    URLPanel.this.modifyGallery((Gallery)URLPanel.this.jGalleries.getModel().getElementAt(index));
                }
            }
        });
        if (GalleryRemote._().getCore().getGalleries().getSize() > 0) {
            this.jGalleries.setSelectedIndex(0);
        } else {
            this.resetUIState();
        }
        this.jModify.addActionListener(this);
        this.jNew.addActionListener(this);
        this.jDelete.addActionListener(this);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.resetUIState();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Gallery g = (Gallery)this.jGalleries.getSelectedValue();
        Log.log(2, MODULE, "Command selected " + cmd + " Gallery: " + g);
        if (cmd.equals("Modify")) {
            this.modifyGallery(g);
        } else if (cmd.equals("New")) {
            GalleryEditorDialog ged;
            Gallery newG = new Gallery(GalleryRemote._().getCore().getMainStatusUpdate());
            if (GalleryRemote._().getCore() instanceof TreeModelListener) {
                newG.addTreeModelListener((TreeModelListener)((Object)GalleryRemote._().getCore()));
            }
            if ((ged = new GalleryEditorDialog(this.dialog, newG)).isOK()) {
                GalleryRemote._().getCore().getGalleries().addElement(newG);
                this.jGalleries.setSelectedValue(newG, true);
                Gallery.uncacheAmbiguousUrl();
                this.resetUIState();
            }
        } else if (cmd.equals("Delete")) {
            Object[] params = new Object[]{g.getGalleryUrl("")};
            int n = JOptionPane.showConfirmDialog(this, GRI18n.getString(MODULE, "delConfirm", params), GRI18n.getString(MODULE, "delete"), 2, 0);
            if (n == 0) {
                ((MainFrame)GalleryRemote._().getCore()).removeGallery(g);
                Gallery.uncacheAmbiguousUrl();
            }
        } else if (cmd.equals("GalleryEditorDialog")) {
            Gallery newG = (Gallery)e.getSource();
            if (GalleryRemote._().getCore().getGalleries().getIndexOf(newG) == -1) {
                GalleryRemote._().getCore().getGalleries().addElement(newG);
                this.jGalleries.setSelectedValue(newG, true);
            }
            Gallery.uncacheAmbiguousUrl();
            this.resetUIState();
        } else {
            Log.log(1, MODULE, "Unknown command: " + cmd);
        }
    }

    private void modifyGallery(Gallery g) {
        GalleryEditorDialog ged = new GalleryEditorDialog(this.dialog, g);
        if (ged.isOK()) {
            int i = GalleryRemote._().getCore().getGalleries().getIndexOf(g);
            GalleryRemote._().getCore().getGalleries().removeElementAt(i);
            GalleryRemote._().getCore().getGalleries().insertElementAt(g, i);
            Gallery.uncacheAmbiguousUrl();
        }
    }

    public void resetUIState() {
        Gallery selectedGallery = (Gallery)this.jGalleries.getSelectedValue();
        StringBuffer sb = new StringBuffer();
        if (selectedGallery != null) {
            sb.append("<HTML>");
            if (selectedGallery.getType() == 0) {
                sb.append(GRI18n.getString(MODULE, "gllryURL")).append(selectedGallery.getStUrlString()).append("<br>");
            } else if (selectedGallery.getType() == 1) {
                sb.append(GRI18n.getString(MODULE, "pnLoginURL")).append(selectedGallery.getPnLoginUrlString()).append("<br>");
                sb.append(GRI18n.getString(MODULE, "pnGllryURL")).append(selectedGallery.getPnGalleryUrlString()).append("<br>");
            } else if (selectedGallery.getType() == 2) {
                sb.append(GRI18n.getString(MODULE, "phpnLoginURL")).append(selectedGallery.getPhpnLoginUrlString()).append("<br>");
                sb.append(GRI18n.getString(MODULE, "phpnGllryURL")).append(selectedGallery.getPhpnGalleryUrlString()).append("<br>");
            } else if (selectedGallery.getType() == 3) {
                sb.append(GRI18n.getString(MODULE, "glLoginURL")).append(selectedGallery.getGlLoginUrlString()).append("<br>");
                sb.append(GRI18n.getString(MODULE, "glGllryURL")).append(selectedGallery.getGlGalleryUrlString()).append("<br>");
            }
            String username = selectedGallery.getUsername();
            if (username == null || username.length() == 0) {
                username = "&lt;Not set&gt;";
            }
            sb.append(GRI18n.getString(MODULE, "username")).append(username).append("<br>");
            if (selectedGallery.isAutoLoadOnStartup()) {
                sb.append(GRI18n.getString(MODULE, "autoLogin")).append("<br>");
            }
            sb.append("</HTML>");
            this.jModify.setEnabled(true);
            this.jDelete.setEnabled(true);
        } else {
            this.jModify.setEnabled(false);
            this.jDelete.setEnabled(false);
        }
        this.jDetails.setText(sb.toString());
    }

    public class GalleryCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            Gallery g = (Gallery)value;
            this.setText(g.toString());
            if (g.isAutoLoadOnStartup()) {
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            return this;
        }
    }
}

