/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import java.lang.reflect.Method;

public class OsShutdown {
    public static final String MODULE = "Shutdown";
    public static final String osname = System.getProperty("os.name").toLowerCase();

    public static void shutdown() {
        Method m = OsShutdown.getPrivateShutdownMethod();
        if (m != null) {
            try {
                m.invoke(null, null);
            }
            catch (Throwable e) {
                Log.logException(1, MODULE, e);
            }
        }
    }

    private static Method getPrivateShutdownMethod() {
        try {
            Class c = GalleryRemote.secureClassForName("com.gallery.GalleryRemote.util.PrivateShutdown");
            return c.getMethod("shutdown", null);
        }
        catch (Throwable e) {
            Log.log(3, MODULE, "Could not load PrivateShutdown, this is expected for the applet");
            return null;
        }
    }

    public static boolean isWindows() {
        return osname.indexOf("windows") != -1;
    }

    public static boolean isWin9x() {
        return OsShutdown.isWindows() && (osname.indexOf("9") != -1 || osname.indexOf("me") != -1);
    }

    public static boolean isWinNT() {
        return OsShutdown.isWindows() && !OsShutdown.isWin9x();
    }

    public static boolean isMacOS() {
        return osname.indexOf("mac") != -1 && osname.indexOf("os") != -1;
    }

    public static boolean isMacOSX() {
        return osname.indexOf("mac os x") != -1;
    }

    public static boolean isLinux() {
        return osname.indexOf("linux") != -1;
    }

    public static boolean isSolaris() {
        return osname.indexOf("solaris") != -1;
    }

    public static boolean isUnix() {
        return OsShutdown.isMacOSX() || OsShutdown.isLinux() || OsShutdown.isSolaris();
    }

    public static boolean canShutdown() {
        return (OsShutdown.isWin9x() || OsShutdown.isWinNT() || OsShutdown.isUnix() && !OsShutdown.isMacOSX()) && OsShutdown.getPrivateShutdownMethod() != null;
    }
}

