/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import net.sf.gogui.go.BoardConstants;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gui.GuiBoardDrawer;
import net.sf.gogui.gui.GuiField;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.utils.SquareLayout;

public final class GuiBoard
extends JPanel
implements Printable {
    private static final boolean DEBUG_REPAINT = false;
    private boolean m_showCursor = true;
    private boolean m_showGrid = true;
    private int m_imageHeight;
    private int m_imageWidth;
    private int m_size;
    private static final long serialVersionUID = 0L;
    private BoardConstants m_constants;
    private BoardPanel m_panel;
    private Dimension m_minimumFieldSize;
    private Dimension m_preferredFieldSize;
    private GoPoint m_cursor;
    private GoPoint m_lastMove;
    private GuiBoardDrawer m_drawer;
    private GuiField[][] m_field;
    private Image m_image;
    private Listener m_listener;
    private Rectangle m_dirty = new Rectangle();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GuiBoard(int n, boolean bl) {
        this.m_drawer = new GuiBoardDrawer(bl);
        this.setPreferredFieldSize();
        this.initSize(n);
    }

    public void clearAll() {
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setFieldBackground(GoPoint.get(i, j), null);
            }
        }
        this.clearAllCrossHair();
        this.clearAllMarkup();
        this.clearAllSelect();
        this.clearAllInfluence();
        this.clearAllLabels();
        this.clearAllTerritory();
        this.clearLastMove();
    }

    public void clearAllCrossHair() {
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setCrossHair(GoPoint.get(i, j), false);
            }
        }
    }

    public void clearAllInfluence() {
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.clearInfluence(GoPoint.get(i, j));
            }
        }
    }

    public void clearAllMarkup() {
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                this.setMark(goPoint, false);
                this.setMarkCircle(goPoint, false);
                this.setMarkSquare(goPoint, false);
                this.setMarkTriangle(goPoint, false);
            }
        }
    }

    public void clearAllSelect() {
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setSelect(GoPoint.get(i, j), false);
            }
        }
    }

    public void clearAllLabels() {
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setLabel(GoPoint.get(i, j), "");
            }
        }
    }

    public void clearAllTerritory() {
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setTerritory(GoPoint.get(i, j), GoColor.EMPTY);
            }
        }
    }

    public void clearInfluence(GoPoint goPoint) {
        this.getField(goPoint).clearInfluence();
        this.repaint(goPoint);
    }

    public void contextMenu(GoPoint goPoint) {
        this.m_panel.contextMenu(goPoint);
    }

    public int getBoardSize() {
        return this.m_size;
    }

    public Dimension getFieldSize() {
        int n = this.m_drawer.getFieldSize();
        return new Dimension(n, n);
    }

    public String getLabel(GoPoint goPoint) {
        return this.getField(goPoint).getLabel();
    }

    public Point getLocationOnScreen(GoPoint goPoint) {
        Point point = this.m_drawer.getCenter(goPoint.getX(), goPoint.getY());
        Point point2 = this.m_panel.getLocationOnScreen();
        point2.x += point.x;
        point2.y += point.y;
        return point2;
    }

    public boolean getMark(GoPoint goPoint) {
        return this.getField(goPoint).getMark();
    }

    public boolean getMarkCircle(GoPoint goPoint) {
        return this.getField(goPoint).getMarkCircle();
    }

    public boolean getMarkSquare(GoPoint goPoint) {
        return this.getField(goPoint).getMarkSquare();
    }

    public boolean getMarkTriangle(GoPoint goPoint) {
        return this.getField(goPoint).getMarkTriangle();
    }

    public Dimension getMinimumFieldSize() {
        return this.m_minimumFieldSize;
    }

    public Dimension getPreferredFieldSize() {
        return this.m_preferredFieldSize;
    }

    public boolean getSelect(GoPoint goPoint) {
        return this.getField(goPoint).getSelect();
    }

    public boolean getShowCursor() {
        return this.m_showCursor;
    }

    public void initSize(int n) {
        if (!($assertionsDisabled || n > 0 && n <= 25)) {
            throw new AssertionError();
        }
        this.m_size = n;
        this.m_constants = new BoardConstants(n);
        this.m_field = new GuiField[n][n];
        this.removeAll();
        this.m_cursor = null;
        this.setLayout(new SquareLayout());
        this.m_panel = new BoardPanel();
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (GuiBoard.this.getShowCursor()) {
                    GuiBoard.this.setCursor(GuiBoard.this.m_cursor, true);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (GuiBoard.this.getShowCursor()) {
                    GuiBoard.this.setCursor(GuiBoard.this.m_cursor, false);
                }
            }
        };
        this.m_panel.addFocusListener(focusListener);
        this.add(this.m_panel);
        this.m_panel.requestFocusInWindow();
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                GuiBoard.this.keyPressed(keyEvent);
            }
        };
        this.m_panel.addKeyListener(keyAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GoPoint goPoint = GuiBoard.this.m_panel.getPoint(mouseEvent);
                if (goPoint == null) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    GuiBoard.this.contextMenu(goPoint);
                    return;
                }
                int n = mouseEvent.getButton();
                int n2 = mouseEvent.getClickCount();
                if (n != 1) {
                    return;
                }
                if (n2 == 2) {
                    GuiBoard.this.fieldClicked(goPoint, true);
                } else {
                    int n3;
                    int n4 = mouseEvent.getModifiers();
                    boolean bl = (n4 & (n3 = 14)) != 0;
                    GuiBoard.this.fieldClicked(goPoint, bl);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                GoPoint goPoint = GuiBoard.this.m_panel.getPoint(mouseEvent);
                if (goPoint == null) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    GuiBoard.this.contextMenu(goPoint);
                    return;
                }
            }
        };
        this.m_panel.addMouseListener(mouseAdapter);
        for (int i = n - 1; i >= 0; --i) {
            for (int j = 0; j < n; ++j) {
                GuiField guiField;
                this.m_field[j][i] = guiField = new GuiField();
            }
        }
        this.m_lastMove = null;
        this.setCursor(GoPoint.get(this.m_size / 2, this.m_size / 2));
        this.revalidate();
        this.m_dirty = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.repaint();
    }

    public void markLastMove(GoPoint goPoint) {
        this.clearLastMove();
        this.m_lastMove = goPoint;
        if (this.m_lastMove != null) {
            GuiField guiField = this.getField(this.m_lastMove);
            guiField.setLastMoveMarker(true);
            this.repaint(goPoint);
            this.m_lastMove = goPoint;
        }
    }

    public void paintImmediately(GoPoint goPoint) {
        this.m_panel.paintImmediately(goPoint);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        double d = this.getSize().width;
        double d2 = this.getSize().height;
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        double d5 = 1.0;
        if (d >= d3) {
            d5 = d3 / d;
        }
        double d6 = (d3 - d * d5) / 2.0;
        double d7 = (d4 - d2 * d5) / 2.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX() + d6, pageFormat.getImageableY() + d7);
        graphics2D.scale(d5, d5);
        this.print(graphics2D);
        return 0;
    }

    public void setColor(GoPoint goPoint, GoColor goColor) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getColor() != goColor) {
            guiField.setColor(goColor);
            this.m_panel.repaintWithShadow(goPoint);
        }
    }

    public void setCursor(GoPoint goPoint) {
        if (goPoint != null && !goPoint.isOnBoard(this.m_size)) {
            goPoint = null;
        }
        if (this.m_cursor != goPoint) {
            this.setCursor(this.m_cursor, false);
            if (this.getShowCursor()) {
                this.setCursor(goPoint, true);
            }
            this.m_cursor = goPoint;
        }
    }

    public void setFieldBackground(GoPoint goPoint, Color color) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getFieldBackground() == null && color != null || guiField.getFieldBackground() != null && !guiField.getFieldBackground().equals(color)) {
            guiField.setFieldBackground(color);
            this.repaint(goPoint);
        }
    }

    public void setCrossHair(GoPoint goPoint, boolean bl) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getCrossHair() != bl) {
            guiField.setCrossHair(bl);
            this.repaint(goPoint);
        }
    }

    public void setInfluence(GoPoint goPoint, double d) {
        this.getField(goPoint).setInfluence(d);
        this.repaint(goPoint);
    }

    public void setLabel(GoPoint goPoint, String string) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getLabel() == null && string != null || guiField.getLabel() != null && !guiField.getLabel().equals(string)) {
            guiField.setLabel(string);
            this.repaint(goPoint);
        }
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    public void setMark(GoPoint goPoint, boolean bl) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getMark() != bl) {
            this.getField(goPoint).setMark(bl);
            this.repaint(goPoint);
        }
    }

    public void setMarkCircle(GoPoint goPoint, boolean bl) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getMarkCircle() != bl) {
            this.getField(goPoint).setMarkCircle(bl);
            this.repaint(goPoint);
        }
    }

    public void setMarkSquare(GoPoint goPoint, boolean bl) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getMarkSquare() != bl) {
            this.getField(goPoint).setMarkSquare(bl);
            this.repaint(goPoint);
        }
    }

    public void setMarkTriangle(GoPoint goPoint, boolean bl) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getMarkTriangle() != bl) {
            this.getField(goPoint).setMarkTriangle(bl);
            this.repaint(goPoint);
        }
    }

    public void setPreferredFieldSize(Dimension dimension) {
        this.m_preferredFieldSize = dimension;
        this.m_panel.setPreferredFieldSize();
    }

    public void setShowCursor(boolean bl) {
        this.setCursor(this.m_cursor, false);
        this.m_showCursor = bl;
        if (this.m_showCursor) {
            this.setCursor(this.m_cursor, true);
        }
        this.m_panel.requestFocusInWindow();
    }

    public void setShowGrid(boolean bl) {
        if (bl != this.m_showGrid) {
            this.m_showGrid = bl;
            this.m_dirty = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            this.repaint();
        }
    }

    public void setSelect(GoPoint goPoint, boolean bl) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getSelect() != bl) {
            this.getField(goPoint).setSelect(bl);
            this.repaint(goPoint);
        }
    }

    public void setTerritory(GoPoint goPoint, GoColor goColor) {
        GuiField guiField = this.getField(goPoint);
        if (guiField.getTerritory() != goColor) {
            guiField.setTerritory(goColor);
            this.repaint(goPoint);
        }
    }

    private void addDirty(Rectangle rectangle) {
        if (this.m_dirty == null) {
            this.m_dirty = rectangle;
        } else {
            this.m_dirty.add(rectangle);
        }
    }

    private void clearLastMove() {
        if (this.m_lastMove != null) {
            GuiField guiField = this.getField(this.m_lastMove);
            guiField.setLastMoveMarker(false);
            this.repaint(this.m_lastMove);
            this.m_lastMove = null;
        }
    }

    private void drawImage() {
        if (this.m_image == null || this.m_dirty == null) {
            return;
        }
        Graphics graphics = this.m_image.getGraphics();
        graphics.setClip(this.m_dirty);
        this.m_drawer.draw(graphics, this.m_field, this.m_imageWidth, this.m_showGrid);
        this.m_dirty = null;
    }

    private void fieldClicked(GoPoint goPoint, boolean bl) {
        if (this.m_listener != null) {
            this.m_listener.fieldClicked(goPoint, bl);
        }
    }

    private GuiField getField(GoPoint goPoint) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        return this.m_field[goPoint.getX()][goPoint.getY()];
    }

    private boolean isHandicapLineOrEdge(int n) {
        return this.m_constants.isHandicapLine(n) || this.m_constants.isEdgeLine(n);
    }

    private void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n == 10) {
            boolean bl;
            int n3 = 14;
            boolean bl2 = bl = (n2 & n3) != 0;
            if (this.getShowCursor() && this.m_cursor != null) {
                this.fieldClicked(this.m_cursor, bl);
            }
            return;
        }
        if ((n2 & 2) != 0 || !this.getShowCursor() || this.m_cursor == null) {
            return;
        }
        boolean bl = (n2 & 1) != 0;
        GoPoint goPoint = this.m_cursor;
        if (n == 40) {
            goPoint = goPoint.down();
            if (bl) {
                while (!this.isHandicapLineOrEdge(goPoint.getY())) {
                    goPoint = goPoint.down();
                }
            }
        } else if (n == 38) {
            goPoint = goPoint.up(this.m_size);
            if (bl) {
                while (!this.isHandicapLineOrEdge(goPoint.getY())) {
                    goPoint = goPoint.up(this.m_size);
                }
            }
        } else if (n == 37) {
            goPoint = goPoint.left();
            if (bl) {
                while (!this.isHandicapLineOrEdge(goPoint.getX())) {
                    goPoint = goPoint.left();
                }
            }
        } else if (n == 39) {
            goPoint = goPoint.right(this.m_size);
            if (bl) {
                while (!this.isHandicapLineOrEdge(goPoint.getX())) {
                    goPoint = goPoint.right(this.m_size);
                }
            }
        }
        this.setCursor(goPoint);
    }

    private void repaint(GoPoint goPoint) {
        this.m_panel.repaint(goPoint);
    }

    private void setCursor(GoPoint goPoint, boolean bl) {
        if (goPoint == null) {
            return;
        }
        GuiField guiField = this.getField(goPoint);
        if (guiField.getCursor() != bl) {
            guiField.setCursor(bl);
            this.repaint(goPoint);
        }
    }

    private void setPreferredFieldSize() {
        int n = (int)((double)GuiUtils.getDefaultMonoFontSize() * 2.2);
        if (n % 2 == 0) {
            ++n;
        }
        this.m_preferredFieldSize = new Dimension(n, n);
        n = GuiUtils.getDefaultMonoFontSize();
        if (n % 2 == 0) {
            ++n;
        }
        this.m_minimumFieldSize = new Dimension(n, n);
    }

    static {
        $assertionsDisabled = !GuiBoard.class.desiredAssertionStatus();
    }

    private class BoardPanel
    extends JPanel {
        private static final long serialVersionUID = 0L;

        public BoardPanel() {
            this.setPreferredFieldSize();
            this.setFocusable(true);
            this.setOpaque(true);
        }

        public void contextMenu(GoPoint goPoint) {
            if (GuiBoard.this.m_listener == null) {
                return;
            }
            Point point = GuiBoard.this.m_drawer.getCenter(goPoint.getX(), goPoint.getY());
            GuiBoard.this.m_listener.contextMenu(goPoint, this, point.x, point.y);
        }

        public GoPoint getPoint(MouseEvent mouseEvent) {
            return GuiBoard.this.m_drawer.getPoint(mouseEvent.getPoint());
        }

        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (GuiBoard.this.m_image == null || n != GuiBoard.this.m_imageWidth || n2 != GuiBoard.this.m_imageHeight) {
                GuiBoard.this.m_image = this.createImage(n, n2);
                GuiBoard.this.m_imageWidth = n;
                GuiBoard.this.m_imageHeight = n2;
                GuiBoard.this.m_dirty = new Rectangle(0, 0, n, n2);
            }
            GuiBoard.this.drawImage();
            graphics.drawImage(GuiBoard.this.m_image, 0, 0, null);
        }

        public void paintImmediately(GoPoint goPoint) {
            Point point = GuiBoard.this.m_drawer.getLocation(goPoint.getX(), goPoint.getY());
            Rectangle rectangle = new Rectangle();
            rectangle.x = point.x;
            rectangle.y = point.y;
            int n = GuiBoard.this.m_drawer.getShadowOffset() - GuiField.getStoneMargin(GuiBoard.this.m_drawer.getFieldSize());
            rectangle.width = GuiBoard.this.m_drawer.getFieldSize() + n;
            rectangle.height = GuiBoard.this.m_drawer.getFieldSize() + n;
            GuiBoard.this.addDirty(rectangle);
            Rectangle rectangle2 = GuiBoard.this.m_dirty;
            GuiBoard.this.m_dirty = rectangle;
            this.paintImmediately(rectangle);
            GuiBoard.this.m_dirty = rectangle2;
        }

        public void repaint(GoPoint goPoint) {
            Point point = GuiBoard.this.m_drawer.getLocation(goPoint.getX(), goPoint.getY());
            Rectangle rectangle = new Rectangle();
            rectangle.x = point.x;
            rectangle.y = point.y;
            rectangle.width = GuiBoard.this.m_drawer.getFieldSize();
            rectangle.height = GuiBoard.this.m_drawer.getFieldSize();
            GuiBoard.this.addDirty(rectangle);
            this.repaint(rectangle);
        }

        public void repaintWithShadow(GoPoint goPoint) {
            Point point = GuiBoard.this.m_drawer.getLocation(goPoint.getX(), goPoint.getY());
            Rectangle rectangle = new Rectangle();
            rectangle.x = point.x;
            rectangle.y = point.y;
            int n = GuiBoard.this.m_drawer.getShadowOffset() - GuiField.getStoneMargin(GuiBoard.this.m_drawer.getFieldSize());
            rectangle.width = GuiBoard.this.m_drawer.getFieldSize() + n;
            rectangle.height = GuiBoard.this.m_drawer.getFieldSize() + n;
            GuiBoard.this.addDirty(rectangle);
            this.repaint(rectangle);
        }

        public void setPreferredFieldSize() {
            int n;
            int n2;
            int n3 = GuiBoard.this.getPreferredFieldSize().width;
            if (GuiBoard.this.m_showGrid) {
                n2 = n3 * (GuiBoard.this.m_size + 2);
                n = 4 * (GuiBoard.this.m_size + 2);
            } else {
                n2 = n3 * GuiBoard.this.m_size + n3 / 2;
                n = 4 * GuiBoard.this.m_size + 2;
            }
            this.setPreferredSize(new Dimension(n2, n2));
            this.setMinimumSize(new Dimension(n, n));
        }
    }

    public static interface Listener {
        public void fieldClicked(GoPoint var1, boolean var2);

        public void contextMenu(GoPoint var1, Component var2, int var3, int var4);
    }
}

