/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class ReferenceSequenceFileWalker
implements Closeable {
    private final ReferenceSequenceFile referenceSequenceFile;
    private ReferenceSequence referenceSequence = null;

    public ReferenceSequenceFileWalker(ReferenceSequenceFile referenceSequenceFile) {
        this.referenceSequenceFile = referenceSequenceFile;
    }

    public ReferenceSequenceFileWalker(Path path) {
        this(ReferenceSequenceFileFactory.getReferenceSequenceFile(path, true, false));
    }

    public ReferenceSequenceFileWalker(File file) {
        this(ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true, false));
    }

    public ReferenceSequence get(int sequenceIndex, String sequenceName, int length) {
        this.get(sequenceIndex);
        if (!this.referenceSequence.getName().equals(sequenceName)) {
            throw new SAMException("Sequence name mismatch at sequence index (" + this.referenceSequence.getContigIndex() + ", " + this.referenceSequence.getName() + ") != " + sequenceName);
        }
        if (this.referenceSequence.getBases().length != length) {
            throw new SAMException("Sequence length mismatch for (" + sequenceIndex + ", " + sequenceName + ").  expected " + length + " but found " + this.referenceSequence.getBases().length);
        }
        return this.referenceSequence;
    }

    public ReferenceSequence get(int sequenceIndex) {
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() == sequenceIndex) {
            return this.referenceSequence;
        }
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() > sequenceIndex) {
            throw new SAMException("Requesting earlier reference sequence: " + sequenceIndex + " < " + this.referenceSequence.getContigIndex());
        }
        this.referenceSequence = null;
        if (this.referenceSequenceFile.isIndexed() && this.referenceSequenceFile.getSequenceDictionary() != null) {
            SAMSequenceRecord samSequenceRecord = this.referenceSequenceFile.getSequenceDictionary().getSequence(sequenceIndex);
            if (samSequenceRecord != null) {
                this.referenceSequence = this.referenceSequenceFile.getSequence(samSequenceRecord.getSequenceName());
            }
        } else {
            do {
                this.referenceSequence = this.referenceSequenceFile.nextSequence();
            } while (this.referenceSequence != null && this.referenceSequence.getContigIndex() < sequenceIndex);
        }
        if (this.referenceSequence == null || this.referenceSequence.getContigIndex() != sequenceIndex) {
            throw new SAMException("Reference sequence (" + sequenceIndex + ") not found in " + this.referenceSequenceFile.toString());
        }
        return this.referenceSequence;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.referenceSequenceFile.getSequenceDictionary();
    }

    @Override
    public void close() throws IOException {
        this.referenceSequenceFile.close();
    }
}

