/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.javacc.Version;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;

public class OutputFile {
    private static final String MD5_LINE_PART_1 = "/* JavaCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_1q = "/\\* JavaCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_2 = " (do not edit this line) */";
    private static final String MD5_LINE_PART_2q = " \\(do not edit this line\\) \\*/";
    TrapClosePrintWriter pw;
    DigestOutputStream dos;
    String toolName = "JavaCC";
    final File file;
    final String compatibleVersion;
    final String[] options;
    public boolean needToWrite = true;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public OutputFile(File file, String string, String[] stringArray) throws IOException {
        this.file = file;
        this.compatibleVersion = string;
        this.options = stringArray;
        if (file.exists()) {
            String string2;
            MessageDigest messageDigest;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw (IOException)new IOException("No MD5 implementation").initCause(noSuchAlgorithmException);
            }
            DigestOutputStream digestOutputStream = new DigestOutputStream(new NullOutputStream(), messageDigest);
            PrintWriter printWriter = new PrintWriter(digestOutputStream);
            String string3 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith(MD5_LINE_PART_1)) {
                    string3 = string2.replaceAll(MD5_LINE_PART_1q, "").replaceAll(MD5_LINE_PART_2q, "");
                    continue;
                }
                printWriter.println(string2);
            }
            printWriter.close();
            String string4 = OutputFile.toHexString(digestOutputStream.getMessageDigest().digest());
            if (string3 == null || !string3.equals(string4)) {
                this.needToWrite = false;
                if (string != null) {
                    this.checkVersion(file, string);
                }
                if (stringArray != null) {
                    this.checkOptions(file, stringArray);
                }
            } else {
                System.out.println("File \"" + file.getName() + "\" is being rebuilt.");
                this.needToWrite = true;
            }
        } else {
            System.out.println("File \"" + file.getName() + "\" does not exist.  Will create one.");
            this.needToWrite = true;
        }
    }

    public OutputFile(File file) throws IOException {
        this(file, null, null);
    }

    private void checkVersion(File file, String string) {
        String string2 = "/* " + JavaCCGlobals.getIdString(this.toolName, file.getName()) + " Version ";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith(string2)) continue;
                String string4 = string2.replaceFirst(".* Version ", "").replaceAll(" \\*/", "");
                if (string4 != string) {
                    JavaCCErrors.warning(file.getName() + ": File is obsolete.  Please rename or delete this file so" + " that a new one can be generated for you.");
                }
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new Error();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkOptions(File file, String[] stringArray) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("/* JavaCCOptions:")) continue;
                String string2 = Options.getOptionsString(stringArray);
                if (string.indexOf(string2) == -1) {
                    JavaCCErrors.warning(file.getName() + ": Generated using incompatible options. Please rename or delete this file so" + " that a new one can be generated for you.");
                }
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new Error();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PrintWriter getPrintWriter() throws IOException {
        if (this.pw == null) {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw (IOException)new IOException("No MD5 implementation").initCause(noSuchAlgorithmException);
            }
            this.dos = new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)), messageDigest);
            this.pw = new TrapClosePrintWriter(this.dos);
            String string = this.compatibleVersion == null ? Version.versionNumber : this.compatibleVersion;
            this.pw.println("/* " + JavaCCGlobals.getIdString(this.toolName, this.file.getName()) + " Version " + string + " */");
            if (this.options != null) {
                this.pw.println("/* JavaCCOptions:" + Options.getOptionsString(this.options) + " */");
            }
        }
        return this.pw;
    }

    public void close() throws IOException {
        if (this.pw != null) {
            this.pw.println(MD5_LINE_PART_1 + this.getMD5sum() + MD5_LINE_PART_2);
            this.pw.closePrintWriter();
        }
    }

    private String getMD5sum() {
        this.pw.flush();
        byte[] byArray = this.dos.getMessageDigest().digest();
        return OutputFile.toHexString(byArray);
    }

    private static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(HEX_DIGITS[(by & 0xF0) >> 4]).append(HEX_DIGITS[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    public String getToolName() {
        return this.toolName;
    }

    public void setToolName(String string) {
        this.toolName = string;
    }

    private class TrapClosePrintWriter
    extends PrintWriter {
        public TrapClosePrintWriter(OutputStream outputStream) {
            super(outputStream);
        }

        public void closePrintWriter() {
            super.close();
        }

        public void close() {
            try {
                OutputFile.this.close();
            }
            catch (IOException iOException) {
                System.err.println("Could not close " + OutputFile.this.file.getAbsolutePath());
            }
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(int n) throws IOException {
        }
    }
}

