/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_MENU_H__
#define __SG_PLUGIN_MENU_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"

#define SG_PLUGIN_MENU(obj)        GTK_CHECK_CAST (obj, sg_plugin_menu_get_type (), SGpluginMenu)
#define GTK_TYPE_SG_PLUGIN_MENU   (sg_plugin_menu_get_type ())

#define SG_PLUGIN_MENU_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_menu_get_type(), SGpluginMenuClass)
#define GTK_IS_SG_PLUGIN_MENU(obj)     GTK_CHECK_TYPE (obj, sg_plugin_menu_get_type ())


typedef struct _SGpluginMenu   SGpluginMenu;
typedef struct _SGpluginMenuClass   SGpluginMenuClass;
typedef void (*SGpluginMenuFunction)  (SGpluginMenu *plugin, GtkWidget *menu, gpointer data);

struct _SGpluginMenu
{
  SGplugin plugin;

  gchar *label;
  gchar *path;  
  gchar *owner_id;  
  GtkPixmap *pixmap;
 
  SGpluginMenuFunction action; 
};

struct _SGpluginMenuClass
{
  SGpluginClass parent_class;
};

GtkType		sg_plugin_menu_get_type	();
SGpluginMenu *	sg_plugin_menu_new		();
void	        sg_plugin_menu_action		(SGpluginMenu *plugin,
						 GtkWidget *menu,
						 gpointer data);
SGpluginMenu *  sg_plugin_menu_get		(const gchar *name,
						 const gchar *owner_id);
void 		sg_menu_add_plugin		(GtkWidget *menu, 
						 SGpluginMenu *plugin);
void 		sg_toolbar_add_plugin		(GtkWidget *toolbar, 
						 SGpluginMenu *plugin);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_MENU_H__ */

