# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""Contains classes for all messages put out by the Util module."""

from lottanzb.hellalog import LogRecord, _ExceptionHandler
from lottanzb.util import _

class RunningProcessWarning(LogRecord): # Topen.kill()
    PATTERN = r"^Left running process: (?P<command>.+)$"
    TEMPLATE = _("Left running process: %(command)s")

class ProcessKillError(_ExceptionHandler, LogRecord): # Topen.kill()
    PATTERN = r"^Unexpected problem while kill -9ing pid: (?P<pid>\d+) process: (?P<command>.+)$"
    TEMPLATE = _("Unable to kill process %(command)s with ID %(pid)s")
    
class InvalidNZBFileError(LogRecord): # validNZB(...)
    PATTERN = r"^Invalid NZB file: (?P<file_name>.+)$"
    TEMPLATE = _("Invalid NZB file: %(file_name)s")

class ReadNZBFileError(LogRecord): # validNZB(...)
    PATTERN = r"^Unable to read NZB file: (?P<file_name>.+)$"
    TEMPLATE = _("Unable to read NZB file: %(file_name)s")

class NoNZBFileNameError(LogRecord): # validNZB(...)
    PATTERN = r"^Invalid NZB file (No archive name): (?P<file_name>.+)$"
    TEMPLATE = _("Invalid NZB file (No archive name): %(file_name)s")

class ExecutableSearchFatal(LogRecord): # assertIsExe(...)
    PATTERN = r"Cannot continue program, your platform does not support searching the path for an executable and you did not supply the full path to the (?P<executable>.+) executable.$"
    TEMPLATE = _("Your platform does not support searching the path of an executable and you did not supply the full path to the %(executable)s executable.")

class ExecutableNotFoundFatal(LogRecord): # assertIsExe(...)
    PATTERN = r"Cannot continue program, required executable not found: '(?P<executable>.+)'$"
    TEMPLATE = _("Required executable not found: %(executable)s")

class DirectoryCreationFatal(LogRecord): # ensureDirs(...)
    PATTERN = r"Unable to create directory for option: Hellanzb\.(?P<option>.+) dirName: (?P<directory>.+) error: (?P<error_message_detailed>.+)$"
    TEMPLATE = _("Unable to create directory %(directory)s for option Hellanzb.%(option)s: %(error_message_detailed)s")

class NoWriteAccessFatal(LogRecord): # ensureDirs(...)
    PATTERN = r"Cannot continue: hellanzb needs write access to directories?:(?P<directories>.+)\z"
    TEMPLATE = _("HellaNZB does not have write access to the directories:\n%(directories)s")
