/**
 * Module to manage content bank actions, such as delete or rename.
 *
 * @module     core_contentbank/actions
 * @copyright  2020 Sara Arjona <sara@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_contentbank/actions",["jquery","core/ajax","core/notification","core/str","core/templates","core/url","core/modal_save_cancel","core/modal_events"],(function($,Ajax,Notification,Str,Templates,Url,ModalSaveCancel,ModalEvents){var ACTIONS_DELETE_CONTENT='[data-action="deletecontent"]',ACTIONS_RENAME_CONTENT='[data-action="renamecontent"]',ACTIONS_SET_CONTENT_VISIBILITY='[data-action="setcontentvisibility"]',ACTIONS_COPY_CONTENT='[data-action="copycontent"]',Actions=function(){this.registerEvents()};return Actions.prototype.registerEvents=function(){$(ACTIONS_DELETE_CONTENT).click((function(e){e.preventDefault();var contentname=$(this).data("contentname"),contentuses=$(this).data("uses"),contentid=$(this).data("contentid"),contextid=$(this).data("contextid"),strings=[{key:"deletecontent",component:"core_contentbank"},{key:"deletecontentconfirm",component:"core_contentbank",param:{name:contentname}},{key:"deletecontentconfirmlinked",component:"core_contentbank"},{key:"delete",component:"core"}],deleteButtonText="";Str.get_strings(strings).then((function(langStrings){var modalTitle=langStrings[0],modalContent=langStrings[1];return contentuses>0&&(modalContent+=" "+langStrings[2]),deleteButtonText=langStrings[3],ModalSaveCancel.create({title:modalTitle,body:modalContent,large:!0,removeOnClose:!0,show:!0,buttons:{save:deleteButtonText}})})).then((function(modal){modal.getRoot().on(ModalEvents.save,(function(){return function(contentid,contextid){var request={methodname:"core_contentbank_delete_content",args:{contentids:{contentid:contentid}}},requestType="success";Ajax.call([request])[0].then((function(data){return data.result?"contentdeleted":(requestType="error","contentnotdeleted")})).done((function(message){var params={contextid:contextid};"success"==requestType?params.statusmsg=message:params.errormsg=message,window.location.href=Url.relativeUrl("contentbank/index.php",params,!1)})).fail(Notification.exception)}(contentid,contextid)}))})).catch(Notification.exception)})),$(ACTIONS_RENAME_CONTENT).click((function(e){e.preventDefault();var contentname=$(this).data("contentname"),contentid=$(this).data("contentid"),saveButtonText="";Str.get_strings([{key:"renamecontent",component:"core_contentbank"},{key:"rename",component:"core_contentbank"}]).then((function(langStrings){var modalTitle=langStrings[0];return saveButtonText=langStrings[1],ModalSaveCancel.create({title:modalTitle,body:Templates.render("core_contentbank/renamecontent",{contentid:contentid,name:contentname}),removeOnClose:!0,show:!0,buttons:{save:saveButtonText}})})).then((function(modal){modal.getRoot().on(ModalEvents.save,(function(e){var newname=$("#newname").val().trim();if(newname)!function(contentid,name){var request={methodname:"core_contentbank_rename_content",args:{contentid:contentid,name:name}},requestType="success";Ajax.call([request])[0].then((function(data){return data.result?"contentrenamed":(requestType="error",data.warnings[0].message)})).then((function(message){var params=null;"success"==requestType?(params={id:contentid,statusmsg:message},window.location.href=Url.relativeUrl("contentbank/view.php",params,!1)):(Notification.addNotification({message:message,type:"error"}),Notification.fetchNotifications())})).catch(Notification.exception)}(contentid,newname);else{Str.get_strings([{key:"error"},{key:"emptynamenotallowed",component:"core_contentbank"}]).then((function(langStrings){Notification.alert(langStrings[0],langStrings[1])})).catch(Notification.exception),e.preventDefault()}}))})).catch(Notification.exception)})),$(ACTIONS_COPY_CONTENT).click((function(e){e.preventDefault();var contentname=$(this).data("contentname"),contentid=$(this).data("contentid");let errorTitle,errorMessage;Str.get_strings([{key:"copycontent",component:"core_contentbank"},{key:"error"},{key:"emptynamenotallowed",component:"core_contentbank"}]).then((function(langStrings){var modalTitle=langStrings[0];return errorTitle=langStrings[1],errorMessage=langStrings[2],ModalSaveCancel.create({title:modalTitle,body:Templates.render("core_contentbank/copycontent",{contentid:contentid,name:contentname}),removeOnClose:!0,show:!0})})).then((function(modal){modal.getRoot().on(ModalEvents.save,(function(){var newname=$("#newname").val().trim();if(!newname)return Notification.alert(errorTitle,errorMessage),!1;!function(contentid,name){var request={methodname:"core_contentbank_copy_content",args:{contentid:contentid,name:name}};Ajax.call([request])[0].then((function(data){if(0==data.id)return Notification.addNotification({message:data.warnings[0].message,type:"error"}),Notification.fetchNotifications(),data.warnings[0].message;{let params={id:data.id,statusmsg:"contentcopied"};window.location.href=Url.relativeUrl("contentbank/view.php",params,!1)}return""})).catch(Notification.exception)}(contentid,newname)}))})).catch(Notification.exception)})),$(ACTIONS_SET_CONTENT_VISIBILITY).click((function(e){e.preventDefault(),function(contentid,visibility){var request={methodname:"core_contentbank_set_content_visibility",args:{contentid:contentid,visibility:visibility}},requestType="success";Ajax.call([request])[0].then((function(data){return data.result?"contentvisibilitychanged":(requestType="error",data.warnings[0].message)})).then((function(message){var params=null;"success"==requestType?(params={id:contentid,statusmsg:message},window.location.href=Url.relativeUrl("contentbank/view.php",params,!1)):(Notification.addNotification({message:message,type:"error"}),Notification.fetchNotifications())})).catch(Notification.exception)}($(this).data("contentid"),$(this).data("visibility"))}))},{init:function(){return new Actions}}}));

//# sourceMappingURL=actions.min.js.map