/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import net.claribole.zvtm.engine.ViewEventHandler;

public class GLViewPanel
extends ViewPanel
implements Runnable {
    Dimension oldSize;

    public GLViewPanel(Vector cameras, View v) {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (GLViewPanel.this.isShowing()) {
                    GLViewPanel.this.start();
                } else {
                    GLViewPanel.this.stop();
                }
            }
        });
        this.parent = v;
        this.cams = new Camera[cameras.size()];
        this.evHs = new ViewEventHandler[this.cams.length];
        for (int nbcam = 0; nbcam < cameras.size(); ++nbcam) {
            this.cams[nbcam] = (Camera)cameras.get(nbcam);
        }
        this.setBackground(this.backColor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.start();
        this.setAWTCursor(-1);
        VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
        if (VirtualSpaceManager.debug) {
            System.out.println("View refresh time set to " + this.frameTime + "ms");
        }
    }

    public void start() {
        this.size = this.getSize();
        this.runView = new Thread(this);
        this.runView.setPriority(5);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (this.getSize().width <= 0) {
            try {
                Thread.sleep(this.inactiveSleepTime);
            }
            catch (InterruptedException e) {
                VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
                if (VirtualSpaceManager.debug) {
                    System.err.println("viewpanel.run.runview.sleep " + e);
                }
                return;
            }
        }
        this.oldSize = this.getSize();
        while (this.runView == me) {
            if (this.active) {
                if (this.repaintNow || this.updateMouseOnly) {
                    this.repaint();
                    this.timeToSleep = (long)this.frameTime - this.loopTotalTime;
                    try {
                        Thread.sleep(this.timeToSleep > (long)this.minimumSleepTime ? this.timeToSleep : (long)this.minimumSleepTime);
                        continue;
                    }
                    catch (InterruptedException e) {
                        VirtualSpaceManager cfr_ignored_1 = this.parent.parent;
                        if (VirtualSpaceManager.debug) {
                            System.err.println("viewpanel.run.runview.sleep3 " + e);
                        }
                        return;
                    }
                }
                try {
                    Thread.sleep(this.frameTime + this.noRepaintAdditionalTime);
                    continue;
                }
                catch (InterruptedException e) {
                    VirtualSpaceManager cfr_ignored_2 = this.parent.parent;
                    if (VirtualSpaceManager.debug) {
                        System.err.println("viewpanel.run.runview.sleep4 " + e);
                    }
                    return;
                }
            }
            try {
                Thread.sleep(this.inactiveSleepTime);
            }
            catch (InterruptedException e) {
                VirtualSpaceManager cfr_ignored_3 = this.parent.parent;
                if (VirtualSpaceManager.debug) {
                    System.err.println("viewpanel.run.runview.sleep5 " + e);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        block39: {
            this.loopStartTime = System.currentTimeMillis();
            super.paint(g);
            this.backBufferGraphics = (Graphics2D)g;
            try {
                this.repaintNow = false;
                this.updateMouseOnly = false;
                this.size = this.getSize();
                this.viewW = this.size.width;
                this.viewH = this.size.height;
                if (this.size.width != this.oldSize.width || this.size.height != this.oldSize.height) {
                    VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
                    if (VirtualSpaceManager.debug) {
                        System.out.println("Resizing JPanel: (" + this.oldSize.width + "x" + this.oldSize.height + ") -> (" + this.size.width + "x" + this.size.height + ")");
                    }
                    this.oldSize = this.size;
                    this.updateAntialias = true;
                    this.updateFont = true;
                }
                if (this.updateFont) {
                    this.backBufferGraphics.setFont(VirtualSpaceManager.mainFont);
                    this.updateFont = false;
                }
                if (this.updateAntialias) {
                    if (this.antialias) {
                        this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    } else {
                        this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    }
                    this.updateAntialias = false;
                }
                this.standardStroke = this.backBufferGraphics.getStroke();
                this.standardTransform = this.backBufferGraphics.getTransform();
                if (this.notBlank) {
                    block40: {
                        this.backBufferGraphics.setPaintMode();
                        this.backBufferGraphics.setBackground(this.backColor);
                        this.backBufferGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                        if (this.parent.painters[0] != null) {
                            this.parent.painters[0].paint(this.backBufferGraphics, this.size.width, this.size.height);
                        }
                        for (int nbcam = 0; nbcam < this.cams.length; ++nbcam) {
                            if (this.cams[nbcam] == null || !this.cams[nbcam].enabled || !this.cams[nbcam].eager && !this.cams[nbcam].shouldRepaint()) continue;
                            this.camIndex = this.cams[nbcam].getIndex();
                            Vector vector = this.drawnGlyphs = this.cams[nbcam].parentSpace.getDrawnGlyphs(this.camIndex);
                            synchronized (vector) {
                                this.drawnGlyphs.removeAllElements();
                                this.uncoef = (this.cams[nbcam].focal + this.cams[nbcam].altitude) / this.cams[nbcam].focal;
                                this.viewWC = (long)((float)this.cams[nbcam].posx - (float)(this.viewW / 2L - (long)this.visibilityPadding[0]) * this.uncoef);
                                this.viewNC = (long)((float)this.cams[nbcam].posy + (float)(this.viewH / 2L - (long)this.visibilityPadding[1]) * this.uncoef);
                                this.viewEC = (long)((float)this.cams[nbcam].posx + (float)(this.viewW / 2L - (long)this.visibilityPadding[2]) * this.uncoef);
                                this.viewSC = (long)((float)this.cams[nbcam].posy - (float)(this.viewH / 2L - (long)this.visibilityPadding[3]) * this.uncoef);
                                this.gll = this.cams[nbcam].parentSpace.getDrawingList();
                                for (int i = 0; i < this.gll.length; ++i) {
                                    if (!this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) continue;
                                    Glyph glyph = this.gll[i];
                                    synchronized (glyph) {
                                        this.gll[i].project(this.cams[nbcam], this.size);
                                        if (this.gll[i].isVisible()) {
                                            this.gll[i].draw(this.backBufferGraphics, this.size.width, this.size.height, this.cams[nbcam].getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                                        }
                                        this.cams[nbcam].parentSpace.drewGlyph(this.gll[i], this.camIndex);
                                        continue;
                                    }
                                }
                                continue;
                            }
                        }
                        if (this.parent.painters[1] != null) {
                            this.parent.painters[1].paint(this.backBufferGraphics, this.size.width, this.size.height);
                        }
                        if (this.parent.painters[2] != null) {
                            this.parent.painters[2].paint(this.backBufferGraphics, this.size.width, this.size.height);
                        }
                        for (int i = 0; i < this.parent.portals.length; ++i) {
                            this.parent.portals[i].paint(this.backBufferGraphics, this.size.width, this.size.height);
                        }
                        if (this.parent.painters[3] != null) {
                            this.parent.painters[3].paint(this.backBufferGraphics, this.size.width, this.size.height);
                        }
                        if (!this.inside) break block39;
                        try {
                            this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                            if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                this.parent.mouse.computeMouseOverList(this.evHs[this.activeLayer], this.cams[this.activeLayer]);
                            }
                        }
                        catch (NullPointerException ex) {
                            VirtualSpaceManager cfr_ignored_1 = this.parent.parent;
                            if (!VirtualSpaceManager.debug) break block40;
                            System.err.println("viewpanel.run.drawdrag " + ex);
                        }
                    }
                    this.backBufferGraphics.setColor(this.parent.mouse.hcolor);
                    if (this.drawDrag) {
                        this.backBufferGraphics.drawLine(this.origDragx, this.origDragy, this.parent.mouse.mx, this.parent.mouse.my);
                    }
                    if (this.drawRect) {
                        this.backBufferGraphics.drawRect(Math.min(this.origDragx, this.parent.mouse.mx), Math.min(this.origDragy, this.parent.mouse.my), Math.max(this.origDragx, this.parent.mouse.mx) - Math.min(this.origDragx, this.parent.mouse.mx), Math.max(this.origDragy, this.parent.mouse.my) - Math.min(this.origDragy, this.parent.mouse.my));
                    }
                    if (this.drawOval) {
                        if (this.circleOnly) {
                            this.backBufferGraphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx));
                        } else {
                            this.backBufferGraphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragy - this.parent.mouse.my), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragy - this.parent.mouse.my));
                        }
                    }
                    if (!this.drawVTMcursor) break block39;
                    GLViewPanel ex = this;
                    synchronized (ex) {
                        this.parent.mouse.draw(this.backBufferGraphics);
                        this.oldX = this.parent.mouse.mx;
                        this.oldY = this.parent.mouse.my;
                        break block39;
                    }
                }
                this.backBufferGraphics.setPaintMode();
                this.backBufferGraphics.setColor(this.blankColor);
                this.backBufferGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.parent.painters[3] != null) {
                    try {
                        this.parent.painters[3].paint(this.backBufferGraphics, this.size.width, this.size.height);
                    }
                    catch (ClassCastException ex) {
                        if (VirtualSpaceManager.debugModeON()) {
                            System.err.println("Failed to draw AFTER_PORTALS in blank mode");
                        }
                    }
                }
            }
            catch (NullPointerException ex0) {
                VirtualSpaceManager cfr_ignored_2 = this.parent.parent;
                if (!VirtualSpaceManager.debug) break block39;
                System.err.println("GLViewPanel.paint " + ex0);
            }
        }
        this.loopTotalTime = System.currentTimeMillis() - this.loopStartTime;
        if (this.repaintListener != null) {
            this.repaintListener.viewRepainted(this.parent);
        }
    }

    public BufferedImage getImage() {
        return null;
    }
}

