/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.PopupDeleteMenu;

public class PopupMenuDeleteHistory
extends ExtensionPopupMenu {
    private ExtensionHistory extension = null;
    private JTree treeSite = null;

    public PopupMenuDeleteHistory() {
        this.initialize();
    }

    public PopupMenuDeleteHistory(String string) {
        super(string);
    }

    private void initialize() {
        this.setText("Delete (from view)");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JList jList = PopupMenuDeleteHistory.this.extension.getLogPanel().getListLog();
                Object[] objectArray = jList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    HistoryReference historyReference = (HistoryReference)objectArray[i];
                    PopupMenuDeleteHistory.this.deleteHistory(historyReference);
                }
            }
        });
    }

    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("ListLog")) {
            try {
                JList jList = (JList)component;
                if (jList.getSelectedIndex() >= 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private JTree getTree(Component component) {
        JTree jTree;
        if (component instanceof JTree && (jTree = (JTree)component).getName().equals("treeSite")) {
            return jTree;
        }
        return null;
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private void deleteHistory(HistoryReference historyReference) {
        if (historyReference == null) {
            return;
        }
        this.extension.getHistoryList().removeElement(historyReference);
        SiteNode siteNode = historyReference.getSiteNode();
        if (siteNode == null) {
            return;
        }
        Session session = Model.getSingleton().getSession();
        SiteMap siteMap = session.getSiteTree();
        if (siteNode.getHistoryReference() == historyReference) {
            PopupDeleteMenu.delete(siteMap, siteNode);
        } else {
            siteNode.getPastHistoryReference().remove(historyReference);
        }
    }
}

