/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.state;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.commons.httpclient.HttpState;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;

public class ExtensionState
extends ExtensionAdaptor
implements SessionChangedListener {
    private JCheckBoxMenuItem menuSessionTrackingEnable = null;
    private JMenuItem menuResetSessionState = null;

    public ExtensionState() {
        this.initialize();
    }

    public ExtensionState(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionState");
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        ExtensionHookView extensionHookView = extensionHook.getHookView();
        extensionHook.getHookMenu().addEditMenuItem(extensionHook.getHookMenu().getMenuSeparator());
        extensionHook.getHookMenu().addEditMenuItem(this.getMenuSessionTrackingEnable());
        extensionHook.getHookMenu().addEditMenuItem(this.getMenuResetSessionState());
    }

    private JCheckBoxMenuItem getMenuSessionTrackingEnable() {
        if (this.menuSessionTrackingEnable == null) {
            this.menuSessionTrackingEnable = new JCheckBoxMenuItem();
            this.menuSessionTrackingEnable.setText("Enable Session Tracking (Cookie)");
            this.getMenuResetSessionState().setEnabled(this.menuSessionTrackingEnable.isSelected());
            this.menuSessionTrackingEnable.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ExtensionState.this.getModel().getOptionsParam().getConnectionParam().setHttpStateEnabled(ExtensionState.this.menuSessionTrackingEnable.isEnabled());
                    ExtensionState.this.getMenuResetSessionState().setEnabled(ExtensionState.this.menuSessionTrackingEnable.isSelected());
                    ExtensionState.this.resetSessionState();
                }
            });
        }
        return this.menuSessionTrackingEnable;
    }

    private JMenuItem getMenuResetSessionState() {
        if (this.menuResetSessionState == null) {
            this.menuResetSessionState = new JMenuItem();
            this.menuResetSessionState.setText("Reset Session State");
            this.menuResetSessionState.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionState.this.getView().showConfirmDialog("Session state will be reset.  Continue?") == 0) {
                        ExtensionState.this.resetSessionState();
                    }
                }
            });
        }
        return this.menuResetSessionState;
    }

    public void sessionChanged(Session session) {
        this.getModel().getOptionsParam().getConnectionParam().setHttpState(new HttpState());
    }

    private void resetSessionState() {
        this.getModel().getOptionsParam().getConnectionParam().setHttpState(new HttpState());
    }
}

