/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.HttpPanelTabularModel;
import org.parosproxy.paros.view.View;

public class HttpPanel
extends AbstractPanel {
    private static final String VIEW_RAW = "Raw View    ";
    private static final String VIEW_TABULAR = "Tabular View";
    private static final String VIEW_IMAGE = "Image View";
    private JSplitPane splitVert = null;
    private JScrollPane scrollHeader = null;
    private JScrollPane scrollTableBody = null;
    private JTextArea txtHeader = null;
    private JTextArea txtBody = null;
    private JLabel lblIcon = null;
    private JPanel panelView = null;
    private JPanel jPanel = null;
    private JComboBox comboView = null;
    private JPanel panelOption = null;
    private JTable tableBody = null;
    private HttpPanelTabularModel httpPanelTabularModel = null;
    private JScrollPane scrollTxtBody = null;
    private String currentView = "Raw View    ";
    private JScrollPane scrollImage = null;

    public HttpPanel() {
        this.initialize();
    }

    public HttpPanel(boolean bl) {
        this();
        this.getTxtHeader().setEditable(bl);
        this.getTxtBody().setEditable(bl);
        this.getHttpPanelTabularModel().setEditable(bl);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setSize(403, 296);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.getSplitVert(), gridBagConstraints2);
        this.add((Component)this.getJPanel(), gridBagConstraints);
    }

    private JSplitPane getSplitVert() {
        if (this.splitVert == null) {
            this.splitVert = new JSplitPane();
            this.splitVert.setDividerLocation(220);
            this.splitVert.setDividerSize(3);
            this.splitVert.setOrientation(0);
            this.splitVert.setPreferredSize(new Dimension(400, 400));
            this.splitVert.setResizeWeight(0.5);
            this.splitVert.setTopComponent(this.getScrollHeader());
            this.splitVert.setContinuousLayout(false);
            this.splitVert.setBottomComponent(this.getPanelView());
        }
        return this.splitVert;
    }

    private JScrollPane getScrollHeader() {
        if (this.scrollHeader == null) {
            this.scrollHeader = new JScrollPane();
            this.scrollHeader.setViewportView(this.getTxtHeader());
        }
        return this.scrollHeader;
    }

    private JScrollPane getScrollTableBody() {
        if (this.scrollTableBody == null) {
            this.scrollTableBody = new JScrollPane();
            this.scrollTableBody.setName(VIEW_TABULAR);
            this.scrollTableBody.setViewportView(this.getTableBody());
        }
        return this.scrollTableBody;
    }

    public JTextArea getTxtHeader() {
        if (this.txtHeader == null) {
            this.txtHeader = new JTextArea();
            this.txtHeader.setLineWrap(true);
            this.txtHeader.setFont(new Font("Default", 0, 12));
            this.txtHeader.setName("");
            this.txtHeader.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.txtHeader;
    }

    public JTextArea getTxtBody() {
        String string;
        if (this.txtBody == null) {
            this.txtBody = new JTextArea();
            this.txtBody.setLineWrap(true);
            this.txtBody.setFont(new Font("Default", 0, 12));
            this.txtBody.setName("");
            this.txtBody.setTabSize(4);
            this.txtBody.setVisible(true);
            this.txtBody.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        if (this.currentView.equals(VIEW_TABULAR) && (string = this.getHttpPanelTabularModel().getText()) != null && string.length() > 0) {
            this.txtBody.setText(string);
        }
        return this.txtBody;
    }

    private JPanel getPanelView() {
        if (this.panelView == null) {
            this.panelView = new JPanel();
            this.panelView.setLayout(new CardLayout());
            this.panelView.setPreferredSize(new Dimension(278, 10));
            this.panelView.add((Component)this.getScrollTxtBody(), this.getScrollTxtBody().getName());
            this.panelView.add((Component)this.getScrollImage(), this.getScrollImage().getName());
            this.panelView.add((Component)this.getScrollTableBody(), this.getScrollTableBody().getName());
            this.show(VIEW_RAW);
        }
        return this.panelView;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints2.anchor = 14;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            jLabel.setText("      ");
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 17;
            this.jPanel.add((Component)this.getComboView(), gridBagConstraints3);
            this.jPanel.add((Component)jLabel, gridBagConstraints);
            this.jPanel.add((Component)this.getPanelOption(), gridBagConstraints2);
        }
        return this.jPanel;
    }

    private JComboBox getComboView() {
        if (this.comboView == null) {
            this.comboView = new JComboBox();
            this.comboView.setSelectedIndex(-1);
            this.comboView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    String string2 = (String)HttpPanel.this.comboView.getSelectedItem();
                    if (string2 == null || string2.equals(HttpPanel.this.currentView)) {
                        return;
                    }
                    if (HttpPanel.this.currentView.equals(HttpPanel.VIEW_TABULAR) && (string = HttpPanel.this.getHttpPanelTabularModel().getText()) != null && string.length() > 0) {
                        HttpPanel.this.txtBody.setText(string);
                    }
                    if (string2.equals(HttpPanel.VIEW_TABULAR)) {
                        HttpPanel.this.getHttpPanelTabularModel().setText(HttpPanel.this.getTxtBody().getText());
                    }
                    HttpPanel.this.currentView = string2;
                    HttpPanel.this.show(string2);
                }
            });
            this.comboView.addItem(VIEW_RAW);
            this.comboView.addItem(VIEW_TABULAR);
        }
        return this.comboView;
    }

    public JPanel getPanelOption() {
        if (this.panelOption == null) {
            this.panelOption = new JPanel();
            this.panelOption.setLayout(new CardLayout());
        }
        return this.panelOption;
    }

    private JTable getTableBody() {
        if (this.tableBody == null) {
            this.tableBody = new JTable();
            this.tableBody.setName("");
            this.tableBody.setModel(this.getHttpPanelTabularModel());
            this.tableBody.setGridColor(Color.gray);
            this.tableBody.setIntercellSpacing(new Dimension(1, 1));
            this.tableBody.setRowHeight(18);
        }
        return this.tableBody;
    }

    private HttpPanelTabularModel getHttpPanelTabularModel() {
        if (this.httpPanelTabularModel == null) {
            this.httpPanelTabularModel = new HttpPanelTabularModel();
        }
        return this.httpPanelTabularModel;
    }

    private JScrollPane getScrollTxtBody() {
        if (this.scrollTxtBody == null) {
            this.scrollTxtBody = new JScrollPane();
            this.scrollTxtBody.setName(VIEW_RAW);
            this.scrollTxtBody.setViewportView(this.getTxtBody());
            this.scrollTxtBody.setVerticalScrollBarPolicy(20);
        }
        return this.scrollTxtBody;
    }

    private void show(String string) {
        CardLayout cardLayout = (CardLayout)this.getPanelView().getLayout();
        cardLayout.show(this.getPanelView(), string);
    }

    public void setMessage(String string, String string2, boolean bl) {
        this.getComboView().setEnabled(bl);
        JTextArea jTextArea = this.getTxtBody();
        this.validate();
        if (bl) {
            this.getHttpPanelTabularModel().setText(string2);
        } else {
            this.getComboView().setSelectedItem(VIEW_RAW);
            this.currentView = VIEW_RAW;
            this.show(VIEW_RAW);
            this.getHttpPanelTabularModel().setText("");
        }
        this.getTxtHeader().setText(string);
        this.getTxtHeader().setCaretPosition(0);
        jTextArea.setText(string2);
        jTextArea.setCaretPosition(0);
    }

    public void setMessage(HttpMessage httpMessage, boolean bl) {
        JTextArea jTextArea = this.getTxtBody();
        this.getComboView().removeAllItems();
        this.getComboView().setEnabled(false);
        this.getComboView().addItem(VIEW_RAW);
        if (httpMessage == null) {
            this.getTxtHeader().setText("");
            this.getTxtHeader().setCaretPosition(0);
            jTextArea.setText("");
            jTextArea.setCaretPosition(0);
            this.getComboView().setSelectedItem(VIEW_RAW);
            this.currentView = VIEW_RAW;
            this.show(VIEW_RAW);
            this.getHttpPanelTabularModel().setText("");
            return;
        }
        if (bl) {
            this.setDisplayRequest(httpMessage);
        } else {
            this.setDisplayResponse(httpMessage);
        }
        this.validate();
    }

    private void setDisplayRequest(HttpMessage httpMessage) {
        String string = this.replaceHeaderForJTextArea(httpMessage.getRequestHeader().toString());
        String string2 = httpMessage.getRequestBody().toString();
        this.getHttpPanelTabularModel().setText(httpMessage.getRequestBody().toString());
        this.getTxtHeader().setText(string);
        this.getTxtHeader().setCaretPosition(0);
        this.txtBody.setText(string2);
        this.txtBody.setCaretPosition(0);
        this.getComboView().addItem(VIEW_TABULAR);
        this.getComboView().setEnabled(true);
    }

    private void setDisplayResponse(HttpMessage httpMessage) {
        if (httpMessage.getResponseHeader().isEmpty()) {
            this.getTxtHeader().setText("");
            this.getTxtHeader().setCaretPosition(0);
            this.txtBody.setText("");
            this.txtBody.setCaretPosition(0);
            this.getLblIcon().setIcon(null);
            return;
        }
        String string = this.replaceHeaderForJTextArea(httpMessage.getResponseHeader().toString());
        String string2 = httpMessage.getResponseBody().toString();
        this.getTxtHeader().setText(string);
        this.getTxtHeader().setCaretPosition(0);
        this.txtBody.setText(string2);
        this.txtBody.setCaretPosition(0);
        this.getComboView().removeAllItems();
        this.getComboView().addItem(VIEW_RAW);
        this.getComboView().setEnabled(true);
        if (httpMessage.getResponseHeader().isImage()) {
            this.getComboView().addItem(VIEW_IMAGE);
            this.getLblIcon().setIcon(this.getImageIcon(httpMessage));
        }
        if (httpMessage.getResponseHeader().isImage()) {
            this.getComboView().setSelectedItem(VIEW_IMAGE);
        } else {
            this.getComboView().setSelectedItem(VIEW_RAW);
        }
    }

    private String getHeaderFromJTextArea(JTextArea jTextArea) {
        String string = jTextArea.getText();
        String string2 = string.replaceAll("\\n", "\r\n");
        string2 = string2.replaceAll("(\\r\\n)*\\z", "") + "\r\n\r\n";
        return string2;
    }

    private String replaceHeaderForJTextArea(String string) {
        return string.replaceAll("\\r\\n", "\n");
    }

    public void getMessage(HttpMessage httpMessage, boolean bl) {
        try {
            if (bl) {
                if (this.getTxtHeader().getText().length() == 0) {
                    httpMessage.getRequestHeader().clear();
                    httpMessage.getRequestBody().setBody("");
                } else {
                    httpMessage.getRequestHeader().setMessage(this.getHeaderFromJTextArea(this.getTxtHeader()));
                    httpMessage.getRequestBody().setBody(this.getTxtBody().getText());
                    httpMessage.getRequestHeader().setContentLength(httpMessage.getRequestBody().length());
                }
            } else if (this.getTxtHeader().getText().length() == 0) {
                httpMessage.getResponseHeader().clear();
                httpMessage.getResponseBody().setBody("");
            } else {
                httpMessage.getResponseHeader().setMessage(this.getHeaderFromJTextArea(this.getTxtHeader()));
                String string = this.getTxtBody().getText();
                httpMessage.getResponseBody().setBody(string);
                httpMessage.getResponseHeader().setContentLength(httpMessage.getResponseBody().length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JScrollPane getScrollImage() {
        if (this.scrollImage == null) {
            this.scrollImage = new JScrollPane();
            this.scrollImage.setName(VIEW_IMAGE);
            this.scrollImage.setViewportView(this.getLblIcon());
        }
        return this.scrollImage;
    }

    private JLabel getLblIcon() {
        if (this.lblIcon == null) {
            this.lblIcon = new JLabel();
            this.lblIcon.setText("");
            this.lblIcon.setVerticalAlignment(1);
            this.lblIcon.setBackground(SystemColor.text);
        }
        return this.lblIcon;
    }

    private ImageIcon getImageIcon(HttpMessage httpMessage) {
        ImageIcon imageIcon = new ImageIcon(httpMessage.getResponseBody().getBytes());
        return imageIcon;
    }
}

