<?php
/**
 * File containing the ezcWebdavOptionsResponse class.
 *
 * @package Webdav
 * @version 1.1.4
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 */
/**
 * Class generated by the backend to respond to OPTIONS requests.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavOptionsRequest} it might react with an instance of {@link
 * ezcWebdavOptionsResponse} or with producing an error.
 *
 * @version 1.1.4
 * @package Webdav
 */
class ezcWebdavOptionsResponse extends ezcWebdavResponse
{

    const VERSION_ONE = '1';
    const VERSION_TWO = '2';
    const VERSION_ONE_EXTENDED = '1#extended';

    /**
     * Creates a new response object.
     *
     * Creates a new response object, that indicates the given WebDAV $version
     * to be supported by the server.
     * 
     * @param string $version 
     * @return void
     */
    public function __construct( $version = null )
    {
        parent::__construct( ezcWebdavResponse::STATUS_200 );
        $this->setHeader( 'DAV', ( $version === null ? '1' : $version ) );
    }

    /**
     * Validates the headers set in this response.
     *
     * This method is called by {@link ezcWebdavServer} after the response
     * object has been created by an {@link ezcWebdavBackend}. It validates all
     * headers, specific to this response, for existance of required headers
     * and validity of all headers used. The call of the parent method is
     * *mandatory* to have common WebDAV and HTTP headers validated, too.
     *
     * @return void
     *
     * @throws ezcWebdavMissingHeaderException
     *         if a required header is missing.
     * @throws ezcWebdavInvalidHeaderException
     *         if a header is present, but its content does not validate.
     */
    public function validateHeaders()
    {
        if ( !isset( $this->headers['DAV'] ) )
        {
            throw new ezcWebdavMissingHeaderException( 'DAV' );
        }
        $dav = array_map( 'trim', explode( ',', $this->headers['DAV'] ) );
        foreach ( $dav as $number )
        {
            if ( $number !== self::VERSION_ONE && $number !== self::VERSION_TWO && $number !== self::VERSION_ONE_EXTENDED )
            {
                throw new ezcWebdavInvalidHeaderException(
                    'DAV',
                    $this->headers['DAV'],
                    'Components must be ezcWebdavOptionsResponse::VERSION_ONE, ezcWebdavOptionsResponse::VERSION_TWO or ezcWebdavOptionsResponse::VERSION_ONE_EXTENDED'
                );
            }
        }
        // Unified spaces
        $this->headers['DAV'] = implode( ', ', $dav );
        
        // Validate common HTTP/WebDAV headers
        parent::validateHeaders();
    }
}

?>
