/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as f,nothing as p,html as c}from"lit";import{property as l,state as g,customElement as m}from"lit/decorators.js";import{BroadcastMessage as u}from"@typo3/backend/broadcast-message.js";import b from"@typo3/backend/broadcast-service.js";import{DataTransferTypes as v}from"@typo3/backend/enum/data-transfer-types.js";var s=function(h,t,e,i){var o=arguments.length,r=o<3?t:i===null?i=Object.getOwnPropertyDescriptor(t,e):i,n;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(h,t,e,i);else for(var d=h.length-1;d>=0;d--)(n=h[d])&&(r=(o<3?n(r):o>3?n(t,e,r):n(t,e))||r);return o>3&&r&&Object.defineProperty(t,e,r),r};let a=class extends f{constructor(){super(),this.active=!1,this.statusIconIdentifier="apps-pagetree-drag-move-into",this.tooltipIconIdentifier=null,this.thumbnails=[],this.visible=!1,this.posX=0,this.posY=0,this.dragAllowed=!1,this.skipNextUpdateBroadcast=!1,this.eventAbortController=null,this.updatePositionFromDragEvent=t=>{this.visible=!(t.clientX===0&&t.clientY===0);const e=this.calculateIframeOffset(t.view,window);this.posX=t.clientX+e.x,this.posY=t.clientY+e.y,this.visible&&this.broadcast("visible")},this.trackDragOverAllowed=t=>{this.dragAllowed=t.defaultPrevented},this.trackDragEnd=()=>{this.active=!1},this.trackDragStart=t=>{if(!t.defaultPrevented&&t.dataTransfer.types.includes(v.dragTooltip)){t.dataTransfer.setDragImage(this.ghostImage,0,0);const e=JSON.parse(t.dataTransfer.getData(v.dragTooltip));this.reset(),Object.assign(this,e),this.broadcast("visible")}},this.onMetadataUpdate=t=>{const e=t.detail;Object.assign(this,e)},this.onBroadcastVisible=()=>{this.visible=!1},this.onBroadcastChangedProperties=t=>{const e=t.detail.payload;Object.keys(e).forEach(i=>{this[i]=e[i]}),this.skipNextUpdateBroadcast=!0},this.onIframeLoaded=t=>{let e;try{e=t.target.querySelector("iframe")?.contentWindow}catch{return}if(e){this.eventAbortController?.abort(),this.eventAbortController=new AbortController;const{signal:i}=this.eventAbortController,o=!0,r=!0;e.addEventListener("dragover",this.updatePositionFromDragEvent,{capture:o,passive:r,signal:i}),e.addEventListener("dragover",this.trackDragOverAllowed,{passive:r,signal:i}),e.addEventListener("dragend",this.trackDragEnd,{capture:o,passive:r,signal:i}),e.addEventListener("dragstart",this.trackDragStart,{passive:r,signal:i})}},this.ghostImage=new Image,this.ghostImage.src="data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="}connectedCallback(){super.connectedCallback();const t=!0,e=!0;window.addEventListener("dragover",this.updatePositionFromDragEvent,{capture:t,passive:e}),window.addEventListener("dragover",this.trackDragOverAllowed,{passive:e}),window.addEventListener("dragend",this.trackDragEnd,{capture:t,passive:e}),window.addEventListener("dragstart",this.trackDragStart,{passive:e}),document.addEventListener("typo3:drag-tooltip:visible",this.onBroadcastVisible),document.addEventListener("typo3:drag-tooltip:changedProperties",this.onBroadcastChangedProperties),document.addEventListener("typo3:drag-tooltip:metadata-update",this.onMetadataUpdate),document.addEventListener("typo3-iframe-loaded",this.onIframeLoaded),this.eventAbortController?.abort(),this.eventAbortController=new AbortController}disconnectedCallback(){super.disconnectedCallback();const t=!0;window.removeEventListener("dragover",this.updatePositionFromDragEvent,{capture:t}),window.removeEventListener("dragover",this.trackDragOverAllowed),window.removeEventListener("dragend",this.trackDragEnd,{capture:t}),window.removeEventListener("dragstart",this.trackDragStart),document.removeEventListener("typo3:drag-tooltip:visible",this.onBroadcastVisible),document.removeEventListener("typo3:drag-tooltip:changedProperties",this.onBroadcastChangedProperties),document.removeEventListener("typo3:drag-tooltip:metadata-update",this.onMetadataUpdate),document.removeEventListener("typo3-iframe-loaded",this.onIframeLoaded),this.eventAbortController?.abort(),this.eventAbortController=null}reset(){this.active=!0,this.visible=!0,this.statusIconIdentifier="apps-pagetree-drag-move-into",this.tooltipIconIdentifier="",this.tooltipLabel="",this.tooltipDescription="",this.thumbnails=[],this.posX=0,this.posY=0,this.dragAllowed=!1}updated(t){if(this.skipNextUpdateBroadcast){this.skipNextUpdateBroadcast=!1;return}const e=[...t.keys()].filter(o=>this.constructor.elementProperties.get(o).attribute!==!1);if(e.length===0)return;const i=e.map(o=>[o,this[o]]);this.broadcast("changedProperties",Object.fromEntries(i))}broadcast(t,e){b.post(new u("drag-tooltip",t,e||{}))}calculateIframeOffset(t,e){let i=0,o=0;if(t===e)return{x:i,y:o};const r=this.calculateIframeOffset(t.parent,e);i+=r.x,o+=r.y;const n=t.frameElement;if(n){const d=n.getBoundingClientRect();i+=d.x,o+=d.y}return{x:i,y:o}}createRenderRoot(){return this}render(){return!this.active||!this.visible?p:this.posX===0&&this.posY===0?p:c`<div class=dragging-tooltip style=top:${this.posY+18+"px"};left:${this.posX+18+"px"}><div class=dragging-tooltip-control><typo3-backend-icon identifier=${this.dragAllowed?this.statusIconIdentifier??"actions-question":"actions-ban"} size=small></typo3-backend-icon></div><div class=dragging-tooltip-content><div class=dragging-tooltip-content-icon><typo3-backend-icon identifier=${this.tooltipIconIdentifier} size=small></typo3-backend-icon></div><div class=dragging-tooltip-content-label>${this.tooltipLabel!==""?c`<div class=dragging-tooltip-content-name>${this.tooltipLabel}</div>`:p} ${this.tooltipDescription!==""?c`<div class=dragging-tooltip-content-description>${this.tooltipDescription}</div>`:p}</div>${this.thumbnails.length===0?p:c`<div class=dragging-tooltip-thumbnails>${this.thumbnails.slice(0,3).map(t=>c`<img src=${t.src} width=${t.width} height=${t.height}>`)}</div>`}</div></div>`}};s([l({type:Boolean,reflect:!0})],a.prototype,"active",void 0),s([l({type:String,reflect:!0})],a.prototype,"statusIconIdentifier",void 0),s([l({type:String})],a.prototype,"tooltipIconIdentifier",void 0),s([l({type:String})],a.prototype,"tooltipLabel",void 0),s([l({type:String})],a.prototype,"tooltipDescription",void 0),s([l({type:Array})],a.prototype,"thumbnails",void 0),s([g()],a.prototype,"visible",void 0),s([g()],a.prototype,"posX",void 0),s([g()],a.prototype,"posY",void 0),s([g()],a.prototype,"dragAllowed",void 0),a=s([m("typo3-backend-drag-tooltip")],a);export{a as DragToolTip};
