/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatDST_1D {
    private int n;
    private FloatDCT_1D dct;

    public FloatDST_1D(int n) {
        this.n = n;
        this.dct = new FloatDCT_1D(n);
    }

    public FloatDST_1D(int n, int[] nArray, float[] fArray) {
        this.n = n;
        this.dct = new FloatDCT_1D(n, nArray, fArray);
    }

    public void forward(float[] fArray, boolean bl) {
        this.forward(fArray, 0, bl);
    }

    public void forward(final float[] fArray, final int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (this.n == 1) {
            return;
        }
        int n5 = ConcurrencyUtils.getNumberOfProcessors();
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n6;
            n4 = this.n / n5;
            Future[] futureArray = new Future[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                n3 = n + n6 * n4 + 1;
                n2 = n6 == n5 - 1 ? this.n : n3 + n4;
                futureArray[n6] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        if (FloatDST_1D.this.n >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                fArray[i] = -fArray[i];
                                fArray[i + 2] = -fArray[i + 2];
                            }
                        } else {
                            for (int i = n3; i < n2; i += 2) {
                                fArray[i] = -fArray[i];
                            }
                        }
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    futureArray[n6].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = 1 + n;
            int n7 = n + this.n;
            if (this.n >= 4) {
                for (int i = n4; i < n7; i += 4) {
                    fArray[i] = -fArray[i];
                    fArray[i + 2] = -fArray[i + 2];
                }
            } else {
                for (int i = n4; i < n7; i += 2) {
                    fArray[i] = -fArray[i];
                }
            }
        }
        this.dct.forward(fArray, n, bl);
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n8;
            n4 = this.n / 2 / n5;
            Future[] futureArray = new Future[n5];
            for (n8 = 0; n8 < n5; ++n8) {
                n3 = n + n8 * n4;
                n2 = n8 == n5 - 1 ? this.n / 2 : n3 + n4;
                futureArray[n8] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        int n4 = n + FloatDST_1D.this.n - 1;
                        if (FloatDST_1D.this.n / 2 >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                float f = fArray[i];
                                int n22 = n4 - i;
                                fArray[i] = fArray[n22];
                                fArray[n22] = f;
                                f = fArray[i + 1];
                                n22 = n4 - i - 1;
                                fArray[i + 1] = fArray[n22];
                                fArray[n22] = f;
                                f = fArray[i + 2];
                                n22 = n4 - i - 2;
                                fArray[i + 2] = fArray[n22];
                                fArray[n22] = f;
                                f = fArray[i + 3];
                                n22 = n4 - i - 3;
                                fArray[i + 3] = fArray[n22];
                                fArray[n22] = f;
                            }
                        } else {
                            for (int i = n3; i < n2; ++i) {
                                float f = fArray[i];
                                int n32 = n4 - i;
                                fArray[i] = fArray[n32];
                                fArray[n32] = f;
                            }
                        }
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n5; ++n8) {
                    futureArray[n8].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = n + this.n - 1;
            if (this.n / 2 >= 4) {
                for (int i = 0; i < this.n / 2; i += 4) {
                    float f = fArray[n + i];
                    fArray[n + i] = fArray[n4 - i];
                    fArray[n4 - i] = f;
                    f = fArray[n + i + 1];
                    fArray[n + i + 1] = fArray[n4 - i - 1];
                    fArray[n4 - i - 1] = f;
                    f = fArray[n + i + 2];
                    fArray[n + i + 2] = fArray[n4 - i - 2];
                    fArray[n4 - i - 2] = f;
                    f = fArray[n + i + 3];
                    fArray[n + i + 3] = fArray[n4 - i - 3];
                    fArray[n4 - i - 3] = f;
                }
            } else {
                for (int i = 0; i < this.n / 2; ++i) {
                    float f = fArray[n + i];
                    fArray[n + i] = fArray[n4 - i];
                    fArray[n4 - i] = f;
                }
            }
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(final float[] fArray, final int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (this.n == 1) {
            return;
        }
        int n5 = ConcurrencyUtils.getNumberOfProcessors();
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n6;
            n4 = this.n / 2 / n5;
            Future[] futureArray = new Future[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                n3 = n + n6 * n4;
                n2 = n6 == n5 - 1 ? this.n / 2 : n3 + n4;
                futureArray[n6] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        int n4 = n + FloatDST_1D.this.n - 1;
                        if (FloatDST_1D.this.n / 2 >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                float f = fArray[i];
                                int n22 = n4 - i;
                                fArray[i] = fArray[n22];
                                fArray[n22] = f;
                                f = fArray[i + 1];
                                n22 = n4 - i - 1;
                                fArray[i + 1] = fArray[n22];
                                fArray[n22] = f;
                                f = fArray[i + 2];
                                n22 = n4 - i - 2;
                                fArray[i + 2] = fArray[n22];
                                fArray[n22] = f;
                                f = fArray[i + 3];
                                n22 = n4 - i - 3;
                                fArray[i + 3] = fArray[n22];
                                fArray[n22] = f;
                            }
                        } else {
                            for (int i = n3; i < n2; ++i) {
                                float f = fArray[i];
                                int n32 = n4 - i;
                                fArray[i] = fArray[n32];
                                fArray[n32] = f;
                            }
                        }
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    futureArray[n6].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            float f;
            n4 = n + this.n - 1;
            if (this.n / 2 >= 4) {
                for (int i = 0; i < this.n / 2; i += 4) {
                    f = fArray[n + i];
                    fArray[n + i] = fArray[n4 - i];
                    fArray[n4 - i] = f;
                    f = fArray[n + i + 1];
                    fArray[n + i + 1] = fArray[n4 - i - 1];
                    fArray[n4 - i - 1] = f;
                    f = fArray[n + i + 2];
                    fArray[n + i + 2] = fArray[n4 - i - 2];
                    fArray[n4 - i - 2] = f;
                    f = fArray[n + i + 3];
                    fArray[n + i + 3] = fArray[n4 - i - 3];
                    fArray[n4 - i - 3] = f;
                }
            } else {
                for (int i = 0; i < this.n / 2; ++i) {
                    f = fArray[n + i];
                    fArray[n + i] = fArray[n4 - i];
                    fArray[n4 - i] = f;
                }
            }
        }
        this.dct.inverse(fArray, n, bl);
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n7;
            n4 = this.n / n5;
            Future[] futureArray = new Future[n5];
            for (n7 = 0; n7 < n5; ++n7) {
                n3 = n + n7 * n4 + 1;
                n2 = n7 == n5 - 1 ? this.n : n3 + n4;
                futureArray[n7] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        if (FloatDST_1D.this.n >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                fArray[i] = -fArray[i];
                                fArray[i + 2] = -fArray[i + 2];
                            }
                        } else {
                            for (int i = n3; i < n2; i += 2) {
                                fArray[i] = -fArray[i];
                            }
                        }
                    }
                });
            }
            try {
                for (n7 = 0; n7 < n5; ++n7) {
                    futureArray[n7].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = 1 + n;
            int n8 = n + this.n;
            if (this.n >= 4) {
                for (int i = n4; i < n8; i += 4) {
                    fArray[i] = -fArray[i];
                    fArray[i + 2] = -fArray[i + 2];
                }
            } else {
                for (int i = n4; i < n8; i += 2) {
                    fArray[i] = -fArray[i];
                }
            }
        }
    }
}

