/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.viewer.swing.LocalMouseCursorShape;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public class Utils {
    private static List<Image> icons;
    private static Map<LocalMouseCursorShape, Cursor> cursorCash;

    private static List<Image> getApplicationIcons() {
        Image image;
        if (icons != null) {
            return icons;
        }
        icons = new LinkedList<Image>();
        URL resource = Utils.class.getResource("/com/glavsoft/viewer/images/tightvnc-logo-16x16.png");
        Image image2 = image = resource != null ? Toolkit.getDefaultToolkit().getImage(resource) : null;
        if (image != null) {
            icons.add(image);
        }
        Image image3 = image = (resource = Utils.class.getResource("/com/glavsoft/viewer/images/tightvnc-logo-32x32.png")) != null ? Toolkit.getDefaultToolkit().getImage(resource) : null;
        if (image != null) {
            icons.add(image);
        }
        return icons;
    }

    public static ImageIcon getButtonIcon(String name) {
        URL resource = Utils.class.getResource("/com/glavsoft/viewer/images/button-" + name + ".png");
        return resource != null ? new ImageIcon(resource) : null;
    }

    public static Cursor getCursor(LocalMouseCursorShape cursorShape) {
        Image image;
        Cursor cursor = cursorCash.get((Object)cursorShape);
        if (cursor != null) {
            return cursor;
        }
        String name = cursorShape.getCursorName();
        URL resource = Utils.class.getResource("/com/glavsoft/viewer/images/cursor-" + name + ".png");
        if (resource != null && (image = Toolkit.getDefaultToolkit().getImage(resource)) != null) {
            final CountDownLatch done = new CountDownLatch(1);
            image.getWidth(new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    boolean isReady;
                    boolean bl = isReady = (infoflags & 0xA0) != 0;
                    if (isReady) {
                        done.countDown();
                    }
                    return !isReady;
                }
            });
            try {
                done.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return Cursor.getDefaultCursor();
            }
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (w < 0 || h < 0) {
                return Cursor.getDefaultCursor();
            }
            w = (int)(((double)w - 0.5) / 2.0);
            h = (int)(((double)h - 0.5) / 2.0);
            cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(w > 0 ? w : 0, h > 0 ? h : 0), name);
            if (cursor != null) {
                cursorCash.put(cursorShape, cursor);
            }
        }
        return cursor != null ? cursor : Cursor.getDefaultCursor();
    }

    public static void decorateDialog(Window dialog) {
        try {
            dialog.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        dialog.pack();
        if (dialog instanceof JDialog) {
            ((JDialog)dialog).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        }
        dialog.toFront();
        Utils.setApplicationIconsForWindow(dialog);
    }

    public static void setApplicationIconsForWindow(Window window) {
        List<Image> icons = Utils.getApplicationIcons();
        if (icons.size() != 0) {
            window.setIconImages(icons);
        }
    }

    public static void centerWindow(Window window) {
        Point locationPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Rectangle bounds = window.getBounds();
        locationPoint.setLocation(locationPoint.x - bounds.width / 2, locationPoint.y - bounds.height / 2);
        window.setLocation(locationPoint);
    }

    static {
        cursorCash = new HashMap<LocalMouseCursorShape, Cursor>();
    }
}

