/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.FontDeclaration;
import writer2latex.office.ListStyle;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.PageMaster;
import writer2latex.office.ParStyle;
import writer2latex.office.PropertySet;
import writer2latex.office.SectionStyle;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Misc;

public class WriterStyleCollection {
    private OfficeStyleFamily font = new OfficeStyleFamily(class$writer2latex$office$FontDeclaration == null ? (class$writer2latex$office$FontDeclaration = WriterStyleCollection.class$("writer2latex.office.FontDeclaration")) : class$writer2latex$office$FontDeclaration);
    private OfficeStyleFamily text = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily par = new OfficeStyleFamily(class$writer2latex$office$ParStyle == null ? (class$writer2latex$office$ParStyle = WriterStyleCollection.class$("writer2latex.office.ParStyle")) : class$writer2latex$office$ParStyle);
    private OfficeStyleFamily section = new OfficeStyleFamily(class$writer2latex$office$SectionStyle == null ? (class$writer2latex$office$SectionStyle = WriterStyleCollection.class$("writer2latex.office.SectionStyle")) : class$writer2latex$office$SectionStyle);
    private OfficeStyleFamily table = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily column = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily row = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily cell = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily frame = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily list = new OfficeStyleFamily(class$writer2latex$office$ListStyle == null ? (class$writer2latex$office$ListStyle = WriterStyleCollection.class$("writer2latex.office.ListStyle")) : class$writer2latex$office$ListStyle);
    private OfficeStyleFamily pageMaster = new OfficeStyleFamily(class$writer2latex$office$PageMaster == null ? (class$writer2latex$office$PageMaster = WriterStyleCollection.class$("writer2latex.office.PageMaster")) : class$writer2latex$office$PageMaster);
    private OfficeStyleFamily masterPage = new OfficeStyleFamily(class$writer2latex$office$MasterPage == null ? (class$writer2latex$office$MasterPage = WriterStyleCollection.class$("writer2latex.office.MasterPage")) : class$writer2latex$office$MasterPage);
    private String sFirstMasterPageName = null;
    private ListStyle outline = new ListStyle();
    private PropertySet footnotes = null;
    private PropertySet endnotes = null;
    static /* synthetic */ Class class$writer2latex$office$FontDeclaration;
    static /* synthetic */ Class class$writer2latex$office$StyleWithProperties;
    static /* synthetic */ Class class$writer2latex$office$ParStyle;
    static /* synthetic */ Class class$writer2latex$office$SectionStyle;
    static /* synthetic */ Class class$writer2latex$office$ListStyle;
    static /* synthetic */ Class class$writer2latex$office$PageMaster;
    static /* synthetic */ Class class$writer2latex$office$MasterPage;

    public OfficeStyleFamily getFontDeclarations() {
        return this.font;
    }

    public FontDeclaration getFontDeclaration(String sName) {
        return (FontDeclaration)this.font.getStyle(sName);
    }

    public OfficeStyleFamily getTextStyles() {
        return this.text;
    }

    public StyleWithProperties getTextStyle(String sName) {
        return (StyleWithProperties)this.text.getStyle(sName);
    }

    public OfficeStyleFamily getParStyles() {
        return this.par;
    }

    public ParStyle getParStyle(String sName) {
        return (ParStyle)this.par.getStyle(sName);
    }

    public ParStyle getDefaultParStyle() {
        return (ParStyle)this.par.getDefaultStyle();
    }

    public OfficeStyleFamily getSectionStyles() {
        return this.section;
    }

    public SectionStyle getSectionStyle(String sName) {
        return (SectionStyle)this.section.getStyle(sName);
    }

    public OfficeStyleFamily getTableStyles() {
        return this.table;
    }

    public StyleWithProperties getTableStyle(String sName) {
        return (StyleWithProperties)this.table.getStyle(sName);
    }

    public OfficeStyleFamily getColumnStyles() {
        return this.column;
    }

    public StyleWithProperties getColumnStyle(String sName) {
        return (StyleWithProperties)this.column.getStyle(sName);
    }

    public OfficeStyleFamily getRowStyles() {
        return this.row;
    }

    public StyleWithProperties getRowStyle(String sName) {
        return (StyleWithProperties)this.row.getStyle(sName);
    }

    public OfficeStyleFamily getCellStyles() {
        return this.cell;
    }

    public StyleWithProperties getCellStyle(String sName) {
        return (StyleWithProperties)this.cell.getStyle(sName);
    }

    public StyleWithProperties getDefaultCellStyle() {
        return (StyleWithProperties)this.cell.getDefaultStyle();
    }

    public OfficeStyleFamily getFrameStyles() {
        return this.frame;
    }

    public StyleWithProperties getFrameStyle(String sName) {
        return (StyleWithProperties)this.frame.getStyle(sName);
    }

    public StyleWithProperties getDefaultFrameStyle() {
        return (StyleWithProperties)this.frame.getDefaultStyle();
    }

    public OfficeStyleFamily getListStyles() {
        return this.list;
    }

    public ListStyle getListStyle(String sName) {
        return (ListStyle)this.list.getStyle(sName);
    }

    public OfficeStyleFamily getPageMasters() {
        return this.pageMaster;
    }

    public PageMaster getPageMaster(String sName) {
        return (PageMaster)this.pageMaster.getStyle(sName);
    }

    public OfficeStyleFamily getMasterPages() {
        return this.masterPage;
    }

    public MasterPage getMasterPage(String sName) {
        return (MasterPage)this.masterPage.getStyle(sName);
    }

    public String getFirstMasterPageName() {
        return this.sFirstMasterPageName;
    }

    public ListStyle getOutlineStyle() {
        return this.outline;
    }

    public PropertySet getFootnotesConfiguration() {
        return this.footnotes;
    }

    public PropertySet getEndnotesConfiguration() {
        return this.endnotes;
    }

    private void loadStylesFromDOM(Node node, boolean bAllParagraphsAreSoft) {
        boolean bAutomatic = "office:automatic-styles".equals(node.getNodeName());
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nl.item(i);
                if (child.getNodeType() == 1) {
                    String sFamily;
                    if (child.getNodeName().equals("style:style")) {
                        sFamily = Misc.getAttribute(child, "style:family");
                        if ("text".equals(sFamily)) {
                            this.text.loadStyleFromDOM(child, bAutomatic);
                        } else if ("paragraph".equals(sFamily)) {
                            this.par.loadStyleFromDOM(child, bAutomatic && !bAllParagraphsAreSoft);
                        } else if ("section".equals(sFamily)) {
                            this.section.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table".equals(sFamily)) {
                            this.table.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table-column".equals(sFamily)) {
                            this.column.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table-row".equals(sFamily)) {
                            this.row.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table-cell".equals(sFamily)) {
                            this.cell.loadStyleFromDOM(child, bAutomatic);
                        } else if ("graphics".equals(sFamily)) {
                            this.frame.loadStyleFromDOM(child, bAutomatic);
                        }
                    } else if (child.getNodeName().equals("style:page-master")) {
                        this.pageMaster.loadStyleFromDOM(child, bAutomatic);
                    } else if (child.getNodeName().equals("style:master-page")) {
                        this.masterPage.loadStyleFromDOM(child, bAutomatic);
                        if (this.sFirstMasterPageName == null) {
                            this.sFirstMasterPageName = Misc.getAttribute(child, "style:name");
                        }
                    } else if (child.getNodeName().equals("text:list-style")) {
                        this.list.loadStyleFromDOM(child, bAutomatic);
                    } else if (child.getNodeName().equals("text:outline-style")) {
                        this.outline.loadStyleFromDOM(child);
                    } else if (child.getNodeName().equals("style:default-style")) {
                        sFamily = Misc.getAttribute(child, "style:family");
                        if ("paragraph".equals(sFamily)) {
                            ParStyle defaultPar = new ParStyle();
                            defaultPar.loadStyleFromDOM(child);
                            this.par.setDefaultStyle(defaultPar);
                        } else if ("graphics".equals(sFamily)) {
                            StyleWithProperties defaultFrame = new StyleWithProperties();
                            defaultFrame.loadStyleFromDOM(child);
                            this.frame.setDefaultStyle(defaultFrame);
                        } else if ("table-cell".equals(sFamily)) {
                            StyleWithProperties defaultCell = new StyleWithProperties();
                            defaultCell.loadStyleFromDOM(child);
                            this.cell.setDefaultStyle(defaultCell);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void loadStylesFromDOM(Document stylesDOM, Document contentDOM) {
        this.loadStylesFromDOM(stylesDOM, contentDOM, false);
    }

    public void loadStylesFromDOM(Document stylesDOM, Document contentDOM, boolean bAllParagraphsAreSoft) {
        Node node;
        NodeList list = stylesDOM == null ? contentDOM.getElementsByTagName("office:font-decls") : stylesDOM.getElementsByTagName("office:font-decls");
        if (list.getLength() != 0 && (node = list.item(0)).hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nl.item(i);
                if (child.getNodeType() == 1 && child.getNodeName().equals("style:font-decl")) {
                    this.font.loadStyleFromDOM(child, false);
                }
                ++i;
            }
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("office:styles") : stylesDOM.getElementsByTagName("office:styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("office:master-styles") : stylesDOM.getElementsByTagName("office:master-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if (stylesDOM != null && (list = stylesDOM.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = contentDOM.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("text:footnotes-configuration") : stylesDOM.getElementsByTagName("text:footnotes-configuration")).getLength() != 0) {
            this.footnotes = new PropertySet();
            this.footnotes.loadFromDOM(list.item(0));
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("text:endnotes-configuration") : stylesDOM.getElementsByTagName("text:endnotes-configuration")).getLength() != 0) {
            this.endnotes = new PropertySet();
            this.endnotes.loadFromDOM(list.item(0));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

