/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.DocumentSerializerImpl;

public class MathConverter
extends ConverterHelper {
    private boolean bSupportMathML;

    public MathConverter(WriterStyleCollection wsc, Config config, DocumentSerializerImpl converter, boolean bSupportMathML) {
        super(wsc, config, converter);
        this.bSupportMathML = bSupportMathML;
    }

    public void convert(Node onode, Node hnode) {
        if (this.bSupportMathML) {
            this.convertNode(onode, hnode);
        } else {
            Document htmlDOM = hnode.getOwnerDocument();
            NodeList annotationList = ((Element)onode).getElementsByTagName("math:annotation");
            if (annotationList.getLength() > 0 && annotationList.item(0).hasChildNodes()) {
                Element kbd = htmlDOM.createElement("kbd");
                hnode.appendChild(kbd);
                NodeList list = annotationList.item(0).getChildNodes();
                int nLen = list.getLength();
                int i = 0;
                while (i < nLen) {
                    Node child = list.item(i);
                    if (child.getNodeType() == 3) {
                        kbd.appendChild(htmlDOM.createTextNode(child.getNodeValue()));
                    }
                    ++i;
                }
            } else {
                hnode.appendChild(htmlDOM.createTextNode("[Warning: formula ignored]"));
            }
        }
    }

    public void convertNode(Node onode, Node hnode) {
        if (onode.getNodeType() == 1) {
            if (onode.getNodeName().equals("math:semantics")) {
                this.convertNodeList(onode.getChildNodes(), hnode);
            } else if (!onode.getNodeName().equals("math:annotation")) {
                String sElementName = this.stripNamespace(onode.getNodeName());
                Element newNode = hnode.getOwnerDocument().createElement(sElementName);
                hnode.appendChild(newNode);
                if (onode.hasAttributes()) {
                    NamedNodeMap attr = onode.getAttributes();
                    int nLen = attr.getLength();
                    int i = 0;
                    while (i < nLen) {
                        String sName = attr.item(i).getNodeName();
                        sName = sName.equals("xmlns:math") ? "xmlns" : this.stripNamespace(sName);
                        String sValue = attr.item(i).getNodeValue();
                        newNode.setAttribute(sName, this.replacePrivateChars(sValue));
                        ++i;
                    }
                }
                this.convertNodeList(onode.getChildNodes(), newNode);
            }
        } else if (onode.getNodeType() == 3) {
            String s = this.replacePrivateChars(onode.getNodeValue());
            hnode.appendChild(hnode.getOwnerDocument().createTextNode(s));
        }
    }

    private void convertNodeList(NodeList list, Node hnode) {
        if (list == null) {
            return;
        }
        int nLen = list.getLength();
        int i = 0;
        while (i < nLen) {
            this.convertNode(list.item(i), hnode);
            ++i;
        }
    }

    private String stripNamespace(String s) {
        int nPos = s.indexOf(58);
        return s.substring(nPos + 1);
    }

    private String replacePrivateChars(String s) {
        int nLen = s.length();
        StringBuffer buf = new StringBuffer(nLen);
        int i = 0;
        while (i < nLen) {
            buf.append(this.replacePrivateChar(s.charAt(i)));
            ++i;
        }
        return buf.toString();
    }

    private char replacePrivateChar(char c) {
        switch (c) {
            case '\ue002': {
                return '\u2666';
            }
            case '\ue003': {
                return '\u25c6';
            }
            case '\ue005': {
                return '\u274d';
            }
            case '\ue006': {
                return '\u2794';
            }
            case '\ue007': {
                return '\u2713';
            }
            case '\ue008': {
                return '\u25cf';
            }
            case '\ue009': {
                return '\u274d';
            }
            case '\ue00a': {
                return '\u25fc';
            }
            case '\ue00b': {
                return '\u2752';
            }
            case '\ue00d': {
                return '\u2756';
            }
            case '\ue013': {
                return '\u2742';
            }
            case '\ue01b': {
                return '\u270d';
            }
            case '\ue01e': {
                return '\u2022';
            }
            case '\ue021': {
                return '\u00a9';
            }
            case '\ue024': {
                return '\u00ae';
            }
            case '\ue025': {
                return '\u21e8';
            }
            case '\ue026': {
                return '\u21e9';
            }
            case '\ue027': {
                return '\u21e6';
            }
            case '\ue028': {
                return '\u21e7';
            }
            case '\ue02b': {
                return '\u279e';
            }
            case '\ue032': {
                return '\u2741';
            }
            case '\ue036': {
                return '(';
            }
            case '\ue037': {
                return ')';
            }
            case '\ue03a': {
                return '\u20ac';
            }
            case '\ue080': {
                return '\u2030';
            }
            case '\ue081': {
                return '\ufe38';
            }
            case '\ue082': {
                return '\ufe37';
            }
            case '\ue083': {
                return '+';
            }
            case '\ue084': {
                return '<';
            }
            case '\ue085': {
                return '>';
            }
            case '\ue086': {
                return '\u2264';
            }
            case '\ue087': {
                return '\u2265';
            }
            case '\ue089': {
                return '\u2208';
            }
            case '\ue08b': {
                return '\u2026';
            }
            case '\ue08c': {
                return '\u2192';
            }
            case '\ue090': {
                return '\u2225';
            }
            case '\ue091': {
                return '^';
            }
            case '\ue092': {
                return '\u02c7';
            }
            case '\ue093': {
                return '\u02d8';
            }
            case '\ue094': {
                return '\u00b4';
            }
            case '\ue095': {
                return '`';
            }
            case '\ue096': {
                return '\u02dc';
            }
            case '\ue097': {
                return '\u00af';
            }
            case '\ue098': {
                return '\u2192';
            }
            case '\ue09b': {
                return '\u20db';
            }
            case '\ue09e': {
                return '(';
            }
            case '\ue09f': {
                return ')';
            }
            case '\ue0a0': {
                return '\u2221';
            }
            case '\ue0aa': {
                return '\u2751';
            }
            case '\ue0ac': {
                return '\u0393';
            }
            case '\ue0ad': {
                return '\u0394';
            }
            case '\ue0ae': {
                return '\u0398';
            }
            case '\ue0af': {
                return '\u039b';
            }
            case '\ue0b0': {
                return '\u039e';
            }
            case '\ue0b1': {
                return '\u03a0';
            }
            case '\ue0b2': {
                return '\u03a3';
            }
            case '\ue0b3': {
                return '\u03a5';
            }
            case '\ue0b4': {
                return '\u03a6';
            }
            case '\ue0b5': {
                return '\u03a8';
            }
            case '\ue0b6': {
                return '\u03a9';
            }
            case '\ue0b7': {
                return '\u03b1';
            }
            case '\ue0b8': {
                return '\u03b2';
            }
            case '\ue0b9': {
                return '\u03b3';
            }
            case '\ue0ba': {
                return '\u03b4';
            }
            case '\ue0bb': {
                return '\u03f5';
            }
            case '\ue0bc': {
                return '\u03b6';
            }
            case '\ue0bd': {
                return '\u03b7';
            }
            case '\ue0be': {
                return '\u03b8';
            }
            case '\ue0bf': {
                return '\u03b9';
            }
            case '\ue0c0': {
                return '\u03ba';
            }
            case '\ue0c1': {
                return '\u03bb';
            }
            case '\ue0c2': {
                return '\u03bc';
            }
            case '\ue0c3': {
                return '\u03bd';
            }
            case '\ue0c4': {
                return '\u03be';
            }
            case '\ue0c5': {
                return '\u03bf';
            }
            case '\ue0c6': {
                return '\u03c0';
            }
            case '\ue0c7': {
                return '\u03c1';
            }
            case '\ue0c8': {
                return '\u03c3';
            }
            case '\ue0c9': {
                return '\u03c4';
            }
            case '\ue0ca': {
                return '\u03c5';
            }
            case '\ue0cb': {
                return '\u03d5';
            }
            case '\ue0cc': {
                return '\u03c7';
            }
            case '\ue0cd': {
                return '\u03c8';
            }
            case '\ue0ce': {
                return '\u03c9';
            }
            case '\ue0cf': {
                return '\u03b5';
            }
            case '\ue0d0': {
                return '\u03d1';
            }
            case '\ue0d1': {
                return '\u03d6';
            }
            case '\ue0d3': {
                return '\u03c2';
            }
            case '\ue0d4': {
                return '\u03c6';
            }
            case '\ue0d5': {
                return '\u2202';
            }
            case '\ue0d9': {
                return '\u22a4';
            }
            case '\ue0db': {
                return '\u2190';
            }
            case '\ue0dc': {
                return '\u2191';
            }
            case '\ue0dd': {
                return '\u2193';
            }
        }
        return c;
    }
}

