/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.util.JdwpString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Value {
    public static void writeUntaggedValue(DataOutputStream dataOutputStream, Object object) throws JdwpException, IOException {
        Value.writeValue(dataOutputStream, object, false);
    }

    public static void writeTaggedValue(DataOutputStream dataOutputStream, Object object) throws JdwpException, IOException {
        Value.writeValue(dataOutputStream, object, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void writeValue(DataOutputStream dataOutputStream, Object object, boolean bl) throws IOException, JdwpException {
        Class clazz = object.getClass();
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                if (bl) {
                    dataOutputStream.writeByte(66);
                }
                dataOutputStream.writeByte(((Byte)object).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                if (bl) {
                    dataOutputStream.writeByte(67);
                }
                dataOutputStream.writeChar(((Character)object).charValue());
                return;
            } else if (clazz == Float.TYPE) {
                if (bl) {
                    dataOutputStream.writeByte(70);
                }
                dataOutputStream.writeFloat(((Float)object).floatValue());
                return;
            } else if (clazz == Double.TYPE) {
                if (bl) {
                    dataOutputStream.writeByte(68);
                }
                dataOutputStream.writeDouble((Double)object);
                return;
            } else if (clazz == Integer.TYPE) {
                if (bl) {
                    dataOutputStream.writeByte(66);
                }
                dataOutputStream.writeInt((Integer)object);
                return;
            } else if (clazz == Long.TYPE) {
                if (bl) {
                    dataOutputStream.writeByte(74);
                }
                dataOutputStream.writeLong((Long)object);
                return;
            } else if (clazz == Short.TYPE) {
                if (bl) {
                    dataOutputStream.writeByte(83);
                }
                dataOutputStream.writeInt(((Short)object).shortValue());
                return;
            } else if (clazz == Void.TYPE) {
                if (!bl) return;
                dataOutputStream.writeByte(86);
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new JdwpInternalErrorException("Field has invalid primitive!");
                if (bl) {
                    dataOutputStream.writeByte(90);
                }
                dataOutputStream.writeBoolean((Boolean)object);
            }
            return;
        } else {
            if (bl) {
                if (clazz.isArray()) {
                    dataOutputStream.writeByte(91);
                } else if (object instanceof String) {
                    dataOutputStream.writeByte(115);
                } else if (object instanceof Thread) {
                    dataOutputStream.writeByte(116);
                } else if (object instanceof ThreadGroup) {
                    dataOutputStream.writeByte(103);
                } else if (object instanceof ClassLoader) {
                    dataOutputStream.writeByte(108);
                } else if (object instanceof Class) {
                    dataOutputStream.writeByte(99);
                } else {
                    dataOutputStream.writeByte(76);
                }
            }
            ObjectId objectId = VMIdManager.getDefault().getObjectId(object);
            objectId.write(dataOutputStream);
        }
    }

    public static Object getObj(ByteBuffer byteBuffer) throws JdwpException, IOException {
        return Value.getUntaggedObj(byteBuffer, byteBuffer.get());
    }

    public static Object getUntaggedObj(ByteBuffer byteBuffer, Class clazz) throws JdwpException, IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                return new Byte(byteBuffer.get());
            }
            if (clazz == Character.TYPE) {
                return new Character(byteBuffer.getChar());
            }
            if (clazz == Float.TYPE) {
                return new Float(byteBuffer.getFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(byteBuffer.getDouble());
            }
            if (clazz == Integer.TYPE) {
                return new Integer(byteBuffer.getInt());
            }
            if (clazz == Long.TYPE) {
                return new Long(byteBuffer.getLong());
            }
            if (clazz == Short.TYPE) {
                return new Short(byteBuffer.getShort());
            }
            if (clazz == Boolean.TYPE) {
                return byteBuffer.get() == 0 ? new Boolean(false) : new Boolean(true);
            }
            if (clazz == Void.TYPE) {
                return new byte[0];
            }
            throw new JdwpInternalErrorException("Field has invalid primitive!");
        }
        ObjectId objectId = VMIdManager.getDefault().readObjectId(byteBuffer);
        return objectId.getObject();
    }

    public static Object getUntaggedObj(ByteBuffer byteBuffer, byte by) throws JdwpException, IOException {
        switch (by) {
            case 66: {
                return new Byte(byteBuffer.get());
            }
            case 67: {
                return new Character(byteBuffer.getChar());
            }
            case 70: {
                return new Float(byteBuffer.getFloat());
            }
            case 68: {
                return new Double(byteBuffer.getDouble());
            }
            case 73: {
                return new Integer(byteBuffer.getInt());
            }
            case 74: {
                return new Long(byteBuffer.getLong());
            }
            case 83: {
                return new Short(byteBuffer.getShort());
            }
            case 86: {
                return new byte[0];
            }
            case 90: {
                return byteBuffer.get() == 0 ? new Boolean(false) : new Boolean(true);
            }
            case 115: {
                return JdwpString.readString(byteBuffer);
            }
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 116: {
                ObjectId objectId = VMIdManager.getDefault().readObjectId(byteBuffer);
                return objectId.getObject();
            }
        }
        throw new NotImplementedException("Tag " + by + " is not implemented.");
    }
}

