/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        if (colorSpace == null || nArray == null || nArray2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("array lengths differ");
        }
        if (nArray2.length != colorSpace.getNumComponents() + bl) {
            throw new IllegalArgumentException("invalid bankOffsets length");
        }
        return new ImageTypeSpecifier(new ComponentColorModel(colorSpace, bl, bl2, bl ? 3 : 1, n), new BandedSampleModel(n, 1, 1, 1, nArray, nArray2));
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("dimension <= 0");
        }
        if (n * n2 < Math.min(n, n2)) {
            throw new IllegalArgumentException("width * height > Integer.MAX_VALUE");
        }
        if (n * n2 * this.sampleModel.getNumBands() < Math.min(n, n2)) {
            throw new IllegalArgumentException("storage required > Integer.MAX_VALUE");
        }
        return new BufferedImage(n, n2, 1);
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n) {
        if (n <= 0 || n > 13) {
            throw new IllegalArgumentException("invalid buffered image type");
        }
        return new ImageTypeSpecifier(new BufferedImage(1, 1, n));
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image null");
        }
        return new ImageTypeSpecifier(renderedImage);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl) {
        return ImageTypeSpecifier.createGrayscale(n, n2, bl, false);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl, boolean bl2) {
        if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException("invalid bit size");
        }
        if (n2 != 0 && n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("invalid data type");
        }
        if (n2 == 0 && n > 8) {
            throw new IllegalArgumentException("number of bits too large for data type");
        }
        return new ImageTypeSpecifier(new DirectColorModel(n, 255, 0, 0, 255), new MultiPixelPackedSampleModel(n2, 1, 1, n));
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
        if (byArray == null || byArray2 == null || byArray3 == null) {
            throw new IllegalArgumentException("null colour table");
        }
        if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException("invalid bit size");
        }
        if (n2 != 0 && n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("invalid data type");
        }
        if (n2 == 0 && n > 8) {
            throw new IllegalArgumentException("number of bits too large for data type");
        }
        return new ImageTypeSpecifier(new IndexColorModel(n, byArray.length, byArray, byArray2, byArray3, byArray4), new MultiPixelPackedSampleModel(n2, 1, 1, n));
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
        if (colorSpace == null || nArray == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (nArray.length != colorSpace.getNumComponents() + bl) {
            throw new IllegalArgumentException("invalid bankOffsets length");
        }
        return new ImageTypeSpecifier(new ComponentColorModel(colorSpace, bl, bl2, bl ? 3 : 1, n), new PixelInterleavedSampleModel(n, 1, 1, 1, 1, nArray));
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (colorSpace == null) {
            throw new IllegalArgumentException("null color space");
        }
        if (colorSpace.getType() != 5) {
            throw new IllegalArgumentException("invalid color space type");
        }
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            throw new IllegalArgumentException("no non-zero mask");
        }
        if (n5 != 0 && n5 != 1 && n5 != 3) {
            throw new IllegalArgumentException("invalid data type");
        }
        int n6 = 8;
        if (n5 == 2) {
            n6 = 16;
        } else if (n5 == 3) {
            n6 = 32;
        }
        return new ImageTypeSpecifier(new DirectColorModel(colorSpace, n6, n, n2, n3, n4, bl, n5), new MultiPixelPackedSampleModel(n5, 1, 1, n6));
    }

    public int getBitsPerBand(int n) {
        if (n < 0 || n > this.sampleModel.getNumBands()) {
            throw new IllegalArgumentException("band out-of-bounds");
        }
        return this.sampleModel.getSampleSize(n);
    }

    public int getBufferedImageType() {
        return 1;
    }

    public SampleModel getSampleModel(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("invalid dimension");
        }
        if (n * n2 < Math.min(n, n2)) {
            throw new IllegalArgumentException("width * height > Integer.MAX_VALUE");
        }
        return this.sampleModel.createCompatibleSampleModel(n, n2);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public int getNumBands() {
        return this.sampleModel.getNumBands();
    }

    public int getNumComponents() {
        return this.colorModel.getNumComponents();
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
        if (colorModel == null) {
            throw new IllegalArgumentException("colorModel may not be null");
        }
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel may not be null");
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            throw new IllegalArgumentException("sample Model not compatible with colorModel");
        }
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public ImageTypeSpecifier(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.colorModel = renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
    }
}

