//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef D310_TRK_HDR_TYPE_H
#define D310_TRK_HDR_TYPE_H

#include "trk_hdr_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

// garmin d310 track header type class
class D310_Trk_Hdr_Type : public Trk_Hdr_Type, Constants
{
   public:
      virtual ~D310_Trk_Hdr_Type(){};

		virtual void clear(void);

      /// set data by garmin-packet 
      virtual void set(Packet);

      /// return a garmin packet to send it to a gamin gps 
      virtual Packet makePacket(void);

 
  protected:

  private:
      g_boolean dspl; /* display on the map? */             //   byte    0   
      g_byte color; /* color (same as D108) */                //         1
      #define SIZETRKIDENT 51
      char trk_ident[SIZETRKIDENT];  /*   null-terminated string */   //         2-53
};

}
#endif 
