/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int value) throws IOException {
        this.out.write(value);
        ++this.written;
    }

    public synchronized void write(byte[] buf, int offset, int len) throws IOException {
        this.out.write(buf, offset, len);
        this.written += len;
    }

    public final void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public final void writeByte(int value) throws IOException {
        this.write(value & 0xFF);
    }

    public final synchronized void writeShort(int value) throws IOException {
        this.write((byte)(0xFF & value >> 8));
        this.write((byte)(0xFF & value));
    }

    public final synchronized void writeChar(int value) throws IOException {
        this.write((byte)(0xFF & value >> 8));
        this.write((byte)(0xFF & value));
    }

    public final synchronized void writeInt(int value) throws IOException {
        this.write((byte)(0xFF & value >> 24));
        this.write((byte)(0xFF & value >> 16));
        this.write((byte)(0xFF & value >> 8));
        this.write((byte)(0xFF & value));
    }

    public final synchronized void writeLong(long value) throws IOException {
        this.write((byte)(0xFFL & value >> 56));
        this.write((byte)(0xFFL & value >> 48));
        this.write((byte)(0xFFL & value >> 40));
        this.write((byte)(0xFFL & value >> 32));
        this.write((byte)(0xFFL & value >> 24));
        this.write((byte)(0xFFL & value >> 16));
        this.write((byte)(0xFFL & value >> 8));
        this.write((byte)(0xFFL & value));
    }

    public final void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public final void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public final void writeBytes(String value) throws IOException {
        int len = value.length();
        int i = 0;
        while (i < len) {
            this.writeByte(value.charAt(i));
            ++i;
        }
    }

    public final void writeChars(String value) throws IOException {
        int len = value.length();
        int i = 0;
        while (i < len) {
            this.writeChar(value.charAt(i));
            ++i;
        }
    }

    public final synchronized void writeUTF(String value) throws IOException {
        int len = value.length();
        int sum = 0;
        int i = 0;
        while (i < len && sum <= (int)-1) {
            char c = value.charAt(i);
            sum = c >= '\u0001' && c <= '\u007f' ? ++sum : (c == '\u0000' || c >= '\u0080' && c <= '\u07ff' ? (sum += 2) : (sum += 3));
            ++i;
        }
        if (sum > (char)-1) {
            throw new UTFDataFormatException();
        }
        int pos = 0;
        byte[] buf = new byte[sum];
        int i2 = 0;
        while (i2 < len) {
            char c = value.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                buf[pos++] = (byte)c;
            } else if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                buf[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                buf[pos++] = (byte)(0x80 | 0x3F & c);
            } else {
                buf[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                buf[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                buf[pos++] = (byte)(0x80 | 0x3F & c);
            }
            ++i2;
        }
        this.writeShort(sum);
        this.write(buf, 0, sum);
    }

    public DataOutputStream(OutputStream out) {
        super(out);
    }
}

