/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.UIUtilities;

public class ChromosomeComboBox
extends JComboBox {
    public ChromosomeComboBox() {
        this.addActionListener(evt -> this.chromosomeComboBoxActionPerformed(evt));
    }

    private void chromosomeComboBoxActionPerformed(ActionEvent evt) {
        JComboBox combobox = (JComboBox)evt.getSource();
        String chrName = (String)combobox.getSelectedItem();
        if (chrName != null & !chrName.equals(FrameManager.getDefaultFrame().getChrName())) {
            FrameManager.getDefaultFrame().changeChromosome(chrName, true);
        }
    }

    public void updateChromosFromGenome(Genome genome) {
        if (genome == null) {
            return;
        }
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            String homeChr;
            ArrayList<String> tmp = new ArrayList<String>(genome.getAllChromosomeNames().size());
            tmp.addAll(genome.getAllChromosomeNames());
            if (tmp.size() > 1 && (homeChr = genome.getHomeChromosome()).equals("All")) {
                tmp.add(0, "All");
            }
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int w = 120;
            for (String chromosomeName : tmp) {
                int width;
                Rectangle2D textBounds = fontMetrics.getStringBounds(chromosomeName, graphics2D);
                if (textBounds == null || (width = textBounds.getBounds().width + 50) <= w) continue;
                w = width;
            }
            Object[] chomosomeNames = tmp.toArray();
            DefaultComboBoxModel<Object> defaultModel = new DefaultComboBoxModel<Object>(chomosomeNames);
            int dropdownWidth = w;
            this.setModel(defaultModel);
            this.setSelectedItem(genome.getHomeChromosome());
            this.adjustChromosomeDropdownWidth(dropdownWidth);
        });
    }

    private void adjustChromosomeDropdownWidth(int width) {
        int newWidth = width > 120 ? width : 120;
        this.setMaximumSize(new Dimension(newWidth, 35));
        this.setMinimumSize(new Dimension(newWidth, 27));
        this.setPreferredSize(new Dimension(newWidth, 16));
        this.revalidate();
    }
}

