/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import java.util.ArrayList;
import java.util.List;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.ReferenceIterator;

public class SRAUtils {
    public static final int REFERENCE_ALIGNMENT = 5000;

    public static long getNumberOfReads(ReadCollection run) throws ErrorMsg {
        return run.getReadCount(7);
    }

    public static List<Long> getReferencesLengthsAligned(ReadCollection run) throws ErrorMsg {
        ReferenceIterator refIt = run.getReferences();
        ArrayList<Long> lengths = new ArrayList<Long>();
        while (refIt.nextReference()) {
            long refLen = refIt.getLength();
            if (refLen % 5000L != 0L) {
                refLen += 5000L - refLen % 5000L;
            }
            lengths.add(refLen);
        }
        return lengths;
    }
}

