/*
 * Decompiled with CFR 0.152.
 */
package estraier.pure;

import estraier.pure.Condition;
import estraier.pure.Document;
import estraier.pure.NodeResult;
import estraier.pure.ResultDocument;
import estraier.pure.Utility;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Node {
    private String url = null;
    private String pxhost = null;
    private int pxport = -1;
    private int timeout = -1;
    private String auth = null;
    private String name = null;
    private String label = null;
    private int dnum = -1;
    private int wnum = -1;
    private double size = -1.0;
    private List admins = null;
    private List users = null;
    private List links = null;
    private int wwidth = 480;
    private int hwidth = 96;
    private int awidth = 96;
    private int status = -1;

    private static final String cond_to_query(Condition condition, int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n5;
            String string = condition.phrase();
            stringBuffer.append("phrase=");
            if (string != null) {
                stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
            }
            List list = condition.attrs();
            Iterator iterator = condition.attrs().iterator();
            int n6 = 1;
            while (iterator.hasNext()) {
                stringBuffer.append("&attr");
                stringBuffer.append(n6);
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode((String)iterator.next(), "UTF-8"));
                ++n6;
            }
            String string2 = condition.order();
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append("&order=");
                stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            }
            if ((n5 = condition.max()) >= 0) {
                stringBuffer.append("&max=");
                stringBuffer.append(n5);
            } else {
                stringBuffer.append("&max=");
                stringBuffer.append(0x3FFFFFFF);
            }
            int n7 = condition.options();
            if (n7 > 0) {
                stringBuffer.append("&options=");
                stringBuffer.append(n7);
            }
            int n8 = condition.auxiliary();
            stringBuffer.append("&auxiliary=");
            stringBuffer.append(n8);
            String string3 = condition.distinct();
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append("&distinct=");
                stringBuffer.append(URLEncoder.encode(string3, "UTF-8"));
            }
            if (n > 0) {
                stringBuffer.append("&depth=");
                stringBuffer.append(n);
            }
            stringBuffer.append("&wwidth=");
            stringBuffer.append(n2);
            stringBuffer.append("&hwidth=");
            stringBuffer.append(n3);
            stringBuffer.append("&awidth=");
            stringBuffer.append(n4);
            stringBuffer.append("&skip=");
            stringBuffer.append(condition.skip());
            stringBuffer.append("&mask=");
            stringBuffer.append(condition.mask());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return stringBuffer.toString();
    }

    public void set_url(String string) {
        this.url = string;
    }

    public void set_proxy(String string, int n) {
        this.pxhost = string;
        this.pxport = n;
    }

    public void set_timeout(int n) {
        this.timeout = n;
    }

    public void set_auth(String string, String string2) {
        this.auth = string + ':' + string2;
    }

    public int status() {
        return this.status;
    }

    public boolean sync() {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/sync");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = new byte[]{};
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, null);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean optimize() {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/optimize");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = new byte[]{};
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, null);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean put_doc(Document document) {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/put_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: text/x-estraier-draft");
            byte[] byArray = document.dump_draft().getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean out_doc(int n) {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/out_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = ("id=" + n).getBytes("ISO-8859-1");
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, null);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean out_doc_by_uri(String string) {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/out_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = ("uri=" + URLEncoder.encode(string, "UTF-8")).getBytes("ISO-8859-1");
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, null);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean edit_doc(Document document) {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/edit_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: text/x-estraier-draft");
            byte[] byArray = document.dump_draft().getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Document get_doc(int n) {
        this.status = -1;
        if (this.url == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/get_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = ("id=" + n).getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return null;
            }
            return new Document(byteArrayOutputStream.toString("UTF-8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Document get_doc_by_uri(String string) {
        this.status = -1;
        if (this.url == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/get_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = ("uri=" + URLEncoder.encode(string, "UTF-8")).getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return null;
            }
            return new Document(byteArrayOutputStream.toString("UTF-8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String get_doc_attr(int n, String string) {
        this.status = -1;
        if (this.url == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/get_doc_attr");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            String string2 = "id=" + n + "&attr=" + URLEncoder.encode(string, "UTF-8");
            byte[] byArray = string2.getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return null;
            }
            return byteArrayOutputStream.toString("UTF-8").trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String get_doc_attr_by_uri(String string, String string2) {
        this.status = -1;
        if (this.url == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/get_doc_attr");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            String string3 = "uri=" + URLEncoder.encode(string, "UTF-8") + "&attr=" + URLEncoder.encode(string2, "UTF-8");
            byte[] byArray = string3.getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return null;
            }
            return byteArrayOutputStream.toString("UTF-8").trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map etch_doc(int n) {
        this.status = -1;
        if (this.url == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/etch_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            String string = "id=" + n;
            byte[] byArray = string.getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(31);
            String[] stringArray = Utility.split_lines(byteArrayOutputStream.toString("UTF-8"));
            int n2 = 0;
            while (n2 < stringArray.length) {
                String[] stringArray2 = Utility.split_fields(stringArray[n2]);
                if (stringArray2.length >= 2) {
                    hashMap.put(stringArray2[0], stringArray2[1]);
                }
                ++n2;
            }
            return hashMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map etch_doc_by_uri(String string) {
        this.status = -1;
        if (this.url == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/etch_doc");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            String string2 = "uri=" + URLEncoder.encode(string, "UTF-8");
            byte[] byArray = string2.getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(31);
            String[] stringArray = Utility.split_lines(byteArrayOutputStream.toString("UTF-8"));
            int n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = Utility.split_fields(stringArray[n]);
                if (stringArray2.length >= 2) {
                    hashMap.put(stringArray2[0], stringArray2[1]);
                }
                ++n;
            }
            return hashMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int uri_to_id(String string) {
        this.status = -1;
        if (this.url == null) {
            return -1;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/uri_to_id");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = ("uri=" + URLEncoder.encode(string, "UTF-8")).getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return -1;
            }
            return Integer.parseInt(byteArrayOutputStream.toString("ISO-8859-1").trim());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String name() {
        if (this.name == null) {
            this.set_info();
        }
        return this.name;
    }

    public String label() {
        if (this.label == null) {
            this.set_info();
        }
        return this.label;
    }

    public int doc_num() {
        if (this.dnum < 0) {
            this.set_info();
        }
        return this.dnum;
    }

    public int word_num() {
        if (this.wnum < 0) {
            this.set_info();
        }
        return this.wnum;
    }

    public double size() {
        if (this.size < 0.0) {
            this.set_info();
        }
        return this.size;
    }

    public double cache_usage() {
        this.status = -1;
        if (this.url == null) {
            return -1.0;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/cacheusage");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, null, null, byteArrayOutputStream);
            if (this.status != 200) {
                return -1.0;
            }
            return Double.parseDouble(byteArrayOutputStream.toString("UTF-8").trim());
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public List admins() {
        if (this.admins == null) {
            this.set_info();
        }
        return this.admins;
    }

    public List users() {
        if (this.users == null) {
            this.set_info();
        }
        return this.users;
    }

    public List links() {
        if (this.links == null) {
            this.set_info();
        }
        return this.links;
    }

    public NodeResult search(Condition condition, int n) {
        this.status = -1;
        if (this.url == null) {
            return null;
        }
        try {
            CharSequence charSequence;
            Object object;
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/search");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            byte[] byArray = Node.cond_to_query(condition, n, this.wwidth, this.hwidth, this.awidth).getBytes("ISO-8859-1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, byteArrayOutputStream);
            if (this.status != 200) {
                return null;
            }
            String[] stringArray = Utility.split_lines(byteArrayOutputStream.toString("UTF-8"));
            if (stringArray.length < 1) {
                return null;
            }
            ArrayList<ResultDocument> arrayList2 = new ArrayList<ResultDocument>(31);
            HashMap<Object, CharSequence> hashMap = new HashMap<Object, CharSequence>(31);
            NodeResult nodeResult = new NodeResult(arrayList2, hashMap);
            String string = stringArray[0];
            boolean bl = false;
            int n2 = 1;
            while (n2 < stringArray.length) {
                String string2;
                if ((string2 = stringArray[n2++]).startsWith(string)) {
                    if (!string2.substring(string.length(), string2.length()).equals(":END")) break;
                    bl = true;
                    break;
                }
                int n3 = string2.indexOf(9);
                if (n3 == -1) continue;
                object = string2.substring(0, n3);
                charSequence = string2.substring(n3 + 1, string2.length());
                hashMap.put(object, charSequence);
            }
            int n4 = n2;
            while (!bl && n2 < stringArray.length) {
                String string3;
                if (!(string3 = stringArray[n2++]).startsWith(string)) continue;
                if (n2 > n4) {
                    Object object2;
                    String string4;
                    object = new HashMap(31);
                    charSequence = new StringBuffer();
                    String string5 = "";
                    int n5 = n4;
                    while (n5 < n2 - 1) {
                        int n6;
                        if ((string4 = stringArray[n5++].trim()).length() < 1) break;
                        if (string4.startsWith("%")) {
                            n6 = string4.indexOf(9);
                            if (!string4.startsWith("%VECTOR") || n6 == -1) continue;
                            string5 = string4.substring(n6 + 1, string4.length());
                            continue;
                        }
                        n6 = string4.indexOf(61);
                        if (n6 == -1) continue;
                        object2 = string4.substring(0, n6);
                        String string6 = string4.substring(n6 + 1, string4.length());
                        object.put(object2, string6);
                    }
                    while (n5 < n2 - 1) {
                        string4 = stringArray[n5++];
                        ((StringBuffer)charSequence).append(string4);
                        ((StringBuffer)charSequence).append("\n");
                    }
                    string4 = (String)object.get("@uri");
                    String string7 = ((StringBuffer)charSequence).toString();
                    if (string4 != null) {
                        object2 = new ResultDocument(string4, (Map)object, string7, string5);
                        arrayList2.add((ResultDocument)object2);
                    }
                }
                n4 = n2;
                if (!string3.substring(string.length(), string3.length()).equals(":END")) continue;
                bl = true;
            }
            if (!bl) {
                return null;
            }
            return nodeResult;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void set_snippet_width(int n, int n2, int n3) {
        this.wwidth = n;
        if (n2 >= 0) {
            this.hwidth = n2;
        }
        if (n3 >= 0) {
            this.awidth = n3;
        }
    }

    public boolean set_user(String string, int n) {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/_set_user");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            String string2 = "name=" + URLEncoder.encode(string, "UTF-8") + "&mode=" + n;
            byte[] byArray = string2.getBytes("ISO-8859-1");
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, null);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean set_link(String string, String string2, int n) {
        this.status = -1;
        if (this.url == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/_set_link");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            arrayList.add("Content-Type: application/x-www-form-urlencoded");
            String string3 = "url=" + URLEncoder.encode(string, "UTF-8") + "&label=" + URLEncoder.encode(string2, "UTF-8");
            if (n >= 0) {
                string3 = string3 + "&credit=" + n;
            }
            byte[] byArray = string3.getBytes("ISO-8859-1");
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, byArray, null, null);
            return this.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final void set_info() {
        this.status = -1;
        if (this.url == null) {
            return;
        }
        try {
            String string;
            URL uRL = new URL(this.url);
            URL uRL2 = new URL("http://" + uRL.getHost() + ':' + uRL.getPort() + uRL.getPath() + "/inform");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (this.auth != null) {
                arrayList.add("Authorization: Basic " + Utility.base_encode(this.auth.getBytes()));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.status = Utility.shuttle_url(uRL2.toString(), this.pxhost, this.pxport, this.timeout, arrayList, null, null, byteArrayOutputStream);
            if (this.status != 200) {
                return;
            }
            String string2 = byteArrayOutputStream.toString("UTF-8");
            String[] stringArray = Utility.split_lines(string2);
            if (stringArray.length < 1) {
                return;
            }
            String[] stringArray2 = Utility.split_fields(stringArray[0]);
            if (stringArray2.length != 5) {
                return;
            }
            this.name = stringArray2[0];
            this.label = stringArray2[1];
            this.dnum = Integer.parseInt(stringArray2[2]);
            this.wnum = Integer.parseInt(stringArray2[3]);
            this.size = Double.parseDouble(stringArray2[4]);
            if (this.dnum < 0 || this.wnum < 0 || this.size < 0.0) {
                this.dnum = -1;
                this.wnum = -1;
                this.size = -1.0;
            }
            if (stringArray.length < 2) {
                return;
            }
            int n = 1;
            if (n < stringArray.length && stringArray[n].length() < 1) {
                ++n;
            }
            this.admins = new ArrayList();
            while (n < stringArray.length) {
                string = stringArray[n];
                if (string.length() < 1) break;
                this.admins.add(string);
                ++n;
            }
            if (n < stringArray.length && stringArray[n].length() < 1) {
                ++n;
            }
            this.users = new ArrayList();
            while (n < stringArray.length) {
                string = stringArray[n];
                if (string.length() < 1) break;
                this.users.add(string);
                ++n;
            }
            if (n < stringArray.length && stringArray[n].length() < 1) {
                ++n;
            }
            this.links = new ArrayList();
            while (n < stringArray.length) {
                string = stringArray[n];
                if (string.length() >= 1) {
                    if (Utility.split_fields(string).length == 3) {
                        this.links.add(string);
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.name = null;
            this.label = null;
            this.dnum = -1;
            this.wnum = -1;
            this.size = -1.0;
            this.admins = null;
            this.users = null;
            this.links = null;
        }
    }
}

